<?php
namespace slock;
/**
* 智能门锁
*/
class Slock{
	//配置
	public $config;

	//接口URL
	protected $api_url='https://yylock.eeun.cn/dms/app';
	
	//protected $api_url='https://www.unitezj.com:9091/dms/app';


	public function __construct($config=[]) {   
        $this->config = (object)$config;
        $url=request()->domain();
        if(strpos($url,'gedao.youdiy.cn') !== false){ 
		  $this->api_url="https://www.unitezj.com:9091/dms/app";
		}
		
    }
    /*
		DMS登录    
     */
    public function dmsLogin(){
	    	$params['APPID']=$this->config->appid;
	    	$params['AT']=time()*1000;
            $params['USERNAME']=$this->config->username;
            $params['PASSWORD']=$this->config->password;
	    	$params['NONCESTR']=rand(100000,999999).rand(100000,999999).rand(1000,9999);
	    	$params['SIGN']=self::createSign($params);
	    	$url=$this->api_url.'/dmsLogin';
	    	$res=self::httpRequest($url,"POST",$params);
	    	$res=json_decode($res,1);
	    	if($res['result']==0){
	    		return ['code'=>0,'data'=>$res['token']];
	    	}else{
	    		return ['code'=>$res['result'],'msg'=>$res['msg']];
	    	}
    }
    /*
		二维码开门 
		APPID	是	string	APPID
		AT	是	string	时间戳（毫秒为单位）
		ENDDATE	是	string	结束时间 (格式：年月日时分秒)
		KEYLOCKID	是	string	锁的设备ID
		NONCESTR	是	string	随机码
		STARTDATE	是	string	开始时间 (格式：年月日时分秒)
		TIMEZONE	否	string	时区（如东八区填写 -8 ）
		TOKEN	是	string	会话token
		SAVEFLAGE	否	string	是否保存标志，1：保存 0：不保存。 默认值为0。
		USERID	是	string	用户手机号
		VALIDMINUTE	是	int	二维码有效时长（分钟为单位）
		SIGN   
     */
	public function getLockQRCode($data=[]){
		$params['APPID']=$this->config->appid;
	    $params['AT']=time()*1000;
	    $params['ENDDATE']=$data['enddate'];
	    $params['STARTDATE']=$data['startdate'];
	    $params['KEYLOCKID']=$data['keylockid'];
	    $params['NONCESTR']=rand(1000,9999).rand(1000,9999);;
	    $params['USERID']=$data['userid'];
	    $params['VALIDMINUTE']=$data['validminute'];
	    $params['SAVEFLAGE']="0";
	    $params['TIMEZONE']=-8;
	    $res=self::dmsLogin();
	    if($res['code']!=0){
	    	return $res;
	    }
	    $params['TOKEN']=$res['data'];
	    $params['SIGN']=self::createSign($params);
	   
	    $url=$this->api_url.'/getLockQRCode';
	    $res=self::httpRequest($url,"POST",$params);
    	$res=json_decode($res,1);
    	if($res['result']==0){
    		return ['code'=>0,'data'=>$res['data']];
    	}else{
    		return ['code'=>$res['result'],'msg'=>$res['msg']];
    	}
	}
	/*
	    配置自动跳闸时间
	    取电开关
	  	APPID	是	string	APPID
		AT	是	string	时间戳（毫秒为单位）
		LOCKID	是	string	设备ID
		OPERATE	是	string	操作类型：固定值为5B
		PARAMS01	是	string	操作参数：固定值为5
		PARAMS02	是	string	操作参数：固定值为1
		PARAMS03	是	string	断电时间，格式(年-月-日 时:分:秒)：2021-03-13 14:00:00
		NONCESTR	是	string	随机码
		TOKEN	是	string	会话token
		SIGN
	 */
	public function operateLinkage($data=[]){
		$params['APPID']=$this->config->appid;
	    $params['AT']=time()*1000;
	    $params['LOCKID']=$data['lockid'];
	    $params['OPERATE']="5B";
	    $params['PARAMS01']=5;
	    $params['PARAMS02']=1;
	    $params['PARAMS03']=$data['end_time'];
	    $params['NONCESTR']=rand(1000,9999);
	    $res=self::dmsLogin();
	    if($res['code']!=0){
	    	return $res;
	    }
	    $params['TOKEN']=$res['data'];
	    $params['SIGN']=self::createSign($params);
	    $url=$this->api_url.'/operateLinkage';
	    $res=self::httpRequest($url,"POST",$params);
    	$res=json_decode($res,1);
    	if($res['result']==0){
    		return ['code'=>0,'data'=>$res['data']];
    	}else{
    		return ['code'=>$res['result'],'msg'=>$res['msg']];
    	}
	}
	//一键开锁
	public function openRemoteDeviceLock($data=[],$status=1){

		$params['APPID']=$this->config->appid;
	    $params['AT']=time()*1000;
	    $params['DEVICE_ID']=$data['keylockid'];
	    $params['MASTERSLAVE']=1;
	    $params['NONCESTR']=rand(1000,9999);
	    $params['OPENCLOSEACTION']=$status;//开锁1,0关锁
	    $res=self::dmsLogin();
	    if($res['code']!=0){
	    	return $res;
	    }
	    $params['TOKEN']=$res['data'];
	    $params['SIGN']=self::createSign($params);
	    $url=$this->api_url.'/openRemoteDeviceLock';
	    $res=self::httpRequest($url,"POST",$params);
    	$res=json_decode($res,1);
    	if($res['result']==0){
    		return ['code'=>0,'data'=>$res['data']];
    	}else{
    		return ['code'=>$res['result'],'msg'=>$res['msg']];
    	}
	}
  
    /**
     * 生成签名
     * @return 签名，本函数不覆盖sign成员变量，如要设置签名需要调用SetSign方法赋值
     */
    public function createSign($params=[]) {
	        if (is_null($this->config->appkey)) {
	            die('缺少参数key 41004');
	        }
	        //签名步骤一：按字典序排序参数
	        ksort($params);
	        $string = http_build_query($params);
	        //签名步骤二：在string后加入KEY
	        $string = $string . "&APPKEY=".$this->config->appkey;
	        //签名步骤三：MD5加密
	        $string = md5($string);
	        //签名步骤四：所有字符转为大写
	        $result = strtoupper($string);
	        return $result;
    }

    /**
	 * CURL请求
	 * @param $url 请求url地址
	 * @param $method 请求方法 get post
	 * @param null $postfields post数据数组
	 * @param array $headers 请求header信息
	 * @param bool|false $debug 调试开启 默认false
	 * @return mixed
	 */
	private function httpRequest($url, $method = "GET", $postfields = null, $headers = array(), $debug = false){
		    $method = strtoupper($method);
		    $ci = curl_init();
		    /* Curl settings */
		    curl_setopt($ci, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_0);//版本
		    curl_setopt($ci, CURLOPT_USERAGENT, "Mozilla/5.0 (Windows NT 6.2; WOW64; rv:34.0) Gecko/20100101 Firefox/34.0");//在HTTP请求中包含一个"User-Agent: "头的字符串。
		    curl_setopt($ci, CURLOPT_CONNECTTIMEOUT, 60); /* 在发起连接前等待的时间，如果设置为0，则无限等待 */
		    curl_setopt($ci, CURLOPT_TIMEOUT, 7); /* 设置cURL允许执行的最长秒数 */
		    curl_setopt($ci, CURLOPT_RETURNTRANSFER, true);//将curl_exec()获取的信息以文件流的形式返回，而不是直接输出。
		    switch ($method) {
		        case "POST":
		            curl_setopt($ci, CURLOPT_POST, true);//启用时会发送一个常规的POST请求，类型为：application/x-www-form-urlencoded，就像表单提交的一样。
		            if (!empty($postfields)) {
		                $tmpdatastr = is_array($postfields) ? http_build_query($postfields) : $postfields;
		                curl_setopt($ci, CURLOPT_POSTFIELDS, $tmpdatastr);
		            }
		            break;
		        default:
		            curl_setopt($ci, CURLOPT_CUSTOMREQUEST, $method); /* //设置请求方式 */
		            break;
		    }
		    $ssl = preg_match('/^https:\/\//i', $url) ? TRUE : FALSE;
		    curl_setopt($ci, CURLOPT_URL, $url);//需要获取的URL地址，也可以在curl_init()函数中设置
		    if ($ssl) {
		        curl_setopt($ci, CURLOPT_SSL_VERIFYPEER, FALSE); // https请求 不验证证书和hosts
		        curl_setopt($ci, CURLOPT_SSL_VERIFYHOST, FALSE); // 不从证书中检查SSL加密算法是否存在
		    }
		    //curl_setopt($ci, CURLOPT_HEADER, true); /*启用时会将头文件的信息作为数据流输出*/
		    curl_setopt($ci, CURLOPT_FOLLOWLOCATION, 1);
		    curl_setopt($ci, CURLOPT_MAXREDIRS, 2);/*指定最多的HTTP重定向的数量，这个选项是和CURLOPT_FOLLOWLOCATION一起使用的*/
		    curl_setopt($ci, CURLOPT_HTTPHEADER, $headers);
		    curl_setopt($ci, CURLINFO_HEADER_OUT, true);
		    /*curl_setopt($ci, CURLOPT_COOKIE, $Cookiestr); * *COOKIE带过去** */
		    $response = curl_exec($ci);
		    $requestinfo = curl_getinfo($ci);
		    curl_close($ci);
		    return $response;
	}
}
