<?php
namespace app\task\controller;
 
use think\facade\Queue;
use think\queue\Job;
 
class Task{
 
	//接收数据
	public function fire(Job $job, $data)
    {
    	
        $isJobDone = $this->actionJob($data);
        // 如果任务执行成功后 记得删除任务，不然这个任务会重复执行，直到达到最大重试次数后失败后，执行failed方法
        if ($isJobDone) {
           $job->delete();
        } else {
            //通过这个方法可以检查这个任务已经重试了几次了
            $attempts = $job->attempts();
            if ($attempts == 0 || $attempts == 1) {
                // 重新发布这个任务
                $job->release(2); //$delay为延迟时间，延迟2S后继续执行
            } elseif ($attempts == 2) {
                $job->release(5); // 延迟5S后继续执行
            }
        }
    }
    /**
     * @Desc: 加入的队列任务
     */
    private function actionJob($data=[])
    {
		$class=base64_decode($data['class']);
		$res=$class::{$data['action']}($data['data']);
		if($res['code']==0){
			return true;
		}else{
			return false;
		}
    }
	/**
	* @Desc: 链接处理函数
	*/
	static public function UrlHandle($data=[])
	{
	    // 当前任务归属的队列名称，如果为新队列，会自动创建
	    $queueName = 'QYTASKELE';
	    // 将该任务推送到消息队列，等待对应的消费者去执行
	    $isPushed = Queue::push(Task::class, $data, $queueName);
	    // database 驱动时，返回值为 1|false; redis驱动时，返回值为 随机字符串|false
	    if ($isPushed !== false) {
	    	
	       return ['code'=>0,'msg'=>'加入队列成功'];
	    } else {
	    	
	       return ['code'=>1,'msg'=>'队列错误'];
	    }
	}
	/**
	* @Desc: 链接处理延迟函数
	*/
	static public function UrlHandleDelay($data=[],$delay=0)
	{
	    // 当前任务归属的队列名称，如果为新队列，会自动创建
	    $queueName = 'QYTASKELE';
	    // 将该任务推送到消息队列，等待对应的消费者去执行
	    if($delay>0){
	    	$isPushed =Queue::later($delay,Task::class, $data, $queueName);
	    }else{
	    	$isPushed =Queue::push(Task::class, $data, $queueName);
	    }
	    // database 驱动时，返回值为 1|false; redis驱动时，返回值为 随机字符串|false
	    if ($isPushed !== false) {
	    	
	       return ['code'=>0,'msg'=>'加入队列成功'];
	    } else {
	    	
	       return ['code'=>1,'msg'=>'队列错误'];
	    }
	}
}
 
