<?php
namespace app\task\controller;
use think\facade\Cache;
use app\shared\model\User;
use app\shared\model\PartnerUserBill;
use app\shared\model\Option;
use app\shared\model\PartnerUser;
use think\facade\Db;
//合伙人账单通知
//
class Message
{
	public function partnerBillNotice(){
	   $acid=input('acid');
	   $config=Option::get_data($acid,'shared','cloudSheetConfig');
       if($config){
          $config=json_decode($config,1);
          $could=new  \CloudSheet\CloudSheet($config['title'],$config['apiKey']);
         
		  $list=PartnerUser::alias('ptu')
		  ->leftJoin([User::getTable()=>'u'],'ptu.user_id=u.id')
		  ->where([
		    'ptu.acid'=>$acid,
		    'ptu.status'=>1			
		  ])->column('u.account,ptu.id');
		  $tpl=Option::get_data($acid,'shared','cloudSheetConfigTplMsg');
          if(!$tpl){
             $config['ptu_arrive_tpl']="";
             $config['ptu_expire_tpl']="";
          }else{
             $tpl=json_decode($tpl,1);
             $config['ptu_arrive_tpl']=$tpl['ptu_arrive_tpl'];
             $config['ptu_expire_tpl']=$tpl['ptu_expire_tpl'];
          }
          foreach ($list as $key=>$value){
                 $partnerUser=PartnerUser::where([
                    'user_id'=>$value['id'],
                    'status'=>1
                 ])->find();
                 if($partnerUser){
                  if($partnerUser->end_time>0&&$partnerUser->end_time<time()){
                      $partnerUser->status=0;
                      $partnerUser->save();
                      continue;
                   }
                   if($partnerUser->start_time<time()){
                      $time=date('Y-m-d',time());
                      $time=strtotime($time);
                      $startTime=strtotime(date("Y-m-d",$partnerUser->start_time));
                      $num=($time-$startTime)/86400;   
                      if($num>0){
                            for($i=1;$i<=$num;$i++){
                                $partnerUser=PartnerUser::where([
                                    'user_id'=>$value['id'],
                                    'status'=>1
                                 ])->find();
                                $create_time=$startTime+(86400*$i)+28800;
                                if($partnerUser->give_lngot>=$partnerUser->everyday_lngot){
                                     if(PartnerUserBill::where([
                                        'acid'=>$acid,
                                        'user_id'=>$partnerUser->id,
                                        'order_id'=>-1,
                                        'lngot'=>$partnerUser->everyday_lngot,
                                        'price'=>0,
                                        'status'=>1,
                                        'create_time'=>$create_time,
                                        'update_time'=>$create_time
                                     ])->count()){
                                       continue;
                                     }else{
                                        (new PartnerUserBill())->save([
                                            'acid'=>$acid,
                                            'user_id'=>$partnerUser->id,
                                            'order_id'=>-1,
                                            'title'=>'每日领取',
                                            'lngot'=>$partnerUser->everyday_lngot,
                                            'price'=>0,
                                            'status'=>1,
                                            'create_time'=>$create_time,
                                            'update_time'=>$create_time
                                         ]);
                                         $partnerUser->give_lngot-=$partnerUser->everyday_lngot;
                                         $partnerUser->sum_lngot+=$partnerUser->everyday_lngot;
                                         $partnerUser->save();
                                     }
                                 }
                            }
                      }
                   }
                }
                $title=$config['ptu_arrive_tpl'];
                $res=$could->SendMsg($title,$value['account']);
                if(($partnerUser->end_time-86400)<time()){
                    $title=$config['ptu_expire_tpl'];
                   $res=$could->SendMsg($title,$value['account']);
                }
            }
          
      }
      echo("success");
	}
  
}