<?php
namespace app\shared\model;
use app\shared\model\Option;
use app\shared\model\App;
use think\exception\ValidateException;
use app\BaseController;

//课程规格
class WxSubscription 
{
     public $acid;
     public function sendMsg($acid=null,$module=null,$fun=null,$open_id=null,$msg=[]){
            switch ($module) {
              //茶室
              case 'shared':
                switch ($fun) {
                  case 'wx_subscibe_book_inform'://预约通知
                   return self::wx_subscibe_book_inform($acid,$open_id,$msg);
                    break;
                  case 'wx_subscibe_book_finish'://预约通知
                   return self::wx_subscibe_book_finish($acid,$open_id,$msg);
                    break;
                  case 'wx_subscibe_book_overtime'://预约通知
                   return self::wx_subscibe_book_overtime($acid,$open_id,$msg);
                    break;
                  case 'wx_subscibe_book_sweep'://预约通知
                   return self::wx_subscibe_book_sweep($acid,$open_id,$msg);
                    break;
                  case 'wx_subscibe_tea_specia_order_inform'://预约通知
                   return self::wx_subscibe_tea_specia_order_inform($acid,$open_id,$msg);
                    break;
                  case 'wx_subscibe_tea_specia_order_finish'://预约通知
                   return self::wx_subscibe_tea_specia_order_finish($acid,$open_id,$msg);
                    break;    
                  default:
                    break;
                }
                break;
              
              default:
                
                break;
            }
      }
    //预约通知
    public function wx_subscibe_book_inform($acid=[],$open_id=null,$msg=[]){
        $data = [
            'touser' =>$open_id,
            'template_id' => $acid['wx_subscibe_book_inform'],
            'page'=>$msg['page'],
            'data' => [
                'thing6' => [
                    'value' => $msg['title'],//商家名称
                    'color' => '#333333',
                ],
                'date3' => [
                    'value' => date('Y-m-d H:i:s',$msg['start_time']),//预约时间
                    'color' => '#333333',
                ],
                'phone_number4' => [
                    'value' => $msg['phone'],//联系电话    
                    'color' => '#333333',
                ]
            ],
        ];
        $form=new \weixin\Wechat();
        return $form->sendSubscibeMsg($acid,$data); 
    }
    //预约结束提醒
    public function wx_subscibe_book_finish($acid=[],$open_id=null,$msg=[]){
        $data = [
            'touser' =>$open_id,
            'template_id' => $acid['wx_subscibe_book_finish'],
            'page'=>$msg['page'],
            'data' => [
                'time1' => [
                    'value' => date('Y-m-d H:i:s',$msg['end_time']),//结束时间
                    'color' => '#333333',
                ],
                'thing2' => [
                    'value' => '即将关闭电源',//备注    
                    'color' => '#333333',
                ]
            ],
        ];
        $form=new \weixin\Wechat();
        return $form->sendSubscibeMsg($acid,$data); 
    }

    //无人茶舍续单提醒
    public function wx_subscibe_book_overtime($acid=null,$open_id=null,$msg=[]){
        $data = [
            'touser' =>$open_id,
            'template_id' => $acid['wx_subscibe_book_overtime'],
            'page'=>$msg['page'],
            'data' => [
                'character_string1' => [
                    'value' => $msg['order_no'],//订单编号    
                    'color' => '#333333',
                ],
                'time2' => [
                    'value' => date('Y-m-d H:i:s',$msg['start_time']),//开始时间
                    'color' => '#333333',
                ],
                'time3' => [
                    'value' => date('Y-m-d H:i:s',$msg['end_time']),//结束时间
                    'color' => '#333333',
                ],
                'thing4' => [
                    'value' => '您是否需要续单呢？',//备注
                    'color' => '#333333',
                ],
            ],
        ];
        $form=new \weixin\Wechat();
        return $form->sendSubscibeMsg($acid,$data); 
    }
    //订单完成时间
    public function wx_subscibe_book_sweep($acid=null,$open_id=null,$msg=[]){
        $data = [
            'touser' =>$open_id,
            'template_id' => $acid['wx_subscibe_book_sweep'],
            'page'=>$msg['page'],
            'data' => [
                'thing4' => [
                    'value' => '有新的结束订单~',//温馨提示    
                    'color' => '#333333',
                ],
                'thing1' => [
                    'value' => $msg['title'],//地点名称
                    'color' => '#333333',
                ],
            ],
        ];
        $form=new \weixin\Wechat();
        return $form->sendSubscibeMsg($acid,$data); 
    }
    //小程序茶艺师接单订单通知
    public function wx_subscibe_tea_specia_order_inform($acid=null,$open_id=null,$msg=[]){
        $data = [
            'touser' =>$open_id,
            'template_id' => $acid['wx_subscibe_tea_specia_order_inform'],
            'page'=>$msg['page'],
            'data' => [
                'character_string1' => [
                    'value' => $msg['order_no'],//订单编号    
                    'color' => '#333333',
                ],
                'amount2' => [
                    'value' => $msg['price'],//订单金额    
                    'color' => '#333333',
                ],
                'thing3' => [
                    'value' => $msg['username'],//联系人    
                    'color' => '#333333',
                ],
                'phone_number4' => [
                    'value' => $msg['tel'],//联系电话
                    'color' => '#333333',
                ],
            ],
        ];
        $form=new \weixin\Wechat();
        return $form->sendSubscibeMsg($acid,$data); 
    }
    //小程序茶艺师服务完成确认通知
    public function wx_subscibe_tea_specia_order_finish($acid=null,$open_id=null,$msg=[]){
        $data = [
            'touser' =>$open_id,
            'template_id' => $acid['wx_subscibe_tea_specia_order_finish'],
            'page'=>$msg['page'],
            'data' => [
                'thing1' => [
                    'value' => $msg['username'], //顾客姓名    
                    'color' => '#333333',
                ],
                'time2' => [
                    'value' => $msg['time'],    //服务时间
                    'color' => '#333333',
                ],
                'thing6' => [
                    'value' => $msg['dec'], //备注
                    'color' => '#333333',
                ],
            ],
        ];
        // p($data);
        // die;
        $form=new \weixin\Wechat();
        return $form->sendSubscibeMsg($acid,$data); 
    }
    public function addTplData($acid=0){
      $addList=[
        [
          'tid'=>461,
          'kidList'=>[6,3,4],
          'name'=>'wx_subscibe_book_inform',
          'desc'=>'预约通知'//'预约通知'
        ],
        [
          'tid'=>24449,
          'kidList'=>[1,2],
          'name'=>'wx_subscibe_book_finish',
          'desc'=>'无人茶舍结束提醒'//'无人茶舍结束提醒'
        ],
        [
          'tid'=>24448,
          'kidList'=>[1,2,3,4],
          'name'=>'wx_subscibe_book_overtime',
          'desc'=>'无人茶舍续单提醒'//'无人茶舍续单提醒'
        ],
        [
          'tid'=>706,
          'kidList'=>[4,1],
          'name'=>'wx_subscibe_book_sweep',//预订打扫
          'desc'=>'订单完成时间'//'订单完成时间'
        ],
        [
          'tid'=>19830,
          'kidList'=>[1,2,3,4],
          'name'=>'wx_subscibe_tea_specia_order_inform',//预订打扫
          'desc'=>'接单提醒'//'接单提醒'
        ],
        [
          'tid'=>17507,
          'kidList'=>[1,2,6],
          'name'=>'wx_subscibe_tea_specia_order_finish',//预订打扫
          'desc'=>'服务完成确认通知'//'服务完成确认通知'
        ],
      ];
      $json=self::gettemplate($acid);
      $json=json_decode($json,1);
      $onlineData=[];
      if(isset($json['errcode'])){
            if($json['errcode']==0){
                foreach ($json['data'] as $value) {
                    $onlineData[$value['priTmplId']]=$value['title'];
                }
            }
      }
      foreach($addList as $key=>&$value) {
         if($kk=array_search($value['desc'], $onlineData)){
            $value['tpl']=$kk;
         }else{
            $value['tpl']=self::addTemplate($acid,$value['tid'],$value['kidList'],$value['desc']);
         }
         unset($value['tid']);
         unset($value['kidList']);
      }
      return $addList;
   }
   private function addTemplate($acid,$tid, $kidList, $sceneDesc){
        $api = "https://api.weixin.qq.com/wxaapi/newtmpl/addtemplate?access_token={$this->getToken($acid)}";

        $res=httpRequest($api,"POST",[
            'tid' => $tid,
            'kidList' => $kidList,
            'sceneDesc' => $sceneDesc
        ]);

        $json=json_decode($res,1);

        if(isset($json['errcode'])){
            if($json['errcode']==0){
              return $json['priTmplId'];
            }
           return '';
        }
        return '';
    }
    private function gettemplate($acid=1){
        $api = "https://api.weixin.qq.com/wxaapi/newtmpl/gettemplate?access_token={$this->getToken($acid)}";
        return httpRequest($api);
        
    }
     //获取微信令牌
    private function getToken($acid=1)
    {
        $form=new \weixin\Wechat();
        $wx=App::find($acid);
        $appid=$wx->wxapp_app_id;
        $secret=$wx->wxapp_app_secret;
        $url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid={$appid}&secret={$secret}";
        $data=httpRequest($url);
        $data=json_decode($data);
        if(isset($data->access_token)){
            return ($data->access_token);
        }else{
            die(json_encode(['code'=>-1,'data'=>'','msg'=>'access_token获取错误请检查微信参数是否错误']));
        }
    }

}