<?php


namespace app\shared\model;

use think\Model as ThinkModel;

class Theme
{
	//主题列表
    static public function themeList(){
        $url=request()->domain().str_replace('index.php', '',request()->baseFile()).'static/shared/';
    	$list=[
    		[
    			'type'=>'default',
    			'bgcolor'=>'#202251',
    			'color'=>'#202251',
    			'title'=>'默认版',
                'more_icon'=>$url.'tabBar/more.png',
                'local_icon'=>$url.'tabBar/local_icon.png',
                'local_t'=>$url.'tabBar/local_T.png',
                'local_l'=>$url.'tabBar/local_T.png',
                'park'=>$url.'tabBar/park.png',
    			'is_select'=>false,
    			'tea_specialist'=>[
    				'status'=>true,
    				'title'=>'茶艺师',
    				'icon'=>$url.'tea_specialist.png'
    			],
    			'repeat_order'=>[
    				'status'=>true,
    				'title'=>'续单',
    				'icon'=>$url.'reorder.png'
    			],
    			'open_code'=>[
    				'status'=>true,
    				'title'=>'开门码',
    				'icon'=>$url.'openCode.png'
    			],
                'service'=>[
                    'status'=>true,
                    'title'=>'客服',
                    'icon'=>$url.'keFu.png'
                ],
                'service_tel'=>[
                    'status'=>false,
                    'title'=>'客服电话',
                    'icon'=>$url.'keFu.png',
                    'tel'=>''
                ],
                'tea_circle'=>[
                    'status'=>false,
                    'title'=>'茶圈',
                    'icon'=>$url.'tea_circle.png',
                    'tel'=>''
                ],
    			'footer'=>[
    				'status'=>true,
    				'list'=>[
    					[
    					    'status'=>true,
    					    'title'=>'首页',
    					    'icon'=>$url.'tabBar/tb_home_unsel.png',
                            'select_icon'=>$url.'tabBar/tb_home_sel.png',
                            'pages'=>'/pages/index/index'
    					],
    					[
	    					'status'=>true,
	    					'title'=>'约茶',
	    					'icon'=>$url.'tabBar/book.png',
                            'select_icon'=>$url.'tabBar/book.png',
                            'pages'=>'/pages/aboutTea/index'

    					],
    					[
    						'status'=>true,
    					    'title'=>'我的',
    					    'icon'=>$url.'tabBar/tb_my_unsel.png',
                            'select_icon'=>$url.'tabBar/tb_my_sel.png',
                            'pages'=>'/pages/user/index'
    					],
    				]
    			],
    		],
    		[
                'type'=>'refreshing',
                'bgcolor'=>'#48A584',
                'color'=>'#48A584',
                'title'=>'清爽版',
                'more_icon'=>$url.'tabBar/more.png',
                'local_icon'=>$url.'tabBar/local_icon.png',
                'local_t'=>$url.'tabBar/local_T.png',
                'local_l'=>$url.'tabBar/local_T.png',
                'park'=>$url.'tabBar/park.png',
                'is_select'=>true,
                'tea_specialist'=>[
                    'status'=>true,
                    'title'=>'茶艺师',
                    'icon'=>$url.'tea_specialist2.png'
                ],
                'repeat_order'=>[
                    'status'=>true,
                    'title'=>'续单',
                    'icon'=>$url.'reorder2.png'
                ],
                'open_code'=>[
                    'status'=>true,
                    'title'=>'开门码',
                    'icon'=>$url.'openCode2.png'
                ],
                'service'=>[
                    'status'=>true,
                    'title'=>'客服',
                    'icon'=>$url.'keFu.png'
                ],
                'service_tel'=>[
                    'status'=>false,
                    'title'=>'客服电话',
                    'icon'=>$url.'keFu.png',
                    'tel'=>''
                ],
                'tea_circle'=>[
                    'status'=>false,
                    'title'=>'茶圈',
                    'icon'=>$url.'tea_circle.png',
                    'tel'=>''
                ],
                'footer'=>[
                    'status'=>true,
                    'button'=>[
                        'title'=>'预约茶室',
                        'icon'=>$url.'tabBar/nearbyStore.png',
                        'select_icon'=>$url.'tabBar/nearbyStore.png',
                        'pages'=>'/pages/aboutTea/index'
                    ],
                    'recharge'=>[
                        'title'=>'充值',
                        'icon'=>$url.'tabBar/recharge.png',
                        'select_icon'=>$url.'tabBar/recharge.png',
                        'pages'=>'/pages/user/myPurse/index'
                    ],
                    'personal'=>[
                        'title'=>'我的',
                        'icon'=>$url.'tabBar/tb_home_unsel.png',
                        'select_icon'=>$url.'tabBar/tb_home_sel.png',
                        'pages'=>'/pages/user/index'
                    ]
                ],
            ],
            [
                'type'=>'plasmogamy',
                'bgcolor'=>'#5EB1B5',
                'color'=>'#FFFFFF',
                'title'=>'致雅版',
                'is_select'=>false,
                'more_icon'=>$url.'tabBar/more.png?time='.time(),
                'local_icon'=>$url.'tabBar/local_icon.png?time='.time(),
                'local_t'=>$url.'tabBar/local_T.png?time='.time(),
                'local_l'=>$url.'tabBar/local_T.png?time='.time(),
                'park'=>$url.'tabBar/park.png?time='.time(),
                'tea_specialist'=>[
                    'status'=>true,
                    'title'=>'茶艺师',
                    'icon'=>$url.'tea_specialist2.png?time='.time(),
                ],
                'repeat_order'=>[
                    'status'=>true,
                    'title'=>'续单',
                    'icon'=>$url.'reorder2.png?time='.time(),
                ],
                'open_code'=>[
                    'status'=>true,
                    'title'=>'开门码',
                    'icon'=>$url.'openCode2.png?time='.time(),
                ],
                'service'=>[
                    'status'=>true,
                    'title'=>'客服',
                    'icon'=>$url.'keFu.png?time='.time(),
                ],
                'service_tel'=>[
                    'status'=>false,
                    'title'=>'客服电话',
                    'icon'=>$url.'keFu.png?time='.time(),
                    'tel'=>''
                ],
                'tea_circle'=>[
                    'status'=>false,
                    'title'=>'茶圈',
                    'icon'=>$url.'tea_circle.png?time='.time(),
                    'tel'=>''
                ],
                'footer'=>[
                    'status'=>true,
                    'button'=>[
                        'title'=>'预约茶室',
                        'icon'=>$url.'tabBar/nearbyStore.png?time='.time(),
                        'select_icon'=>$url.'tabBar/nearbyStore.png?time='.time(),
                        'pages'=>'/pages/aboutTea/index'
                    ],
                    'recharge'=>[
                        'title'=>'充值',
                        'icon'=>$url.'tabBar/recharge.png?time='.time(),
                        'select_icon'=>$url.'tabBar/recharge.png?time='.time(),
                        'pages'=>'/pages/user/myPurse/purseList'
                    ],
                    'personal'=>[
                        'title'=>'个人中心',
                        'icon'=>$url.'tabBar/my.png?time='.time(),
                        'select_icon'=>$url.'tabBar/my.png?time='.time(),
                        'pages'=>'/pages/user/index'
                    ]
                ],
            ],
            [
                'type'=>'fashion',
                'bgcolor'=>'#48A584',
                'color'=>'#48A584',
                'title'=>'风尚版',
                'is_select'=>false,
                'more_icon'=>$url.'tabBar/more.png',
                'local_icon'=>$url.'tabBar/local_icon.png',
                'local_t'=>$url.'tabBar/local_T.png',
                'local_l'=>$url.'tabBar/local_T.png',
                'park'=>$url.'tabBar/park.png',
                'tea_specialist'=>[
                    'status'=>true,
                    'title'=>'茶艺师',
                    'icon'=>$url.'tea_specialist2.png'
                ],
                'repeat_order'=>[
                    'status'=>true,
                    'title'=>'续单',
                    'icon'=>$url.'reorder2.png'
                ],
                'open_code'=>[
                    'status'=>true,
                    'title'=>'开门码',
                    'icon'=>$url.'openCode2.png'
                ],
                'service'=>[
                    'status'=>true,
                    'title'=>'客服',
                    'icon'=>$url.'keFu.png'
                ],
                'service_tel'=>[
                    'status'=>false,
                    'title'=>'客服电话',
                    'icon'=>$url.'keFu.png',
                    'tel'=>''
                ],
                'tea_circle'=>[
                    'status'=>false,
                    'title'=>'茶圈',
                    'icon'=>$url.'tea_circle.png',
                    'tel'=>''
                ],
                'footer'=>[
                    'status'=>true,
                    'button'=>[
                        'title'=>'预约茶室',
                        'icon'=>$url.'tabBar/nearbyStore.png',
                        'select_icon'=>$url.'tabBar/nearbyStore.png',
                        'pages'=>'/pages/aboutTea/index'
                    ],
                    'recharge'=>[
                        'title'=>'附近商家',
                        'icon'=>$url.'tabBar/nearbyStore.png',
                        'select_icon'=>$url.'tabBar/nearbyStore.png',
                        'pages'=>'/pages/aboutTea/index'
                    ],
                    'personal'=>[
                        'title'=>'个人中心',
                        'icon'=>$url.'tabBar/my.png',
                        'select_icon'=>$url.'tabBar/my.png',
                        'pages'=>'/pages/user/index'
                    ]
                ],
            ]
    	];
    	return $list;
    }
    static public function defaultTheme(){
        $url=request()->domain().str_replace('index.php', '',request()->baseFile()).'static/shared/';
        return [
                'type'=>'plasmogamy',
                'bgcolor'=>'#5EB1B5',
                'color'=>'#FFFFFF',
                'title'=>'致雅版',
                'is_select'=>false,
                'more_icon'=>$url.'tabBar/more.png?time='.time(),
                'local_icon'=>$url.'tabBar/local_icon.png?time='.time(),
                'local_t'=>$url.'tabBar/local_T.png?time='.time(),
                'local_l'=>$url.'tabBar/local_T.png?time='.time(),
                'park'=>$url.'tabBar/park.png?time='.time(),
                'tea_specialist'=>[
                    'status'=>true,
                    'title'=>'茶艺师',
                    'icon'=>$url.'tea_specialist2.png?time='.time(),
                ],
                'repeat_order'=>[
                    'status'=>true,
                    'title'=>'续单',
                    'icon'=>$url.'reorder2.png?time='.time(),
                ],
                'open_code'=>[
                    'status'=>true,
                    'title'=>'开门码',
                    'icon'=>$url.'openCode2.png?time='.time(),
                ],
                'service'=>[
                    'status'=>true,
                    'title'=>'客服',
                    'icon'=>$url.'keFu.png?time='.time(),
                ],
                'service_tel'=>[
                    'status'=>false,
                    'title'=>'客服电话',
                    'icon'=>$url.'keFu.png?time='.time(),
                    'tel'=>''
                ],
                'tea_circle'=>[
                    'status'=>false,
                    'title'=>'茶圈',
                    'icon'=>$url.'tea_circle.png?time='.time(),
                    'tel'=>''
                ],
                'footer'=>[
                    'status'=>true,
                    'button'=>[
                        'title'=>'预约茶室',
                        'icon'=>$url.'tabBar/nearbyStore.png?time='.time(),
                        'select_icon'=>$url.'tabBar/nearbyStore.png?time='.time(),
                        'pages'=>'/pages/aboutTea/index'
                    ],
                    'recharge'=>[
                        'title'=>'充值',
                        'icon'=>$url.'tabBar/recharge.png?time='.time(),
                        'select_icon'=>$url.'tabBar/recharge.png?time='.time(),
                        'pages'=>'/pages/user/myPurse/purseList'
                    ],
                    'personal'=>[
                        'title'=>'个人中心',
                        'icon'=>$url.'tabBar/my.png?time='.time(),
                        'select_icon'=>$url.'tabBar/my.png?time='.time(),
                        'pages'=>'/pages/user/index'
                    ]
                ],
            ];
    }

}