<?php
namespace app\shared\logic\user;
use app\shared\model\User;
use app\shared\model\Banner;
use app\shared\model\Travel;
use app\shared\model\TravelType;
use app\shared\model\TravelComment;
use app\shared\model\House;
use app\shared\model\Tags;
use app\shared\model\Store;
use app\shared\model\Collection;
use think\exception\ValidateException;
use app\BaseController;
use think\facade\Db;
class TravelForm extends  Base
{
   //页码
	public function page(){
		$banner_list=Banner::where(['acid'=>$this->acid,'is_delete'=>0,'status'=>1,'type'=>2])->cache(10)->column('id,cover cover_url,url');
    	foreach ($banner_list as &$banner) {
    		$banner['cover_url']=get_file_url($banner['cover_url']);
    	}
    	$type_hot_list=[];
    	$type_list=[];
    	$travel_type=TravelType::where(['acid'=>$this->acid,'is_delete'=>0,'status'=>1])->column('id,title,cover,is_hot');
    	foreach ($travel_type as $k => &$v) {
            $v['cover_url']=get_file_url($v['cover']);
    		if($v['is_hot']==1){
    			$type_hot_list[]=$v;
    		}
            $trvel=Travel::where('type_id',$v['id'])->limit(3)->order('id DESC')->column('id,title,images cover_url');
            foreach ($trvel as &$t) {
                $t['cover_url']=get_file_url($t['cover_url']);
            }
            $v['list']=$trvel;
    		$v['num']=Travel::where(['type_id'=>$v['id'],'status'=>1,'is_delete'=>0])->count();
            if($v['num']==0){
                unset($travel_type[$k]);
            }
    	}
		return fetchJson([
			'category'=>[
				['id'=>1,'title'=>'推荐'],
				['id'=>2,'title'=>'话题'],
			],
			'banner_list'=>$banner_list,
			'topic'=>[
				'hot_list'=>$type_hot_list,
				'list'=>$travel_type
			]
		]);
	}
	//列表
	public function list(){
        $query=Db::view(Travel::getTable().' t','id,title,likenum,images image_url,type_id')
                ->view(TravelType::getTable().' t_p','title type_name','t.type_id=t_p.id')
                ->view(User::getTable().' u','nickname,avatar_url','t.user_id=u.id')
                ->view(House::getTable().' h','address','t.house_id=h.id');
        if($type_id=input('type_id')){
            $query=$query->where(['t.type_id'=>$type_id]);
        }
		$list=$query->where(['t.acid'=>$this->acid,'t.is_delete'=>0])
                ->page($this->page)
                ->limit(10)
                ->order('t.id DESC')
                ->select()
                ->toArray();
        foreach ($list as $key => &$value) {
           $value['image_url']=get_file_url($value['image_url']);
        }
        return fetchJson($list);
	}
	//详情
	public function details(){
		$id=input('id');
		$details=Db::view(Travel::getTable().' t','*')
                ->view(TravelType::getTable().' t_p','title type_name','t.type_id=t_p.id')
                ->view(User::getTable().' u','nickname,avatar_url','t.user_id=u.id')
                ->where(['t.acid'=>$this->acid,'t.is_delete'=>0,'t.id'=>$id])
                ->page($this->page)
                ->limit(10)
                ->order('t.id DESC')
                ->find();
        if(!$details){
        	 return fetchJson([],'暂无',1);
        }
        $details['images']=get_file_urls($details['images']);        
       	$house=House::where(['acid'=>$this->acid,'id'=>$details['house_id']])->field('address,store_id')->find();
       	$details['address']=$house['address'];
       	$details['create_time']=date('Y-m-d H:i:s');
       	$store=Store::where(['id'=>$house['store_id']])->field('id,name,address,tags,banner')->find();
       	$store['banner']=get_file_url($store['banner']);
       	$store['tags']=Tags::where('id','in',$store['tags'])->column('id,title');
       	$comment=Db::view(TravelComment::getTable().' t','content,create_time')
                ->view(User::getTable().' u','nickname,avatar_url','t.user_id=u.id')
                ->where(['t.acid'=>$this->acid,'t.is_delete'=>0,'status'=>1,'t.travel_id'=>$id])
                ->order('t.id DESC')
                ->select()
                ->toArray();
        foreach ($comment as $key => &$value) {
            $value['create_time']=date('Y-m-d H:i:s',$value['create_time']);
        }
        $user_id=User::where('access_token',input('access_token'))->value('id');
        $is_collection=Collection::where(['type'=>2,'form_id'=>$id,'is_delete'=>0,'user_id'=>$user_id])->count();          
        return fetchJson([
        	'details'=>$details,
        	'store'=>$store,
        	'comment'=>$comment,
            'is_collection'=>$is_collection
        ]);
	}
    //点赞
    public function onlike(){
        $id=input('id');
        Travel::where('id',$id)->inc('likenum',1)->update();
        return fetchJson([],'点赞成功');
    }
}