<?php
namespace app\shared\logic\user;
use app\shared\model\User;
use app\shared\model\HouseOrder;
use app\shared\model\House;
use app\shared\model\TeaSpecialistOrder;
use app\shared\model\TeaSpecialist;
use app\shared\model\TeaSpecialistApply;
use app\shared\model\App;
use wechatpay\WechatPay;
use app\shared\model\Store;
use slock\Slock;
use think\exception\ValidateException;
use app\BaseController;
use think\facade\Db;
class TeaSpecialistForm extends Base
{
    //列表
	  public function list(){
        $lat=input('lat')?input('lat'):0;
        $lng=input('lng')?input('lng'):0;
        $query=TeaSpecialist::where(['acid'=>$this->acid,'is_delete'=>0])->where('status','in','1,2');
        $area_id=input('area_id');
        if($area_id){
           $query->where('area_id',$area_id);
        }
        $query->field('id,nickname,avatar_url,status,score,lat,lng,service_price,tag,rank,(6378.138 * 2 * asin(sqrt(pow(sin((lat * pi() / 180 - '.$lat.' * pi() / 180) / 2),2) + cos(lat * pi() / 180) * cos('.$lat.' * pi() / 180) * pow(sin((lng * pi() / 180 - '.$lng.' * pi() / 180) / 2),2))) * 1000) as distance');
        $orderType=input('orderType');
        switch ($orderType) {
          case '1':
            $query->order('distance ASC');
            break;
          case '2':
            $query->order('distance DESC');
            break; 
          case '3':
            $query->order('service_price ASC');
            break;
         case '4':
            $query->order('service_price DESC');
            break;     
          default:
            $query->order('distance ASC');
            break;
        }
        $list=$query->page($this->page)->limit(10)->select();
        $rankNameArr=[1=>'初级茶艺师',2=>'中级茶艺师',3=>'高级茶艺师',4=>'特级茶艺师',5=>'专家茶艺师'];
        foreach ($list as $key => &$value) {
            $value['rankName']=isset($rankNameArr[$value['rank']])?$rankNameArr[$value['rank']]:'未定义';
        }
        return fetchJson($list);
    }
    //详情
    public function details(){
       $id=input('id');
       $data=TeaSpecialist::where('id',$id)->field('id,nickname,avatar_url,score,lat,lng,service_price,explain,status,binding tel,tag,rank,banner')->find();
       $data['banner_list']=get_file_urls($data['banner']);
       $rankNameArr=[1=>'初级茶艺师',2=>'中级茶艺师',3=>'高级茶艺师',4=>'特级茶艺师',5=>'专家茶艺师'];
       $data['rankName']=isset($rankNameArr[$data['rank']])?$rankNameArr[$data['rank']]:'未定义';
       return fetchJson($data);
    }
    //申请成为茶艺师
    public function apply(){
         $user=new UserForm();
         $form=TeaSpecialistApply::where(['acid'=>$this->acid,'user_id'=>$user->user_id,'is_delete'=>0])->find();
         if($form){
            if($form->status==0){
                return fetchJson(['is_user_tea'=>0],'已申请请等待后台审核',0);
            }
            $userTea=TeaSpecialist::where([
                'account'=>$user->user->account,
            ])->withoutField('password')->find();
            if($userTea){
                if($userTea->is_delete==0){
                    $userTea->access_token=create_access_token(7);
                    $userTea->save();
                    $userTea['logo_url']=$userTea['avatar_url'];
                    return fetchJson(['is_user_tea'=>1,'data'=>$userTea],'您已经是茶艺师，无需再申请',0);
                }
            }else{
                return fetchJson(['is_user_tea'=>0],'您已被拒绝申请,请联系管理员申请',0);
            }
            
         }
         if(empty(input('area_id'))){
            $userTea=TeaSpecialist::where([
                'account'=>$user->user->account,
                'is_delete'=>0
            ])->withoutField('password')->find();
            if($userTea){
                $userTea->access_token=create_access_token(7);
                $userTea->save();
                $userTea['logo_url']=$userTea['avatar_url'];
                return fetchJson(['is_user_tea'=>1,'data'=>$userTea],'您已经是茶艺师，无需再申请',0);
            }
            return fetchJson(['is_user_tea'=>0],'您已被拒绝申请,请重新申请',0);
         }
         try {
            $data=request()->post();
            $rule = [
                 'area_id|区域ID' => 'require|number',
                 'username|用户名称' => 'require',
             ];
            $this->validate($data,$rule);
         }catch(ValidateException $e){
             return fetchJson([],$e->getError(),1);
         }
         $form= new TeaSpecialistApply();
         $form->save([
            'acid'=>$this->acid,
            'area_id'=>$data['area_id'],
            'user_id'=>$user->user_id,
            'username'=>$data['username'],
         ]);
         return fetchJson([],'申请成功~');
    }
}