<?php
namespace app\shared\logic\user;
use app\shared\model\Invoice;
use app\shared\model\InvoiceDetail;
use app\shared\model\Bill;
use app\shared\model\User;
use app\shared\model\App;
use think\exception\ValidateException;
use app\BaseController;
//发票管理
class InvoiceForm extends  UserForm
{
	public function index(){

		$query=Invoice::alias('i')->leftJoin([User::getTable()=>'u'],'i.user_id=u.id')
		->where(['i.acid'=>$this->acid,'i.is_delete'=>0,'i.user_id'=>$this->user_id]);
		$status=input('status');
		if($status!=''){
			$query->where('i.status',$status);
		}
		$count=$query->field('i.*,u.avatar_url,u.nickname')->count();
		$list=$query->page($this->page)->select();
	    return fetchJson([
	    	'count'=>$count,
	    	'list'=>$list
	    ]);
	}
    //详细
	public function detail(){
		$invoice_id=input('id');
		$query=InvoiceDetail::where('invoice_id',$invoice_id);
		$sum_price=$query->sum('price');
		$list=$query->select();
		return fetchJson([
			'sum_price'=>$sum_price,
			'list'=>$list
		]);
	}

	public function billOrder(){
		$bill_ids=InvoiceDetail::alias('d')->leftJoin([Invoice::getTable()=>'i'],'d.invoice_id=i.id')->where(['d.is_delete'=>0,'i.user_id'=>$this->user_id])->column('d.bill_id');
		$bill_list=Bill::where(['account_type'=>Bill::ACCOUNT_TYPE_USER,'form_id'=>$this->user_id,'status'=>-1])->where('id','not in',$bill_ids)->where('type','in','1,2,4,7,8,10')->where('price','>',0)->order('id DESC')->page($this->page)->select();
		return fetchJson($bill_list);
	}
	//申请
	public function apply(){
		   try {
	          $data=request()->post();
	          $rule = [
	              'type|企业类型' => 'require',
	              'send_type|发送方式'=>'require|in:1,2',
	              'company_name|公司名称'=>'require',
	              'price|金额'=>'require',
	              'bill_ids|账单列表'=>'require',
	          ];
	          $this->validate($data,$rule);
	       }catch (ValidateException $e){
	          return fetchJson([],$e->getError(),1);
	       }

	       if(Invoice::where(['acid'=>$this->acid,'user_id'=>$this->user_id,'status'=>0])->count()){
	       	   return fetchJson([],'您已提交发票申请等候后台通过~',1);
	       }
	       $form=new Invoice();
	       $form->save([
	       	    'acid'=>$this->acid,
	       	    'user_id'=>$this->user_id,
	       		'type'=>$data['type'],
	       		'send_type'=>$data['send_type'],
	       		'company_name'=>$data['company_name'],
	       		'duty_paragraph'=>input('duty_paragraph'),
	       		'email'=>input('email'),
	       		'username'=>input('username'),
	       		'mobile'=>input('mobile'),
	       		'address'=>input('address'),
	       		'price'=>$data['price'],
	       ]);
	       $app_name=App::where('id',$this->acid)->value('name');
	       $bill_list=Bill::where('id','in',$data['bill_ids'])->where(['account_type'=>Bill::ACCOUNT_TYPE_USER,'form_id'=>$this->user_id])->column('id,price,des,type');

	       foreach($bill_list as $value){
	       	  //1,茶室，4茶艺师，7商品订单，8会员卡订单，10合伙人
	       	  switch ($value['type']){
	       	  	  case 1:
	       	  	  $content="茶室订单";
	       	  	  break;
	       	  	  case 2:
	       	  	  $content="充值订单";
	       	  	  break;
	       	  	  case 4:
	       	  	  $content="茶艺师";
	       	  	  break;
	       	  	  case 7:
	       	  	  $content="商品订单";
	       	  	  break;
	       	  	  case 8:
	       	  	  $content="会员卡订单";
	       	  	  break;
	       	  	  case 10:
	       	  	  $content="茶室订单";
	       	  	  break;
	       	  	  default:
	       	  	  $content="其他订单";
	       	  	  break;
	       	  }
	       	  (new InvoiceDetail())->save([
	       	  	'bill_id'=>$value['id'],
	       	  	'invoice_id'=>$form->id,
	       	  	'name'=>$app_name,
	       	  	'content'=>$content,
	       	  	'price'=>$value['price']
	       	  ]);
	       }
	       return fetchJson([
	       	'status'=>1,
	       ],'申请成功请等待审核');

	}
}