<?php
namespace app\shared\logic\user;
use app\shared\model\InviteTea;
use app\shared\model\InviteTeaDetail;
use app\shared\model\User;
use app\shared\model\Option;
use think\exception\ValidateException;
use app\BaseController;
class InviteTeaForm extends  UserForm
{
	private $isParent=0;
    //正在进行中
	public function underway(){
		$invite_tea_id=input('invite_tea_id');
		//查询分享的
		$config=Option::get_data($this->acid,'plugin','shared_invite_tea_config');
    	$config=json_decode($config,1);
    	if(!$config){
    		$config=[
    			'bg_img'=>"",
    			'people_num'=>6,
    			'status'=>0,
    			'dec'=>"",
    			'desk_img'=>"",
    			'stool_img'=>"",
    		];
    	}
		if($invite_tea_id){
			$form=InviteTea::where('id',$invite_tea_id)->field('id,people_num,status,user_id')->find();
			if($form){
				if($form->user_id!=$this->user_id){
					$userList=InviteTeaDetail::alias('it')
					->leftJoin([User::getTable()=>'u'],'it.user_id=u.id')
					->where(['it.invite_tea_id'=>$invite_tea_id])
					->field('u.nickname,u.avatar_url')
					->order('it.id ASC')
					->select();
					return fetchJson([
						'userList'=>$userList,
						'info'=>$form,
						'config'=>json_encode($config),
						'is_join'=>InviteTeaDetail::where(['invite_tea_id'=>$invite_tea_id,'user_id'=>$this->user_id,'acid'=>$this->acid])->count()
					]);
				}
			}
		}
		//查询自己的
		$form=InviteTea::where(['user_id'=>$this->user_id])->field('id,people_num,status,user_id')->order('id DESC')->find();
		if($form){
			$userList=InviteTeaDetail::alias('it')
			->leftJoin([User::getTable()=>'u'],'it.user_id=u.id')
			->where(['it.invite_tea_id'=>$form->id])
			->field('u.nickname,u.avatar_url')
			->order('it.id ASC')
			->select();
			return fetchJson([
				'userList'=>$userList,
				'info'=>$form,
				'config'=>json_encode($config),
				'is_join'=>InviteTeaDetail::where(['invite_tea_id'=>$invite_tea_id,'user_id'=>$this->user_id,'acid'=>$this->acid])->count()
			]);
		}else{
			return fetchJson([
				'userList'=>[],
				'info'=>[],
				'config'=>json_encode($config),
				'is_join'=>0
			]);
		}
	}
	//同意邀请
	public function agreement(){
		$invite_tea_id=input('invite_tea_id');
		$form=InviteTea::where(['id'=>$invite_tea_id,'status'=>0])->field('id,people_num,status,user_id')->find();
		if($form){
			$invD=InviteTeaDetail::where(['invite_tea_id'=>$form->id,'user_id'=>$this->user_id,'acid'=>$this->acid])->find();
			if(!$invD){
				$config=Option::get_data($this->acid,'plugin','shared_invite_tea_config');
		    	$config=json_decode($config,1);
		    	//查询分享的
				if(!$config){
		    		$config=[
		    			'bg_img'=>"",
		    			'people_num'=>6,
		    			'status'=>0,
		    			'dec'=>"",
		    			'desk_img'=>"",
		    			'stool_img'=>"",
		    			'is_new_user'=>0,
		    			'everyday_user_num'=>1
		    		];
		    	}
		    	$is_new_user=isset($config['is_new_user'])?$config['is_new_user']:0;
				if($this->user->parent_id!=0&&$is_new_user==1){
					return fetchJson([],'您有上级所以无法接受约茶',1);
				}
				//判断不是自己
        		if($form->user_id!=$this->user_id){
        			self::getBottomUsers($form->user_id,$this->user_id);
        			if($this->isParent){
        				$user=User::where('id',$this->user_id)->find();
        				$user->parent_id=$form->user_id?$form->user_id:0;
        				$user->save();
        			}
        		}
				$invD=new InviteTeaDetail();
				$invD->save([
					'invite_tea_id'=>$form->id,
					'user_id'=>$this->user_id,
					'acid'=>$this->acid
				]);
			}
			$complete=0;
			if(InviteTeaDetail::where(['invite_tea_id'=>$invite_tea_id])->count()>=$form->people_num){
				$form->status=1;
				$form->save();
				$complete=1;
				\app\shared\model\Coupon::giveUserCoupon($form->user_id,4,$this->acid);
			}
			return fetchJson([
				'complete'=>$complete
			],'接收邀请成功');
		}
		return fetchJson([],'暂无邀请',1);
	}
	//再开一桌
	public function again(){
		$form=InviteTea::where(['user_id'=>$this->user_id,'status'=>0])->field('id,people_num,status,user_id')->find();
		if(!$form){
			$config=Option::get_data($this->acid,'plugin','shared_invite_tea_config');
	    	$config=json_decode($config,1);
	    	//查询分享的
			if(!$config){
	    		$config=[
	    			'bg_img'=>"",
	    			'people_num'=>6,
	    			'status'=>0,
	    			'dec'=>"",
	    			'desk_img'=>"",
	    			'stool_img'=>"",
	    			'is_new_user'=>0,
	    			'everyday_user_num'=>1
	    		];
	    	}
	    	$everyday_user_num=isset($config['everyday_user_num'])?$config['everyday_user_num']:1;
	    	if(InviteTea::where(['acid'=>$this->acid,'user_id'=>$this->user_id])->whereDay('create_time')->count()>=$everyday_user_num){
	    		return fetchJson([],'今日已到达开桌限制，请明日再来',1);
			}
			$form=new InviteTea();
			$form->save([
				'acid'=>$this->acid,
				'user_id'=>$this->user_id,
				'status'=>0,
				'people_num'=>$config['people_num']
			]);
			(new InviteTeaDetail)->save([
				'invite_tea_id'=>$form->id,
				'user_id'=>$this->user_id,
				'acid'=>$this->acid
			]);
		}
		return fetchJson($form);
	}
	//获取用户网体用户以下的用户
    public function getBottomUsers($user_id=0,$parentId=0){
    	$user=User::where(['id'=>$user_id])->field('id,parent_id')->find();
    	$parent_id=empty($user['parent_id'])?0:$user['parent_id'];
    	if($parent_id==0){
    		if($parent_id==$parentId){
    			$this->isParent=0;
    			return false;
    		}else{
    			$this->isParent=1;
    			return true;
    		}
    	}else{
    		if($parent_id==$parentId){
    			$this->isParent=0;
    			return false;
    		}else{
    			self::getBottomUsers($parent_id,$parentId);
    		}
    	}
    }
}