<?php
namespace app\shared\logic\user;
use app\shared\model\User;
use app\shared\model\House;
use app\shared\model\HouseRoom;
use app\shared\model\HouseRoomStock;
use think\exception\ValidateException;
use app\BaseController;
class HouseForm extends  Base
{
  //民宿列表
	public function list(){
         $query=House::where(['acid'=>$this->acid,'is_delete'=>0,'status'=>1]);
         if($keyword=input('keyword')){
            $query->where('name|id','like',"%{$keyword}%");
         }
         if($area_id=input('area_id')){
            $query->where('area_id',$area_id);
         }
         if($start_date=input('start_date')&&$end_date=input('end_date')){
          
            
         }
         $list=$query->field('cover cover_url,id,name,price,member_price,service_facilities,longitude,tags,address,store_id')
         ->page($this->page)
         ->order('sort ASC')
         ->select()
         ->toArray();
         foreach ($list as $key => &$value) {
             $value['cover_url']=get_file_url($value['cover_url']);
             $value['service_facilities']=json_decode($value['service_facilities'],1);
             $value['longitude']=explode(',', $value['longitude']);
             $value['tags']=explode(',', $value['tags']);
             $value['is_free']=$value['price']==$value['member_price']?1:0;
         }
         return fetchJson($list);
    }
    //推荐民宿
    public function referrer(){
         $list=House::where(['acid'=>$this->acid,'is_delete'=>0,'status'=>1])
         ->field('cover cover_url,id,name,price,member_price,address,tags,store_id')
         ->page($this->page)
         ->limit(10)
         ->order('sort ASC')
         ->select()
         ->toArray();
         foreach ($list as $key => &$value) {
             $value['cover_url']=get_file_url($value['cover_url']);
             $value['tags']=explode(',', $value['tags']);
             $value['is_free']=$value['price']==$value['member_price']?1:0;
         }
         return fetchJson($list);
    }
    //详情
    public function details(){
       try {
          $data=request()->post();
          $rule = [
               'id|民宿ID' => 'require|number',
               'start_date|入住时间'=>'require|date|length:10',
               'end_date|离店时间'=>'require|date|length:10',
           ];
          $this->validate($data,$rule);
       }catch (ValidateException $e){
          return fetchJson([],$e->getError(),1);
       }
       $form=House::where(['acid'=>$this->acid,'is_delete'=>0,'id'=>$data['id']])
          ->find();    
      if(strtotime($data['start_date'])>=strtotime($data['end_date'])){
          return fetchJson([],'选择时间错误',1);
      }
      $end_date_time=strtotime($data['end_date']);
      $start_date_time=strtotime($data['start_date']);
      $night=($end_date_time-$start_date_time)/86400;
      $book_date=[];
      for($i=0;$i<$night;$i++){ 
         $book_date[]=date('Y-m-d',($start_date_time+(86400*$i)));
      }
      $house_id=$data['id'];
      $house=House::where(['acid'=>$this->acid,'is_delete'=>0,'id'=>$data['id']])->field('price,member_price')->find();
      $room=HouseRoom::where(['house_id'=>$house_id,'status'=>1])->column('id');
      $room_num=count($room);
      $no_book=HouseRoomStock::where(['house_id'=>$house_id])
      ->where('status','>',0)
      ->whereIn('room_id',$room)
      ->column('date');
      $no_book_unique=array_count_values($no_book);
      $no_book_all=[];
      foreach ($no_book_unique as $key => $value) {
         if($value>=$room_num){
            $no_book_all[]=$key;
         }
      }
      $is_book=1;
      foreach ($book_date as $bk) {
        if(in_array($bk, $no_book_all)){
          $is_book=0;
          break;
        }
      } 
      if($form){
           $form['cover_url']=get_file_url($form['cover']);
           $form['banner_url']=get_file_urls($form['banner']);
           $form['service_facilities']=json_decode($form['service_facilities'],1);
           $form['longitude']=explode(',', $form['longitude']);
           $form['tags']=explode(',', $form['tags']);
           $form['is_free']=$form['price']==$form['member_price']?1:0;
           $form['house_bed']=json_decode($form['house_bed'],1);
           $form['house_bed_num']=array_sum(array_column($form['house_bed'], 'num'));
           $form['is_book']=$is_book;
       }
       return fetchJson($form);
    }
    //预订日期列表
    public function book_date_list(){
        $month_num=2;
        $month_day=[];
        for ($i=0; $i<$month_num; $i++) { 
          $month_day[]=[
            'date_list'=>self::get_month_day(date("Y-m",strtotime("+{$i} month")))
          ];
        }
        return fetchJson($month_day);
    }
    public function get_month_day($month='2020-07'){
      $start_time = strtotime($month.'-01'); 
      $j = date("t",$start_time);
      $array = array();
      $house_id=input('house_id');
      $house=House::where(['acid'=>$this->acid,'is_delete'=>0,'id'=>$house_id])->field('price,member_price')->find();
      $room=HouseRoom::where(['house_id'=>$house_id,'status'=>1])->column('id');
      $room_num=count($room);
      $no_book=HouseRoomStock::where(['house_id'=>$house_id])
      ->where('status','>',0)
      ->where('date','like',"{$month}%")
      ->whereIn('room_id',$room)
      ->column('date');
      $no_book_unique=array_count_values($no_book);
      $no_book_all=[];
      foreach ($no_book_unique as $key => $value) {
         if($value>=$room_num){
            $no_book_all[]=$key;
         }
      }
      for($i=0;$i<$j;$i++){
           $date=date('Y-m-d',$start_time+$i*86400);
           if(in_array($date,$no_book_all)){
              $array[] =[
                'title'=>'无房',
                'status'=>1,
                'date'=>date('Y-m-d',$start_time+$i*86400),
                'price'=>$house->price
             ];
           }else{
              if($room_num){
                 $array[] =[
                    'title'=>'有房',
                    'status'=>0,
                    'date'=>date('Y-m-d',$start_time+$i*86400),
                    'price'=>$house->price
                 ];
              }else{
                $array[] =[
                    'title'=>'无房',
                    'status'=>1,
                    'date'=>date('Y-m-d',$start_time+$i*86400),
                    'price'=>$house->price
                 ];
              }
           }
      }
      return $array;
    }
}