<?php
namespace app\shared\logic\user;
use app\shared\model\Banner;
use app\shared\model\Option;
use app\shared\model\Category;
use app\shared\model\Card;
use app\shared\model\Tags;
use app\shared\model\Area;
use app\shared\model\App;
use app\shared\model\User;
use app\shared\model\Travel;
use app\shared\model\TravelType;
use app\shared\model\Advertising;
use app\shared\model\House;
use app\shared\model\Agreement;
use think\exception\ValidateException;
use app\BaseController;
use think\facade\Db;
use think\facade\Cache;
//首页管理
class HomeForm extends  Base
{	
    //获取数据
    public  function info(){
    	$page=Option::where(['acid'=>$this->acid,'module'=>'platform','name'=>'app_home_pages'])->value('value');
    	$page_list=json_decode($page,1);
    	$banner_list=Banner::where(['acid'=>$this->acid,'is_delete'=>0,'status'=>1])->where('type','in','1,3')->cache(10)->column('id,cover cover_url,type,url');
        $banner1=[];
        $banner2=[];
    	foreach ($banner_list as &$banner) {
    		$banner['cover_url']=get_file_url($banner['cover_url']);
            if($banner['type']==1){
                $banner1[]=$banner;
            }else{
                $banner2[]=$banner;
            }
    	}
    	$category_list=Category::where(['acid'=>$this->acid,'is_delete'=>0,'status'=>1])->order('sort ASC')->cache(10)->column('id,name,cover cover_url');
    	foreach ($category_list as &$category) {
    		$category['cover_url']=get_file_url($category['cover_url']);
    	}
        $travel_list=Db::view(Travel::getTable().' t','id,title,likenum,images image_url,type_id')
                ->view(TravelType::getTable().' t_p','title type_name','t.type_id=t_p.id')
                ->view(User::getTable().' u','nickname,avatar_url','t.user_id=u.id')
                ->view(House::getTable().' h','address','t.house_id=h.id')
                ->where(['t.acid'=>$this->acid,'t.is_delete'=>0])
                ->limit(8)
                ->order('t.id DESC')
                ->select()
                ->toArray();
        foreach ($travel_list as &$travel) {
           $travel['image_url']=get_file_url($travel['image_url']);
        }
    	foreach ($page_list as &$page) {
    		unset($page['image']);
    		unset($page['is_edit']);
    		if($page['name']=='banner'){
    			$page['list']=$banner1;
    		}else if($page['name']=='cat'){
    			$page['list']=$category_list;
    		}else if($page['name']=='article_banner'){
    			$page['list']=$banner2;
    		}else if($page['name']=='travel'){
                $page['list']=$travel_list;
            }
    	}
        return fetchJson($page_list);
    }
    //区域
    public function area_list(){
        $list=Area::where(['acid'=>$this->acid,'is_delete'=>0])->order('letter ASC')->column('id,name,cover,address_location,letter');
        $letter=Area::where(['acid'=>$this->acid,'is_delete'=>0])->order('letter ASC')->column('letter');
        $letter=array_unique($letter);
        foreach ($list as $key => &$value) {
            $value['cover_url']=get_file_url($value['cover']);
            $address_location=explode(',', $value['address_location']);
            $value['lat']=isset($address_location[0])?$address_location[0]:'';
            $value['lng']=isset($address_location[1])?$address_location[1]:'';
        }
        return fetchJson([
            'list'=>$list,
            'letter'=>$letter
        ]);
    }
    //菜单列表
    public function navList(){
        $nav_list=Option::get_data($this->acid,'platform','app_nav_list');
        return fetchJson([
            'app_nav_list'=>json_decode($nav_list,1)
        ],'保存成功');
    }
    //协议列表
    public function agreementList(){
        $type=input('type')?input('type'):1;
        $list=Agreement::where(['acid'=>$this->acid,'is_delete'=>0,'type'=>$type])->page($this->page)->limit(20)->column('id,title');
        return fetchJson($list);
    }
    //协议详情
    public function agreementDetails(){
        $id=input('id');
        $find=Agreement::where(['acid'=>$this->acid,'is_delete'=>0,'id'=>$id])->field('id,title,content')->find();
        return fetchJson($find);
    }
    //菜单列表
    public function homePage(){
        $ad_list=Advertising::where(['acid'=>$this->acid,'is_delete'=>0,'status'=>1])->column('id,url,cover');
        $teaSpecialist=Option::get_data($this->acid,'platform','app_tea_specialist_setting');
        $app=App::where('id',$this->acid)->field('logo,name')->find();
        $app_home_theme=Option::get_data($this->acid,'shared','app_home_theme');

        $app_home_theme=json_decode($app_home_theme,1);
        if(!$app_home_theme){
            $app_home_theme=\app\shared\model\Theme::defaultTheme();
        }
        $root_url=request()->domain().str_replace('index.php', '',request()->baseFile());


        $userCenter=Option::get_data($this->acid,'shared','app_user_center_config');
        $userCenter=json_decode($userCenter,1);

        if(!$userCenter){
            $url=request()->domain().str_replace('index.php', '',request()->baseFile()).'static/shared/';
            $userCenter=[
                'type'=>1,
                'money'=>[
                    'status'=>1,
                    'price'=>1,
                    'tea'=>1,
                ],
                'tea_order'=>[
                    ['icon'=>$url.'order/daifukuan.svg','url'=>'/order/index?status=1','title'=>'待付款'],
                    ['icon'=>$url.'order/daishiyong.svg','url'=>'/order/index?status=2','title'=>'待使用'],
                    ['icon'=>$url.'order/shiyongzhong.svg','url'=>'/order/index?status=3','title'=>'使用中'],
                    ['icon'=>$url.'order/yiwancheng.svg','url'=>'/order/index?status=4','title'=>'已完成'],
                    ['icon'=>$url.'order/quanbu.svg','url'=>'/order/index?status=0','title'=>'全部'],
                ],
                'is_share'=>1,
                'myserve'=>[
                    ['icon'=>$url.'myserve/chayishidd.svg','type'=>"common",'status'=>1,'url'=>'/teaOrder/index','title'=>'茶艺师订单'],
                    ['icon'=>$url.'myserve/shangpingdd.svg','type'=>"common",'status'=>1,'url'=>'/pages/user/buyHistory/index','title'=>'商品订单'],
                    ['icon'=>$url.'myserve/shanghugl.svg','type'=>"store",'status'=>1,'url'=>'/storeManager/navBar/index','title'=>'商户管理'],
                    ['icon'=>$url.'myserve/jiamenghezuo.svg','type'=>"storeJoin",'status'=>1,'url'=>'/pages/store/joinUs','title'=>'加盟合作'],
                    ['icon'=>$url.'myserve/pingtaixieyi.svg','type'=>"common",'status'=>1,'url'=>'/pages/user/protocol/index?type=1','title'=>'平台协议'],
                    ['icon'=>$url.'myserve/gudongfenhong.svg','type'=>"shareholder_receive",'status'=>1,'url'=>'/stock/index','title'=>'股东分红'],
                    ['icon'=>$url.'myserve/baojieduan.svg','type'=>"common",'status'=>1,'url'=>'/storeManager/cleaner/index','title'=>'保洁端'],
                    ['icon'=>$url.'myserve/meituanyanquan.svg','type'=>"meituan_coupon",'status'=>1,'url'=>'/pages/user/meituan/getCoupon','title'=>'美团验券'],
                    ['icon'=>$url.'myserve/chayishiduan.svg','type'=>"common",'status'=>1,'url'=>'/teaMasterPort/navBar/Footer','title'=>'茶艺师端'],
                    ['icon'=>$url.'myserve/bangzhuzhongxing.svg','type'=>"common",'status'=>1,'url'=>'/pages/user/protocol/index?type=2','title'=>'帮助中心'],
                    ['icon'=>$url.'myserve/guanyuwomen.svg','type'=>"common",'status'=>1,'url'=>'/pages/user/protocol/index?type=3','title'=>'关于我们'],
                    ['icon'=>$url.'myserve/shouhuodizhi.svg','type'=>"common",'status'=>1,'url'=>'/pages/address/index','title'=>'收货地址'],
                    ['icon'=>$url.'myserve/woyaokaipiao.png','type'=>"common",'status'=>1,'url'=>'/invoice/index','title'=>'我要开票'],
                    ['icon'=>$url.'myserve/mianfeihecha.png','type'=>"invite_tea",'status'=>1,'url'=>'/group/index','title'=>'免费约茶'],
                    ['icon'=>$url.'myserve/zaixiankefu.svg','type'=>"kefu",'status'=>1,'url'=>'','title'=>'在线客服'],
                ],
            ];
        }else{
           $userCenter['money']=json_decode($userCenter['money'],1);
        }
        $pluginlist=Cache::get('platform_plugin_list_wxapp');
        if(isset($pluginlist['info']['plugin'])){
              $plugin_list=explode(',',$pluginlist['info']['plugin']);
              $myserve=[];
              foreach ($userCenter['myserve'] as $value){
                  if($value['type']!='kefu'&&$value['type']!="common"&&$value['type']!="store"&&$value['type']!="storeJoin"&&$value['type']!="ranking"&&$value['type']!="tea_specialist"){
                     if(in_array($value['type'],$plugin_list)) {
                        $myserve[]=$value;
                     }
                  }else{
                    $myserve[]=$value;
                  }
              }
              $userCenter['myserve']=$myserve;
        }
        return fetchJson([
            'ad_list'=>$ad_list,
            'platform_logo'=>get_file_url($app['logo']),
            'platform_name'=>$app['name'],
            'teaSpecialist'=>json_decode($teaSpecialist,1),
            'app_home_theme'=>$app_home_theme,
            'app_system_shortened'=>Option::get_data($this->acid,'platform','app_system_shortened'),
            'app_system_help_dec'=>Option::get_data($this->acid,'platform','app_system_help_dec'),
            'app_system_about_dec'=>Option::get_data($this->acid,'platform','app_system_about_dec'),
            'music'=>[
                'gate'=>$root_url.'static/shared/mp3/gate.mp3',
                'door'=>$root_url.'static/shared/mp3/door.mp3',
            ],
            "images"=>[
                'new_coupon_url'=>$root_url.'static/shared/img/hongbao.png',
            ],
            'userCenter'=>$userCenter,
            'conversion_dec'=>Option::get_data($this->acid,'shared','app_plugin_conversion_dec')
        ]);
    }
    //审核判断
    public function auditJudge(){
        $android_version='1.0.9';
        $ios_version='1.0.10';
        $wxapp_version='1.0.2';
        if($this->platform=='app'){
            return fetchJson([
                'isShow'=>0,
            ],'获取成功'); 
        }
        if($this->platform=='ios'){
            if($ios_version==$this->version){
                return fetchJson([
                    'isShow'=>0,
                ],'获取成功'); 
            }
        }
        if($this->platform=='android'){
            if($android_version==$this->version){
                return fetchJson([
                    'isShow'=>0
                ],'获取成功'); 
            }
        }
        if($this->platform=='wxapp'){
            if($wxapp_version==$this->version){
                return fetchJson([
                    'isShow'=>0
                ],'获取成功'); 
            }
        }
        return fetchJson([
            'isShow'=>1
        ],'获取成功'); 

    }
    //获取系统信息
    public function getSystem(){
        $data['app_system_copyright']=Option::get_data($this->acid,'platform','app_system_copyright');
        return fetchJson($data);
    }

}