<?php
namespace app\shared\logic\user;
use app\shared\model\GoodsCat;
use app\shared\model\Goods;
use app\shared\model\GoodsAttr;
use app\shared\model\Card;
use app\shared\model\Banner;
use app\shared\model\CardUser;
use think\exception\ValidateException;
use app\BaseController;
class GoodsForm extends  UserForm
{
    public function banner(){
        $list=Banner::where(['acid'=>$this->acid,'type'=>1,'is_delete'=>0])->column('cover,url');
        foreach ($list as &$value){
            $value['cover']=get_file_url($value['cover']);
        }
        return fetchJson($list);
    }
    public function home(){
         $store_id=input('store_id');
        if(empty($store_id))$store_id=0;
        $cat=GoodsCat::where(['acid'=>$this->acid,'is_delete'=>0,'store_id'=>$store_id])->order('sort ASC')->column('id,title name,cover icon');
        $cardUser=CardUser::alias('c_u')
        ->leftJoin([Card::getTable()=>'c'],'c_u.card_id=c.id')
        ->where(['c_u.status'=>1,'c_u.user_id'=>$this->user_id,'c.is_delete'=>0])
        ->where('c_u.start_time','<',time())
        ->where('c_u.end_time','>',strtotime(date('Y-m-d',time()+86400)))
        ->order('c_u.level DESC')->field('c_u.*,c.discount')->find();
        $discount=0;
        if($cardUser){
          $discount=$cardUser['discount'];
        }
        foreach ($cat as &$value) {
            $value['icon']=get_file_url($value['icon']);
            $goods_list=Goods::where(['cat_id'=>$value['id'],'is_delete'=>0,'status'=>1])->column('id,name,price,images,cover,use_attr use_property,attribe_list property,detail');
            foreach ($goods_list as &$goods) {
                $property=json_decode($goods['property'],1);
                foreach ($property as &$pv) {
                    $attr_list1=$pv['attr_list'];
                    foreach ($attr_list1 as $key => &$attr1) {
                        if($key==0){
                            $attr1['is_default']=1;
                        }else{
                            $attr1['is_default']=0;
                        }
                    }
                    $pv['values']=$attr_list1;
                    unset($pv['attr_list']);
                }
                $goods['property']=$property;
                $attr=GoodsAttr::where(['is_delete'=>0,'goods_id'=>$goods['id']])->order('index ASC')->column('attr_list,price,stock,integral,index');
                foreach ($attr as &$aV){
                    $aV['attr_list']=json_decode($aV['attr_list'],1);
                    $aV['member_price']=$discount>0?$discount*$aV['price']*0.1:-1;
                }
                $goods['entity']=$attr;
                $goods['images']=get_file_urls($goods['images']);
                $goods['cover']=get_file_url($goods['cover']);
                $goods['number']=1;
                $goods['num']=array_sum(array_column($attr, 'stock'));
                $goods['member_price']=$discount>0?$discount*$goods['price']*0.1:-1;
            }
            $value['goods_list']=$goods_list;
        }
        return fetchJson($cat);
    }
    //商品分类
    public  function catList(){
        $store_id=input('store_id');
        if(empty($store_id))$store_id=0;
        $list=GoodsCat::where(['acid'=>$this->acid,'is_delete'=>0,'store_id'=>$store_id])
        ->order('sort DESC')
        ->field('id,title,cover,sort,parent_id,is_delete')
        ->page($this->page)
        ->limit(10)
        ->select()
        ->toArray();
        foreach ($list as $key => &$value) {
            $value['cover_url']=get_file_url($value['cover']);
            if(!Goods::where(['status'=>1,'is_delete'=>0])->where('cat_id','like',"%{$value['id']}%")->count()){
                unset($value);
            }
        }
        $list=generateTree($list,'parent_id');
        return fetchJson($list);
    }
    //商品列表
    public function list(){
        $cat_id=input('cat_id');
        $query=Goods::where(['acid'=>$this->acid,'is_delete'=>0,'status'=>1,'store_id'=>0]);
        if($cat_id=='choiceness'){
            $query->where('is_choiceness',1);
        }else if($cat_id=='hotsell'){
            $query->where('is_choiceness',1);
        }else{
            if(is_numeric($cat_id)){
               $query->whereFindInSet('cat_id',$cat_id);
            }
        }
        $sort_type=input('sort_type');
        //綜合排序
        if($sort_type==1){
            $query->order('id DESC')->order('price ASC');
        }
        //銷量排序
        if($sort_type==2){
            $query->order('sales_volume DESC');
        }
        //新品排序
        if($sort_type==3){
            $query->order('id DESC');
        }
        //價格排序
        if($sort_type==4){
            $query->order('price ASC');
        }
        //價格排序
        if($sort_type==5){
            $query->order('price DESC');
        }
        if($keyword=input('keyword')){
            $query->where('name','like',"%$keyword%");
        }
        $list=$query->field('id,name,price,original_price,goods_num,cover,attr,is_choiceness,is_hotsell,video_url')
        ->limit(10)
        ->page($this->page)
        ->select();

        $cardUser=CardUser::alias('c_u')
        ->leftJoin([Card::getTable()=>'c'],'c_u.card_id=c.id')
        ->where(['c_u.status'=>1,'c_u.user_id'=>$this->user_id,'c.is_delete'=>0])
        ->where('c_u.start_time','<',time())
        ->where('c_u.end_time','>',strtotime(date('Y-m-d',time()+86400)))
        ->order('c_u.level DESC')->field('c_u.*,c.discount')
        ->find();
        $discount=0;
        if($cardUser){
          $discount=$cardUser['discount'];
        }
        foreach ($list as $key => &$value) {
            $value['cover_url']=get_file_url($value['cover']);
            $value['tip']='商家自营';
            $goods_attr=json_decode($value['attr'],1);
            unset($value['attr']);
            $value['member_price']=$discount>0?$discount*$value['price']*0.1:-1;
        }
        return fetchJson($list);
    }
    //详情
    public function details(){
        $goods_id=input('goods_id');
        $goods=Goods::where(['acid'=>$this->acid,'is_delete'=>0,'id'=>$goods_id,'status'=>1])->find();
        if($goods){
            $goods['images_list']=get_file_urls($goods['images']);
            $goods['cover_url']=get_file_url($goods['cover']);
            $goods_attr=GoodsAttr::where(['is_delete'=>0,'goods_id'=>$goods_id])->order('index ASC')->column('attr_list,price,stock,integral,index');
            $attribe_list=json_decode($goods->attribe_list,1);

            $specifications=[];
            foreach ($attribe_list as $spe) {
               $attr_list=$spe['attr_list'];
               $attr_v_arr=[];
               foreach ($attr_list as &$attr_v) {
                  $attr_v_arr[]=[
                    'name'=>$attr_v['attr_name'],
                  ];
               }
               $specifications[]=[
                    'name'=>$spe['attr_group_name'],
                    'item'=>$attr_v_arr
               ];
            }
           $difference=[];
           foreach ($goods_attr as $spe) {
                $spe['attr_list']=json_decode($spe['attr_list'],1);
                $difference[]=[
                    'id'=>$spe['index']+1,
                    'price'=>$spe['price'],
                    'stock'=>$spe['stock'],
                    'pic'=>isset(array_column($spe['attr_list'],'pic')[0])?array_column($spe['attr_list'], 'pic')[0]:$goods['cover_url'],
                    'difference'=>array_column($spe['attr_list'], 'attr_name'),
                    'integral'=>isset($spe['integral'])?$spe['integral']:0
                ];
            }
            $goods['specifications']=$specifications;
            $goods['difference']=$difference;
            unset($goods['attribe_list']);
            unset($goods['attr']);
           //商品访问量
           \app\shared\model\UserUv::todayUv($this->acid,3,$goods['store_id'],$this->user_id,$goods['id']);
        }    
        return fetchJson($goods);
    }
}