<?php
namespace app\shared\logic\user;
use app\shared\model\User;
use app\shared\model\Banner;
use app\shared\model\Travel;
use app\shared\model\TravelType;
use app\shared\model\TravelComment;
use app\shared\model\House;
use app\shared\model\Tags;
use app\shared\model\Store;
use think\exception\ValidateException;
use app\BaseController;
use think\facade\Db;
class CommentForm extends  UserForm
{
	//游记评论
	public function travel_comment(){
		try {
          $data=request()->post();
          $rule = [
               'travel_id|游记ID' => 'require|number',
               'content|内容' => 'require',
           ];
          $this->validate($data,$rule);
       }catch (ValidateException $e){
          return fetchJson([],$e->getError(),1);
       }
       $count=TravelComment::where(['travel_id'=>$data['travel_id'],'user_id'=>$this->user_id,'content'=>$data['content']])->count();
       if($count>=20){
          return fetchJson([],'您存在刷评现象，请联系管理员',1);
       }
       $form=new TravelComment();
       $form->acid=$this->acid;
       $form->user_id=$this->user_id;
       $form->travel_id=$data['travel_id'];
       $form->content=$data['content'];
       $form->save();
       return fetchJson([],'评论成功');
	}
}