<?php
namespace app\shared\logic\teaSpecialist;
use app\shared\model\TeaSpecialist;
use app\shared\model\Withdraw;
use app\BaseController;
class UserForm extends  Base
{
	public function info(){
		$data=TeaSpecialist::where('id',$this->tea_specialist_id)->find();
		$data['banner_list']=get_file_urls($data['banner']);
		return fetchJson($data);
	}
	//更新位置
	public function updLocation(){
		TeaSpecialist::where('id',$this->tea_specialist_id)->update([
			'lng'=>input('lng'),
			'lat'=>input('lat'),
		]);
		return fetchJson([],'更新位置成功');
	}
	//更新状态
	public function updStatus(){
		$form=TeaSpecialist::where('id',$this->tea_specialist_id)->find();
		if($form->status==1){
			$form->status=0;
		}else if($form->status==2){
			$form->status=1;
		}else{
			$form->status=1;
		}
		$form->save();
		return fetchJson($form,'设置成功');
	}
	//设置
	public function settings(){
		try {
            $data=request()->post();
            $rule = [
                'account|账号' =>'require',
                'nickname|昵称' =>'require',
                'banner|轮播' =>'require',
                'avatar_url|头像'   => 'require',
                'binding|手机号码'=>'require',
                'explain|说明'=>'require',
                'service_price|服务价格(时)'=>'require',
            ];
            $this->validate($data,$rule);
        } catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        $form=TeaSpecialist::where('id',$this->tea_specialist_id)->find();
        if(TeaSpecialist::where(['acid'=>$this->acid,'account'=>$data['account'],'is_delete'=>0])->where('id','<>',$form->id)->count()){
    		 return fetchJson([],'该账号已存在',1);
    	}
    	if(!empty(input('password'))){
        	 $form->password=md5(input('password'));
        }
        $form->account=$data['account'];
        $form->nickname=$data['nickname'];
        $form->avatar_url=$data['avatar_url'];
        $form->binding=$data['binding'];
        $form->explain=$data['explain'];
        $form->service_price=$data['service_price'];
        $form->banner=$data['banner'];
        $form->save();
        return fetchJson([],'设置成功');
	}
	//提现申请
    public function applyWithdraw(){
        try {
            $data=request()->post();
            $rule = [
                'type|类型'   => 'require|in:1,2,3',
                'username|姓名'   => 'length:1,20',
                'account|账号'   => 'require|length:5,50',
                'money|金额'   => 'require|>=:50|float',
            ];
            $this->validate($data,$rule);
        }catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        $form=Withdraw::where(['acid'=>$this->acid,'user_id'=>$this->tea_specialist_id,'status'=>0,'user_type'=>Withdraw::USER_TYPE_TEASPECIALIST])->find();
        if($form){
            return fetchJson(['status'=>1],'已有提交，请等待审核通过');
        }
        if(TeaSpecialist::where('id',$this->tea_specialist_id)->value('price')<$data['money']){
             return fetchJson(['status'=>0],'可提现佣金不足');
        }
        $form=new Withdraw();
        $form->acid=$this->acid;
        $form->user_id=$this->tea_specialist_id;
        $form->asset_type=1;
        $form->user_type=Withdraw::USER_TYPE_TEASPECIALIST;
        $form->save($data);
        return fetchJson(['status'=>0],'保存成功');
    }
    //提现列表
    public function withdrawList(){
        $list=Withdraw::where(['acid'=>$this->acid,'user_id'=>$this->tea_specialist_id,'asset_type'=>1,'user_type'=>Withdraw::USER_TYPE_TEASPECIALIST])
        ->field('id,type,account,username,money,create_time,status,bank,open_bank')
        ->page($this->page)
        ->limit(10)
        ->select();
        $type=[1=>'支付宝',2=>'微信',3=>'银行卡'];
        $status=[0=>'提现中',1=>'提现成功',2=>'提现失败'];
        $color=['#fbbd08','#FF7651','#39b54a'];
        foreach ($list as $key => &$value) {
            $value['type_title']=$type[$value['type']];
            if($value['type']!=3){
                $value['bank']='';
                $value['open_bank']='';
            }
            $value['status_name']=$status[$value['status']];
            $value['status_color']=$color[$value['status']];
        }
        return fetchJson([
            'list'=>$list
        ]);
    }

}