<?php
namespace app\shared\logic\teaSpecialist;
use app\shared\model\TeaSpecialistOrder;
use app\shared\model\HouseOrder;
use app\shared\model\HouseOrderContinue;
use app\shared\model\House;
use app\shared\model\Option;
use app\shared\model\Store;
use app\shared\model\Bill;
use app\shared\model\App;
use app\shared\model\User;
use app\shared\model\TeaSpecialist;
use app\shared\model\Electricity;
use app\shared\model\ElectricityLine;
use app\shared\model\WxSubscription;
use app\shared\model\WeixinUser;
use app\shared\logic\user\HouseOrderDoorForm;
use slock\Slock;
class OrderForm extends  UserForm
{
	public function list(){
		$query=TeaSpecialistOrder::alias('ts')
			 ->leftJoin([HouseOrder::getTable()=>'ho'],'ts.house_order_id=ho.id')
			 ->leftJoin([House::getTable()=>'h'],'ho.house_id=h.id')
		     ->where(['ts.acid'=>$this->acid,'ts.is_delete'=>0,'ts.tea_specialist_id'=>$this->tea_specialist_id,'ts.is_pay'=>1]);
		$status=input('status');     
		switch($status){
			case '1':
	     		$query->where(['ts.status'=>$status]);
	     		break;
	     	case '2':
	     		$query->where(['ts.status'=>$status]);
	     		break;
	     	case '3':
	     		$query->where(['ts.status'=>$status]);
	     		break;
	     	default:
	     		break;
	    }     
		$list=$query->page($this->page)->order('ts.id DESC')->field('ts.*,ts.start_time,ts.end_time,ho.username,ho.tel,h.cover,h.name')->select();
		foreach ($list as $key => &$value) {
			$value['start_time']=date('Y-m-d H:i',$value['start_time']);
			$value['end_time']=date('Y-m-d H:i',$value['end_time']);
		}
		return fetchJson($list);
	}
	public function details(){
		$order_id=input('order_id');
		$query=TeaSpecialistOrder::alias('ts')
			 ->leftJoin([HouseOrder::getTable()=>'ho'],'ts.house_order_id=ho.id')
			 ->leftJoin([House::getTable()=>'h'],'ho.house_id=h.id')
		     ->where(['ts.acid'=>$this->acid,'ts.is_delete'=>0,'ts.tea_specialist_id'=>$this->tea_specialist_id,'ts.is_pay'=>1,'ts.id'=>$order_id]);    
		$order=$query->page($this->page)->field('ts.*,ts.start_time,ts.end_time,ho.username,ho.tel,ho.lock_password,h.name,h.cover,h.address,h.lng,h.lat')->find();
		if(!$order){
			return fetchJson([],'暂无订单',1);
		}
		$order['start_time']=date('m/d H:i',$order['start_time']);
		$order['end_time']=date('m/d H:i',$order['end_time']);
		if($order['status']!=2){
			unset($order['lock_password']);
		}
		return fetchJson($order);
	}
	//开房
    public function openRoom(){
        $order_id=input('order_id');
        $order=HouseOrder::where(['id'=>$order_id,'tea_specialist_id'=>$this->tea_specialist_id,'is_pay'=>1])->where('status','in','1,2')->find();
        if($order){
            $form=new HouseOrderDoorForm();
            return $form->openRoom($order);
        }else{
            return fetchJson([],'暂无订单',1);
        }
    }
	//接单
    public function takeOrders(){
    	$order_id=input('order_id');
    	$order=TeaSpecialistOrder::where(['id'=>$order_id,'tea_specialist_id'=>$this->tea_specialist_id,'is_pay'=>1,'status'=>1])->find();
    	if(!$order){
    		return fetchJson([],'暂无订单');
    	}else{
    		$order->status=2;
    		$order->save();
    		$user=TeaSpecialist::where('id',$this->tea_specialist_id)->find();
    		$fee=($user->fee*0.01)*$order['price'];
       		$fee=$fee>0?$fee:0;
            $user->stay_price+=($order['price']-$fee);
            $user->status=2;//服务中
            $user->save();
            //通知用户
            $app=App::where('id',$this->acid)->find();
            $app['wx_subscibe_tea_specia_order_inform']=Option::get_data($this->acid,'platform','wx_subscibe_tea_specia_order_inform');
            $openid=User::alias('u')->where(['u.id'=>$order['user_id']])
            ->leftJoin([WeixinUser::getTable()=>'w_u'],'u.account=w_u.mobile')
            ->value('w_u.wxapp_open_id');
            $houseOrder=HouseOrder::where(['id'=>$order['house_order_id']])->find();
            $msg=[
                'page'=>"teaOrder/orderDetail?id={$order['id']}",
                'order_no'=>$order['order_no'],
                'price'=>$order['price'],
                'username'=>$houseOrder['username'],
                'tel'=>$houseOrder['tel']
            ];
            $form=new WxSubscription();
            $res=$form->sendMsg($app,'shared','wx_subscibe_tea_specia_order_inform',$openid,$msg);
    		return fetchJson([
                'order_finish'=>Option::get_data($this->acid,'platform','wx_subscibe_tea_specia_order_finish')
            ],'接单成功');
    	}
    }
}