<?php
namespace app\shared\logic\teaSpecialist;
use app\shared\model\TeaSpecialist;
use think\exception\ValidateException;
use app\BaseController;
class LoginForm extends  BaseController
{
    public function __construct()
    {
        $this->initialize();
    }
    public  function  login(){
        try {
            $data=request()->post();
            $rule = [
                'acid|平台ID' =>'require|number',
                'account|账号'   => 'require',
                'password|密码'=>'require',
            ];
            $this->validate($data,$rule);
        } catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        $user=TeaSpecialist::where([
            'account'=>$data['account'],
            'password'=>md5($data['password']),
            'acid'=>$data['acid'],
        ])->withoutField('password')->find();
        if($user){
            $user->access_token=create_access_token(7);
            $user->save();
            $user['logo_url']=$user['avatar_url'];
            return fetchJson($user,'登录成功',0);
        }else{
            return fetchJson([],'账号密码错误',1);
        }
    }
}
