<?php
namespace app\shared\logic\store;
use app\shared\model\Withdraw;
use app\shared\model\Store;
use app\shared\model\User;
use app\shared\model\StoreVerifier;
use app\shared\model\StoreVerifierOrder;
use app\shared\model\HouseOrder;
use think\exception\ValidateException;
use app\BaseController;
class VerifierForm extends  Base
{
    //获取数据
    public  function index(){
        $query=StoreVerifier::where(['acid'=>$this->acid,'is_delete'=>0,'store_id'=>$this->store_id]);
        $count=$query->count();
        $list=$query->page($this->page)
        ->limit($this->limit)
        ->order('id DESC')
        ->select()
        ->toArray();
        foreach ($list as $key => &$value) {
            unset($value['password']);
        }
        return fetchJson([
            'list'=>$list,
            'count'=>$count
        ]); 
    }
    //商品编辑
    public function edit(){
        try {
            $data=request()->post();
            $rule = [
                'account|账号'=>'require',
                'name|名称'=>'require',
                'status|状态'=>'require|in:0,1',
            ]; 
            $this->validate($data,$rule);
        } catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        if(!User::where(['account'=>$data['account'],'acid'=>$this->acid])->count()){
            return fetchJson([],'该账号未注册系统~',1);
        }
        $form=StoreVerifier::where(['account'=>$data['account'],'is_delete'=>0,'store_id'=>$this->store_id])->find();
        if(!$form){
            $form=new StoreVerifier();
            $form->acid=$this->acid;
            $form->store_id=$this->store_id;
        }
        $form->account=$data['account'];
        $form->name=$data['name'];
        $form->status=$data['status'];
        $form->save();
        return fetchJson([],'保存成功');
    }
    //删除
    public function delete(){
         $id=input('id');
         StoreVerifier::where(['acid'=>$this->acid,'store_id'=>$this->store_id,'id'=>$id])->update(['is_delete'=>1]);
         return fetchJson([],'删除成功');
    }
    //核销订单列表
    public function orderList(){
        $status=input('status')?input('status'):0;
        $query=HouseOrder::where(['is_verifier'=>1,'acid'=>$this->acid,'store_id'=>$this->acid])
                         ->field('id,order_no,username,tel,price,pay_type,start_time,end_time,snapshoot,status,is_verifier,create_time');
        $keyword=input('keyword');
        if($keyword){
            $query->where('order_no','like',"%{$keyword}%");
        }                 
        switch ($status){
            case "-10":
            $count=$query->count();
            $list=$query->page($this->page)
                         ->limit($this->limit)
                         ->order('id DESC')
                         ->select();
            break;
             case "-2":
             $query->where('status',$status);
             $count=$query->count();
             $list=$query->page($this->page)
                         ->limit($this->limit)
                         ->order('id DESC')
                         ->select();
            break;
             case "-1":
             $query->where('status',$status);
             $count=$query->count();
             $list=$query->page($this->page)
                         ->limit($this->limit)
                         ->order('id DESC')
                         ->select();
            break;
             case "0":
             $query->where('status',$status);
             $count=$query->count();
             $list=$query->page($this->page)
                         ->limit($this->limit)
                         ->order('id DESC')
                         ->select();
            break;
             case "1":
             $query->where('status',$status);
             $count=$query->count();
             $list=$query->page($this->page)
                         ->limit($this->limit)
                         ->order('id DESC')
                         ->select();
            break;
             case "2":
             $query=StoreVerifierOrder::alias('vo')
                          ->leftJoin([HouseOrder::getTable()=>'o'],'vo.order_id=o.id')
                          ->leftJoin([StoreVerifier::getTable()=>'v'],'vo.verifier_id=v.id')
                         ->where(['o.is_verifier'=>1,'o.acid'=>$this->acid,'o.store_id'=>$this->store_id])
                         ->field('o.id,o.order_no,o.username,o.tel,o.price,o.pay_type,o.start_time,o.end_time,o.snapshoot,vo.verifier_time,vo.verifier_id,v.name,v.account,vo.create_time,o.status');
            if($keyword){
                $query->where('o.order_no','like',"%{$keyword}%");
            }               
            $count=$query->count();
            $list=$query->page($this->page)
                         ->limit($this->limit)
                         ->order('o.id DESC')
                         ->select();
            break;
           default:
                break;
        }
        foreach ($list as &$value){
            $value['snapshoot']=json_decode($value['snapshoot'],1);
            $value['verifier_time']=isset($value['verifier_time'])?date('Y-m-d H:i:s',$value['verifier_time']):0;
            $value['start_time']=isset($value['start_time'])?date('Y-m-d H:i',$value['start_time']):0;
            $value['end_time']=isset($value['end_time'])?date('Y-m-d H:i',$value['end_time']):0;

        }
        return fetchJson([
           'list'=>$list,
           'count'=>$count
        ]);            

    }
}