<?php
namespace app\shared\logic\store;
use app\shared\model\App;
use app\shared\model\Option;
use app\shared\model\User;
use app\shared\model\Store;
use app\shared\model\Goods;
use app\shared\model\HouseOrder;
use app\shared\model\HouseOrderContinue;
use app\shared\model\House;
use app\shared\model\Bill;
use app\shared\model\UserUv;
use think\exception\ValidateException;
use app\BaseController;
class IndexForm extends  Base
{
    //数据统计
    public  function statistics(){
        $house_price=0;
        $start_date=input('start_date');
        $end_date=input('end_date');
        $days=7;
        if($end_date){
           $time=strtotime($end_date);
           $days=strtotime($end_date)-strtotime($start_date);
           $days=$days/86400;
           if($days<7){
            $days=7;
           }
           $end_date=date('Y-m-d',strtotime($end_date)+86400);
        }else{
          $time=time();
        }
        $getServenDay=getServenDay(date('Y-m-d',$time+86400),0,$days);
        $getServenDay = array_column($getServenDay,'time');
        $house_order_arr=[];
        foreach ($getServenDay as $day) {
           $house_order_arr[]=HouseOrder::where(['acid'=>$this->acid,'is_pay'=>1,'store_id'=>$this->store_id])->where('status',3)->whereDay('update_time',$day)->count();
        }
        if($start_date&&$end_date){
          $sum_earnings=Bill::where(['acid'=>$this->acid,'account_type'=>Bill::ACCOUNT_TYPE_STORE,'is_delete'=>0,'form_id'=>$this->store_id,'status'=>1])
          ->whereBetweenTime('create_time',$start_date,$end_date)->sum('price');
          $sum_store_balance=Bill::where(['acid'=>$this->acid,'account_type'=>Bill::ACCOUNT_TYPE_STORE,'is_delete'=>0,'form_id'=>$this->store_id,'status'=>1,'price_type'=>3])
          ->whereBetweenTime('create_time',$start_date,$end_date)->sum('price');
          $sum_balance=Bill::where(['acid'=>$this->acid,'account_type'=>Bill::ACCOUNT_TYPE_STORE,'is_delete'=>0,'form_id'=>$this->store_id,'status'=>1,'price_type'=>2])
          ->whereBetweenTime('create_time',$start_date,$end_date)->sum('price');
          $sum_wechatPay=Bill::where(['acid'=>$this->acid,'account_type'=>Bill::ACCOUNT_TYPE_STORE,'is_delete'=>0,'form_id'=>$this->store_id,'status'=>1,'price_type'=>1])
          ->whereBetweenTime('create_time',$start_date,$end_date)->sum('price');
          $house_order_num=HouseOrder::where(['acid'=>$this->acid,'store_id'=>$this->store_id])
          ->whereBetweenTime('update_time',$start_date,$end_date)->where('status',3)->count();
        }else{
          $sum_earnings=Bill::where(['acid'=>$this->acid,'account_type'=>Bill::ACCOUNT_TYPE_STORE,'is_delete'=>0,'form_id'=>$this->store_id,'status'=>1])->sum('price');
          $sum_store_balance=Bill::where(['acid'=>$this->acid,'account_type'=>Bill::ACCOUNT_TYPE_STORE,'is_delete'=>0,'form_id'=>$this->store_id,'status'=>1,'price_type'=>3])->sum('price');
          $sum_balance=Bill::where(['acid'=>$this->acid,'account_type'=>Bill::ACCOUNT_TYPE_STORE,'is_delete'=>0,'form_id'=>$this->store_id,'status'=>1,'price_type'=>2])->sum('price');
          $sum_wechatPay=Bill::where(['acid'=>$this->acid,'account_type'=>Bill::ACCOUNT_TYPE_STORE,'is_delete'=>0,'form_id'=>$this->store_id,'status'=>1,'price_type'=>1])->sum('price');
          $house_order_num=HouseOrder::where(['acid'=>$this->acid,'store_id'=>$this->store_id])->where('status',3)->count();
        }
        $today_earnings=Bill::where(['acid'=>$this->acid,'account_type'=>Bill::ACCOUNT_TYPE_STORE,'is_delete'=>0,'form_id'=>$this->store_id,'status'=>1])->whereDay('update_time',date('Y-m-d'))->sum('price');
        $house_order_sumprice=$sum_earnings;
        return fetchJson([
            'sum_earnings'=>$sum_earnings,
            'house_order_num'=>$house_order_num,
            'house_order_sumprice'=>$house_order_sumprice,
            'today_earnings'=>$today_earnings,
            'sum_balance'=>$sum_balance,
            'sum_wechatPay'=>$sum_wechatPay,
            'sum_store_balance'=>$sum_store_balance,
            'store_uv'=>UserUv::where(['store_id'=>$this->store_id,'type'=>1])->group('user_id')->count(),
            'house_uv'=>UserUv::where(['store_id'=>$this->store_id,'type'=>2])->group('user_id')->count(),
            'goods_uv'=>UserUv::where(['store_id'=>$this->store_id,'type'=>3])->group('user_id')->count(),
            'broken_line'=>[
                'date'=>$getServenDay,
                'legend'=>['茶室订单'],
                'series'=>[
                    [
                        'name'=>'茶室订单',
                        'type'=>'line',
                        'stack'=>'总量',
                        'data'=>$house_order_arr
                    ],
                ]
            ]
        ]);
    }
    public function uvList(){
       $query=UserUv::alias('uv')
                    ->leftJoin([User::getTable()=>'u'],'uv.user_id=u.id')
                    ->where('uv.store_id',$this->store_id)
                    ->field('u.nickname,u.avatar_url,uv.create_time,uv.type,uv.form_id');
       $count=$query->count();
       $list=$query->page($this->page)->limit($this->limit)->order('uv.id DESC')->select();
       $logo=Store::where('id',$this->store_id)->value('logo');
       $logo=get_file_url($logo);
       foreach ($list as &$value){
          if($value['type']==1){
             $value['title']='访问本商户';
             $value['cover_url']=$logo;
          }else if($value['type']==2){
             $house=House::where('id',$value['form_id'])->field('name,cover')->find();
             $value['title']='浏览茶室：'.$house['name'];
             $value['cover_url']=$house['cover'];
          }else if($value['type']==3){
             $goods=House::where('id',$value['form_id'])->field('name,cover')->find();
             $value['title']='浏览商品：'.$goods['name'];
             $value['cover_url']=get_file_url($goods['cover']);
          }else{
             $value['title']='未知';
             $value['cover_url']='未知';
          }
       }
       return fetchJson([
          'count'=>$count,
          'list'=>$list
       ]);
    }
}