<?php
namespace app\shared\logic\store;
use app\shared\model\HouseStock;
use think\exception\ValidateException;
use app\BaseController;
class HouseStockForm extends  Base
{
    //获取数据
    public  function index(){
        try {
            $data=request()->post();
            $rule = [

                'house_id|房间ID' =>'require|number',
                'date|日期'   => 'require|date',
            ];
            $this->validate($data,$rule);
        } catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        $date=strtotime($data['date']);
        $stock=HouseStock::where(['acid'=>$this->acid,'store_id'=>$this->store_id,'house_id'=>$data['house_id'],'date'=>$date])->column('id,hour,status,order_id');
        $stockData=[];
        $stockArr=[];
        foreach ($stock as $vsindex=> &$vs){
          $vs['dd']=date('Y-m-d H:i',$vs['hour']);
        }

        for ($j=0;$j<48;$j++){
           $time=strtotime(date('Y-m-d H:i',$date))+1800*$j;
           foreach($stock as $v){
              if($time>($v['hour']-1800)&&$time<($v['hour']+1800)){
                   $stockData[date('Y-m-d H:i',$v['hour'])]=[
                        'hour'=>$time,
                        'id'=>$v['id'],
                        'data'=>date('Y-m-d H:i',$time),
                        'status'=>$v['status'],
                        'order_id'=>0//$v['order_id'],
                     ];   
              }
           } 
        }

        $hourStock=array_column($stockData,'status','hour');
        $hourStockOrder=array_column($stockData,'order_id','hour');
        for ($j=0;$j<48;$j++){
           $time=strtotime(date('Y-m-d H:i',$date))+1800*$j;
           $stockArr[]=[
             'time'=>date('H:i',$time),
             'status'=>isset($hourStock[$time])?$hourStock[$time]:1,
             'order_id'=>isset($hourStockOrder[$time])?$hourStockOrder[$time]:0,
           ];
        }
        return fetchJson([
            'stock'=>$stockArr
        ]);
    }
    //编辑库存
    public function edit(){
         try {
            $data=request()->post();
            $rule = [
                'house_id|房间ID' =>'require|number',
                'date|日期'   => 'require|date',
                'hour|小时'   =>'require',
                'status|状态' =>'require|in:0,1'
            ];
            $this->validate($data,$rule);
        } catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        $date=strtotime($data['date']);
        $hour=strtotime($data['date'].' '.$data['hour']);
        $form=HouseStock::where(['acid'=>$this->acid,'store_id'=>$this->store_id,'house_id'=>$data['house_id'],'date'=>$date,'hour'=>$hour])->find();
        if(!$form){
            $form=new HouseStock();
        }
        if($data['status']==1){
            $form->order_id=0;
        }
        $form->save([
            'acid'=>$this->acid,
            'store_id'=>$this->store_id,
            'house_id'=>$data['house_id'],
            'date'=>$date,
            'hour'=>$hour,
            'status'=>$data['status']
        ]);
        return fetchJson([],'保存成功');
    }
}