<?php
namespace app\shared\logic\store;
use app\shared\model\HouseOrder;
use app\shared\model\HouseOrderContinue;
use app\shared\model\CardUserOrder;
use app\shared\model\CouponUser;
use app\shared\model\Coupon;
use app\shared\model\StoreCouponUser;
use app\shared\model\StoreCoupon;
use app\shared\model\Card;
use app\shared\model\CardUser;
use app\shared\model\CardCouponOrder;
use app\shared\model\CardCoupon;
use app\shared\model\PartnerUserOrder;
use think\exception\ValidateException;
use app\BaseController;
class HouseOrderForm extends  Base
{
    //获取数据
    public  function index(){
        $query=HouseOrder::where(['acid'=>$this->acid,'is_delete'=>0,'store_id'=>$this->store_id]);
        $status=input('status');
        if($status!=-10){
            $query->where('status',$status);
        }
        $keyword=input('keyword');
        if($keyword){
            $query=$query->where('username|tel|order_no','like',"%{$keyword}%");
        }
        $count=$query->count();
        $list=$query
        ->page($this->page)
        ->limit($this->limit)
        ->order('id DESC')
        ->select()
        ->toArray();
        foreach ($list as $key => &$value) {
            $value['snapshoot']=json_decode($value['snapshoot'],1);
            $value['start_time']=date('Y-m-d H:i:s',$value['start_time']);
            $value['end_time']=date('Y-m-d H:i:s',$value['end_time']);
            $order_continue_list=HouseOrderContinue::where(['status'=>1,'order_id'=>$value['id']])->order('id DESC')->column('id,start_time,price,end_time');
            $price=0;
            $card_user_order=CardUserOrder::alias('cuo')
            ->leftJoin([CardUser::getTable()=>'cu'],'cuo.card_user_id=cu.id')
            ->leftJoin([Card::getTable()=>'c'],'cu.card_id=c.id')
            ->where(['cuo.type'=>1,'cuo.order_id'=>$value['id']])
            ->field('cuo.price,cuo.hour,cuo.discount,cuo.status,cuo.type,c.title')
            ->find();
            if($card_user_order){
               $discounts_price=$card_user_order['discount']*($value['price']-$card_user_order['price'])*0.1;
               $card_user_order['discounts_price']=($value['price']-$card_user_order['price'])-$discounts_price;
            }
            foreach ($order_continue_list as $k => &$v) {
               $v['start_time']=date('Y-m-d H:i',$v['start_time']);
               $v['end_time']=date('Y-m-d H:i',$v['end_time']);
               if($k==0){
                  $value['end_time']=$v['end_time'];
               }
               $price+=$v['price'];
            }
            $value['pay_price']+=$price;
            $value['pay_price']=round($value['pay_price'],2);
            $value['price']+=$price;
            $value['price']=round($value['price'],2);
            $value['order_continue_list']=$order_continue_list;
            $value['card_user_order']=$card_user_order; 
            $couponUser=CouponUser::alias('a')
            ->leftJoin([Coupon::getTable()=>'b'],'a.coupon_id=b.id')
            ->where(['a.id'=>$value['coupon_user_id'],'a.type'=>Coupon::TYPE_HOTEL])
            ->field('a.discounts_price,b.name')->find();
            $value['discounts_name']=$couponUser['name'];
            $value['discounts_price']=$couponUser['discounts_price']>0?$couponUser['discounts_price']:0;

            $storeCouponUser=StoreCouponUser::alias('a')
            ->leftJoin([StoreCoupon::getTable()=>'b'],'a.coupon_id=b.id')
            ->where(['a.id'=>$value['store_coupon_user_id'],'a.type'=>StoreCoupon::TYPE_HOTEL])
            ->field('a.discounts_price,b.name')->find();
            $value['store_discounts_name']=$storeCouponUser['name'];
            $value['store_discounts_price']=$storeCouponUser['discounts_price']>0?$storeCouponUser['discounts_price']:0;
            $value['partner_user_order']=PartnerUserOrder::where(['type'=>1,'order_id'=>$value['id']])->column('id,hour,price');
            $value['card_coupon']=CardCouponOrder::alias('cco')->leftJoin([CardCoupon::getTable()=>'cc'],'cco.card_coupon_id=cc.id')->where(['cco.order_id'=>$value['id']])->field('cc.discounts_price,cc.name,cco.id')->find();
        }
        return fetchJson([
            'list'=>$list,
            'count'=>$count
        ]);
    }
    //提前结束订单
    public function endOrdersEarly(){
        $order=HouseOrder::where(['id'=>input('order_id'),'is_pay'=>1])->where('status','in','1,2')->find();
        if(!$order){
            return fetchJson([],'暂无订单',1);
        }
        $form= new \app\task\controller\Wechat();
        $form->endOrdersEarly($order);
        return fetchJson([],'提前结束订单');
    }
}