<?php
namespace app\shared\logic\store;
use app\shared\model\House;
use app\shared\model\Store;
use app\shared\model\ElectricityLine;
use think\exception\ValidateException;
use app\shared\model\Facility;
use app\shared\model\Tags;
use app\shared\model\LumiElectricityConfig;
use app\BaseController;
class HouseForm extends  Base
{
    //获取数据
    public  function index(){
        $query=House::where(['acid'=>$this->acid,'is_delete'=>0,'store_id'=>$this->store_id]);
        $count=$query->count();
        $list=$query->page($this->page)->limit($this->limit)->order('sort ASC')->select();
        foreach ($list as $key => &$value) {
            $value['servicing_time']=json_decode($value['servicing_time'],1);
            $value['cover_url']=get_file_url($value['cover']);
            $value['banner_list']=get_file_urls($value['banner']);
            $value['line_config']=ElectricityLine::where([
              'acid'=>$value['acid'],
              'store_id'=>$value['store_id'],
              'mac'=>$value['electricityid'],
              'house_id'=>$value['id'],
              'is_delete'=>0
           ])->column('line,ahead_time,forward_time');
           $lumi_electricity_config=LumiElectricityConfig::where([
              'acid'=>$value['acid'],
              'store_id'=>$value['store_id'],
              'house_id'=>$value['id'],
              'is_delete'=>0
           ])->column('dev_did,dev_model,resource,ahead_time,forward_time,reset_time,remark');
           foreach ($lumi_electricity_config as &$vlm){
               $vlm['resource']=json_decode($vlm['resource'],1);
           }
           $value['lumi_electricity_config']=$lumi_electricity_config;
           $value['price_list']=json_decode($value['price_list'],1);
        }
        return fetchJson([
            'list'=>$list,
            'count'=>$count
        ]);
    }
    //编辑
    public function edit(){
        try {
          $data=request()->post();
          $rule = [
               'id|ID' => 'require',
               'area_id|区域ID' => 'require',
               'name|名称' => 'require',
               'cover|封面' => 'require',
               'banner|轮播' => 'require',
               'servicing_time|服务时间' => 'require',
               'facility_servicing|设施服务' => 'require',
               'is_recommend|是否推荐' => 'require',
               'address|地址' => 'require',
               'lat|纬度' => 'require',
               'lng|经度' => 'require',
               'status|姓名'=>'require',
               'price|价格'=>'require',
               'sort|排序'=>'require',
               'lockid|智能锁设备ID'=>'require',
               'electricityid|智能电设备ID'=>'require',
               'booktime|起订时间'=>'require|float',
               'peoplenum|建议人数'=>'require',
               'is_network|锁是否联网'=>'require|in:0,1',
           ];
           $this->validate($data,$rule);
       }catch (ValidateException $e){
           return fetchJson([],$e->getError(),1);
       }

       $form=House::where(['id'=>$data['id'],'store_id'=>$this->store_id])->find();
       $price=0;
       if(!$form){
            $form=new House();
            $form->acid=$this->acid;
            $form->store_id=$this->store_id;
            $price_list=self::priceList($data['price']);
       }else{
          if($data['price']!=$form->price){
             $price=$data['price'];
          }
          $price_list=input('price_list')?self::changePriceList(input('price_list'),$price):self::priceList($data['price']);
       }
       $form->save([
            'area_id'=>$data['area_id'],
            'name'=>$data['name'],
            'cover'=>$data['cover'],
            'banner'=>$data['banner'],
            'servicing_time'=>$data['servicing_time'],
            'facility_servicing'=>$data['facility_servicing'],
            'is_recommend'=>$data['is_recommend'],
            'address'=>$data['address'],
            'lat'=>$data['lat'],
            'lng'=>$data['lng'],
            'status'=>$data['status'],
            'price'=>$data['price'],
            'sort'=>$data['sort'],
            'gatelockid'=>input('gatelockid'),
            'lockid'=>$data['lockid'],
            'electricityid'=>$data['electricityid'],
            'booktime'=>$data['booktime'],
            'peoplenum'=>$data['peoplenum'],
            'is_network'=>$data['is_network'],
            'ahead_time'=>input('ahead_time'),
            'forward_time'=>input('forward_time'),
            'electricty_line_config'=>input('electricty_line_config'),
            'lvelectricty_line_config'=>input('lvelectricty_line_config'),
            'open_type'=>input('open_type')?input('open_type'):1,
            'price_list'=>$price_list,
            'book_types'=>input('book_types')?input('book_types'):'',
            'limit_time'=>input('limit_time')?input('limit_time'):5,
            'member_price'=>input('member_price')?input('member_price'):0,
            'original_price'=>input('original_price')?input('original_price'):0,
            'package_price'=>input('package_price')?input('package_price'):'',
            'cancel_time'=>input('cancel_time')?input('cancel_time'):30,
            'video_url'=>input('video_url')?input('video_url'):0,
       ]);
       $form->save();
       $tea_price=House::where(['store_id'=>$this->store_id,'is_delete'=>0])->min('price');
       Store::where('id',$this->store_id)->update(['tea_price'=>$tea_price]);
       return fetchJson([],'保存成功');
    }
    //删除
    public function delete(){
        House::where(['id'=>input('id'),'store_id'=>$this->store_id])->update(['is_delete'=>1]);
        return fetchJson([],'删除成功');
    }
    //获取服务设施
    public function getFacility(){
        $list=Facility::where(['acid'=>$this->acid,'is_delete'=>0])->page($this->page)->order('sort ASC')->limit(20)->column('id,title');
        return fetchJson($list,'获取成功');
    }
    //获取服务设施
    public function getTags(){
        $list=Tags::where(['acid'=>$this->acid,'is_delete'=>0])->page($this->page)->limit(20)->column('id,title');
        return fetchJson($list,'获取成功');
    }
    //价格表
    private function priceList($price=0){
        $list=[];
        for($i=0;$i<24;$i++){
            $list[]=[
              'time'=>$i<10?'0'.$i:$i,
              'price'=>$price
            ];
        }
        return json_encode($list);
    }
    //改价格表
    private function changePriceList($priceList=[],$price=0){
        $priceList=json_decode($priceList,1);
        $list=[];
        foreach ($priceList as $value){
           if($value['price']<0){
              $list[]=[
                'time'=>$value['time'],
                'price'=>0,
              ];
           }else{
              $list[]=[
                'time'=>$value['time'],
                'price'=>$price>0?$price:$value['price'],
              ];
           }
        }
        return json_encode($list);
    }
}