<?php
namespace app\shared\logic\store;
use app\shared\model\StoreCoupon;
use app\shared\model\StoreCouponUser;
use app\shared\model\User;
use think\exception\ValidateException;
use app\BaseController;
class CouponForm extends  Base
{
    //获取数据
    public  function index(){
        $query=StoreCoupon::where(['acid'=>$this->acid,'is_delete'=>0,'store_id'=>$this->store_id]);
        if($send_type=input('send_type')){
            $query->where('send_type',$send_type);
        }
        if($type=input('type')){
            $query->where('type',$type);
        }
        $count=$query->count();
        $list=$query->page($this->page)
        ->limit($this->limit)
        ->order('id DESC')
        ->select();
        foreach ($list as $key => &$value) {
            $value['start_time']=date('Y-m-d',$value['start_time']);
            $value['end_time']=date('Y-m-d',$value['end_time']);
        }
        return fetchJson([
            'list'=>$list,
            'count'=>$count
        ]);
    }
    //编辑
    public function edit(){
        try {
            $data=request()->post();
            $rule = [
                'id|ID'=>'require',
                'name|名称'=>'require',
                'send_type|发放类型'=>'require|in:1,2,3,4', //1新人注册、2转发、3领券中心、4拼桌邀请
                'type|类型'=>'require|in:1,2,3', //1茶室预订2茶艺师,3商城
                'status|状态'=>'require|in:1,0',
                'start_time|开始时间'=>'require|date',
                'end_time|结束时间'=>'require|date',
                'price|优惠金额'=>'require|>:0.01',
                'full_price|满足金额'=>'require|>=:0',
            ];
            $this->validate($data,$rule);
        } catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        $form=StoreCoupon::where(['id'=>$data['id']])->find();
        if(!$form){
            $form=new StoreCoupon();
            $form->acid=$this->acid;
            $form->store_id=$this->store_id;

        }
        $form->cover=input('cover');
        $form->send_type=$data['send_type'];
        $form->type=$data['type'];
        $form->name=$data['name'];
        $form->status=$data['status'];
        $form->start_time=strtotime($data['start_time']);
        $form->end_time=strtotime($data['end_time'])+86399;
        $form->price=$data['price'];
        $form->full_price=$data['full_price'];
        $form->save();
        return fetchJson([],'保存成功');
    }
    //删除
    public function delete(){
         $id=input('id');
         StoreCoupon::where(['acid'=>$this->acid,'id'=>$id])->update(['is_delete'=>1]);
         return fetchJson([],'删除成功');
    }
    //优惠券发放
    public function distribution(){
        try {
            $data=request()->post();
            $rule = [
                'id|ID'=>'require|number',
                'user_id|用户ID'=>'require|number',
                'num|数量'=>'require|number',
            ];
            $this->validate($data,$rule);
        } catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        $coupon=StoreCoupon::where(['id'=>$data['id']])->find();
        if(!$coupon){
            return fetchJson([],'暂无优惠券',1);    
        }
        $user=User::where(['id'=>$data['user_id']])->find();
        if(!$user){
            return fetchJson([],'暂无用户',1);      
        }
        if($data['num']<0){
            return fetchJson([],'数量不得为负数',1);
        }
        if($data['num']>50){
            return fetchJson([],'单次发放不得超过50张',1);
        }
        for($i=0; $i<$data['num']; $i++) { 
            $form=new StoreCouponUser();
            $form->save([
                'acid'=>$this->acid,
                'coupon_id'=>$coupon['id'],
                'user_id'=>$user['id'],
                'type'=>$coupon['type'],
            ]);
        }
        return fetchJson([],'发放成功'); 
    }
}