<?php
namespace app\shared\logic\platform;
use app\shared\model\User;
use app\shared\model\WeixinUser;
use app\shared\model\Bill;
use app\shared\model\HouseOrder;
use think\exception\ValidateException;
use app\BaseController;
class UserForm extends  Base
{
    //获取数据
    public  function index(){
        $keyword=input('keyword');
        $field=input('field');
        $query=User::alias('u')
        ->where(['u.acid'=>$this->acid]);
        if($keyword){
            if($field){
                $fieldArray=['u.id','u.nickname','u.account'];
                $searchField=$field;
                if(!in_array($field,$fieldArray)){
                    $searchField='u.id|u.nickname|u.account';
                }
            }else{
                $searchField='u.id|u.nickname|u.account';
            }
            $query=$query->where($searchField,'like',"%{$keyword}%");
        }
        $count=$query->count();
        $list=$query
        ->page($this->page)
        ->limit($this->limit)
        ->order('u.money DESC,u.id DESC')
        ->select();
        foreach ($list as $key => &$value) {
           $value['wxapp_open_id']=WeixinUser::where(['acid'=>$this->acid,'mobile'=>$value['account']])->value('wxapp_open_id');
           $value['order_num']=HouseOrder::where(['user_id'=>$value['id'],'status'=>3])->count();
        }
        return fetchJson([
            'list'=>$list,
            'count'=>$count
        ]);
    }
    public function edit(){
        try {
           $data=request()->post();
           $rule = [
               'id|ID' => 'require|number',
               'is_blacklist|是否加入黑名单'=>'require|in:0,1',
            ];
           $this->validate($data,$rule);
        }catch (ValidateException $e){
           return fetchJson([],$e->getError(),1);
        }
        $user=User::where('id',$data['id'])->find();
        $user->is_blacklist=$data['is_blacklist'];
        $user->save();
        return fetchJson([],'保存成功');
    }
    //充值
    public function recharge(){
        try {
           $data=request()->post();
           $rule = [
               'id|ID' => 'require|number',
               'money|金额'=>'require|float|>=:0',
               'integral|积分'=>'require|number|>=:0',
               'status|类型'=> 'require|in:-1,1',
            ];
           $this->validate($data,$rule);
        }catch (ValidateException $e){
           return fetchJson([],$e->getError(),1);
        }
        $user=User::where('id',$data['id'])->find();
        if($user){
           if($data['money']||$data['integral']){
               if($data['status']==1){
                   $user->money+=$data['money'];
                   $user->integral+=$data['integral'];   
               }else{
                   $user->money-=$data['money'];
                    $user->integral-=$data['integral']; 
                   if($user->money<0||$user->integral<0){
                        return fetchJson([],'金额和积分不能小于0',1);
                   }
               }
               $balance=$user->money;
               $des=input('des');
               if(!$des){
                  $form_account=User::where('access_token',input('u_access_token'))->value('account');
                  $des=$data['status']==1?'后台充值金额':'后台扣除金额';
                  if($form_account){
                    $form_account=preg_replace('/(\d{3})\d{4}(\d{4})/', '$1****$2', $form_account);
                    $des=$data['status']==1?"管理员：【{$form_account}】为您充值金额":"管理员：【{$form_account}】为您扣除金额";
                  }
               }else{
                  $form_account=User::where('access_token',input('u_access_token'))->value('account');
                  if($form_account){
                    $form_account=preg_replace('/(\d{3})\d{4}(\d{4})/', '$1****$2', $form_account);
                    $des="管理员：【{$form_account}】为您".$des;
                  }
               }
               (new Bill())->save([
                    'acid'=>$this->acid,
                    'type'=>Bill::TYPE_RECHARGE,
                    'account_type'=>Bill::ACCOUNT_TYPE_USER,
                    'form_id'=>$user['id'],
                    'price'=>$data['money'],
                    'integral'=>$data['integral'],
                    'price_type'=>2,
                    'status'=>$data['status'],
                    'des'=>$des,
                    'balance'=>$balance
               ]);
               $user->save();
               $statu_name=$data['status']==1?'充值':'扣除';
               return fetchJson($user,'操作成功');
           }else{
               return fetchJson([],'金额和积分不能同时为0',1);
           }
        }
        return fetchJson([],'暂无用户',1);
    }
    //充值记录
    public function rechargeLog(){
        $id=input('id');
        $query=Bill::where([
            'acid'=>$this->acid,
            'account_type'=>Bill::ACCOUNT_TYPE_USER,
            'form_id'=>$id
        ]);
        $count=$query->count();
        $list=$query->limit($this->limit)->page($this->page)->order('id DESC')->select();
        return fetchJson([
            'list'=>$list,
            'count'=>$count,
        ]);
    }

}