<?php
namespace app\shared\logic\platform;
use app\shared\model\Option;
use app\shared\model\Theme;
use think\exception\ValidateException;
use app\BaseController;
use think\facade\Cache;

class ThemeForm extends  Base
{
    //获取数据
    public  function index(){
    	$form=Option::get_data($this->acid,'shared','app_home_theme');
    	$list=Theme::themeList();
    	if($form){
    		 $form=json_decode($form,1);
             foreach ($list as $key=>&$value){
             	if($form['type']==$value['type']){
                    $form['service']=isset($form['service'])?$form['service']:$value['service'];
                    $form['local_t']=isset($form['local_t'])?$form['local_t']:$value['local_t'];
                    $form['local_l']=isset($form['local_l'])?$form['local_l']:$value['local_l'];
                    $form['park']=isset($form['park'])?$form['park']:$value['park'];
                    $form['service_tel']=isset($form['service_tel'])?$form['service_tel']:$value['service_tel'];
                    $form['tea_circle']=isset($form['tea_circle'])?$form['tea_circle']:$value['tea_circle'];
             		$value=$form;
             		$value['is_select']=true;
             	}else{
             		$value['is_select']=false;
             	}
             }
    	}
    	return fetchJson($list);
    }
    //编辑
    public function edit(){
    	if(input('is_find')){
    		$form=Option::get_data($this->acid,'shared','app_home_theme');
    		$form=json_decode($form,1);
    		return fetchJson($form);
    	}
    	$form=Option::set_data($this->acid,'shared','app_home_theme',input('app_home_theme'));
    	return fetchJson([],'保存成功');
    }
    public function userCenter(){
        if(input('is_find')){
            $form=Option::get_data($this->acid,'shared','app_user_center_config');
            $form=json_decode($form,1);
            $url=request()->domain().str_replace('index.php', '',request()->baseFile()).'static/shared/';
            if(!$form){
                $form=[
                    'type'=>1,
                    'money'=>[
                        'status'=>1,
                        'price'=>1,
                        'tea'=>1,
                    ],
                    'tea_order'=>[
                        ['icon'=>$url.'order/daifukuan.svg','url'=>'/order/index?status=1','title'=>'待付款'],
                        ['icon'=>$url.'order/daishiyong.svg','url'=>'/order/index?status=2','title'=>'待使用'],
                        ['icon'=>$url.'order/shiyongzhong.svg','url'=>'/order/index?status=3','title'=>'使用中'],
                        ['icon'=>$url.'order/yiwancheng.svg','url'=>'/order/index?status=4','title'=>'已完成'],
                        ['icon'=>$url.'order/quanbu.svg','url'=>'/order/index?status=0','title'=>'全部'],
                    ],
                    'is_share'=>1,
                    'myserve'=>[
                        ['icon'=>$url.'myserve/chayishidd.svg','show_type'=>1,'type'=>"common",'status'=>1,'url'=>'/teaOrder/index','title'=>'茶艺师订单'],
                        ['icon'=>$url.'myserve/shangpingdd.svg','show_type'=>1,'type'=>"common",'status'=>1,'url'=>'/pages/user/buyHistory/index','title'=>'商品订单'],
                        ['icon'=>$url.'myserve/shanghugl.svg','show_type'=>1,'type'=>"store",'status'=>1,'url'=>'/storeManager/navBar/index','title'=>'商户管理'],
                        ['icon'=>$url.'myserve/jiamenghezuo.svg','show_type'=>1,'type'=>"storeJoin",'status'=>1,'url'=>'/pages/store/joinUs','title'=>'加盟合作'],
                        ['icon'=>$url.'myserve/pingtaixieyi.svg','show_type'=>1,'type'=>"common",'status'=>1,'url'=>'/pages/user/protocol/index?type=1','title'=>'平台协议'],
                        ['icon'=>$url.'myserve/gudongfenhong.svg','show_type'=>1,'type'=>"shareholder_receive",'status'=>1,'url'=>'/stock/index','title'=>'股东分红'],
                        ['icon'=>$url.'myserve/baojieduan.svg','show_type'=>1,'type'=>"common",'status'=>1,'url'=>'/storeManager/cleaner/index','title'=>'保洁端'],
                        ['icon'=>$url.'myserve/meituanyanquan.svg','show_type'=>1,'type'=>"meituan_coupon",'status'=>1,'url'=>'/pages/user/meituan/getCoupon','title'=>'美团验券'],
                        ['icon'=>$url.'myserve/chayishiduan.svg','show_type'=>1,'type'=>"common",'status'=>1,'url'=>'/teaMasterPort/navBar/Footer','title'=>'茶艺师端'],
                        ['icon'=>$url.'myserve/bangzhuzhongxing.svg','show_type'=>1,'type'=>"common",'status'=>1,'url'=>'/pages/user/protocol/index?type=2','title'=>'帮助中心'],
                        ['icon'=>$url.'myserve/guanyuwomen.svg','show_type'=>1,'type'=>"common",'status'=>1,'url'=>'/pages/user/protocol/index?type=3','title'=>'关于我们'],
                        ['icon'=>$url.'myserve/shouhuodizhi.svg','show_type'=>1,'type'=>"common",'status'=>1,'url'=>'/pages/address/index','title'=>'收货地址'],
                        ['icon'=>$url.'myserve/woyaokaipiao.png','show_type'=>1,'type'=>"common",'status'=>1,'url'=>'/invoice/index','title'=>'我要开票'],
                        ['icon'=>$url.'myserve/mianfeihecha.png','show_type'=>1,'type'=>"invite_tea",'status'=>1,'url'=>'/group/index','title'=>'免费约茶'],
                        ['icon'=>$url.'myserve/zaixiankefu.svg','show_type'=>1,'type'=>"kefu",'status'=>1,'url'=>'','title'=>'在线客服'],
                        ['icon'=>$url.'myserve/paihangbang.png','show_type'=>1,'type'=>"ranking",'status'=>0,'url'=>'/group/ranking/index','title'=>'排行榜'],
                        ['icon'=>$url.'myserve/chayishi.png','show_type'=>1,'type'=>"tea_specialist",'status'=>0,'url'=>'/teaMaster/teaMasterApply','title'=>'茶艺师申请'],
                    ],
                ];
            }else{
               $form['money']=json_decode($form['money'],1);
               $myserve=array_column($form['myserve'],'title','type');
               if(!isset($myserve['ranking'])){
                 $form['myserve']=array_merge($form['myserve'],[['icon'=>$url.'myserve/paihangbang.png','type'=>"ranking",'status'=>0,'url'=>'/group/ranking/index','title'=>'排行榜']]);
               }
               if(!isset($myserve['tea_specialist'])){
                 $form['myserve']=array_merge($form['myserve'],[['icon'=>$url.'myserve/chayishi.png','show_type'=>1,'type'=>"tea_specialist",'status'=>0,'url'=>'/teaMaster/teaMasterApply','title'=>'茶艺师申请']]);
               }
               if(!isset($myserve['shareholder_receive'])){
                 $form['myserve']=array_merge($form['myserve'],[['icon'=>$url.'myserve/gudongfenhong.svg','show_type'=>1,'type'=>"shareholder_receive",'status'=>1,'url'=>'/stock/index','title'=>'股东分红']]);
               }
               if(!isset($myserve['meituan_coupon'])){
                 $form['myserve']=array_merge($form['myserve'],[['icon'=>$url.'myserve/meituanyanquan.svg','show_type'=>1,'type'=>"meituan_coupon",'status'=>1,'url'=>'/pages/user/meituan/getCoupon','title'=>'美团验券']]);
               }
               if(!isset($myserve['invite_tea'])){
                 $form['myserve']=array_merge($form['myserve'],[['icon'=>$url.'myserve/mianfeihecha.png','show_type'=>1,'type'=>"invite_tea",'status'=>1,'url'=>'/group/index','title'=>'免费约茶']]);
               }
               foreach($form['myserve'] as &$sv){
                  if(!isset($sv['show_type'])){
                    $sv['show_type']=1;
                  }
               }
            }
            $pluginlist=Cache::get('platform_plugin_list_wxapp');
            if(isset($pluginlist['info']['plugin'])){
                  $plugin_list=explode(',',$pluginlist['info']['plugin']);
                  $inArr=['kefu','common','store','storeJoin','ranking','tea_specialist'];
                  foreach ($form['myserve'] as &$value){
                      if(!in_array($value['type'],$inArr)){
                         if(!in_array($value['type'],$plugin_list)) {
                           $value['status']=0;
                         }
                      }
                  }
            }
            return fetchJson($form);
        }
        $form=Option::set_data($this->acid,'shared','app_user_center_config',json_encode([
            'type'=>input('type'),
            'money'=>input('money'),
            'tea_order'=>json_decode(input('tea_order'),1),
            'is_share'=>input('is_share'),
            'myserve'=>json_decode(input('myserve'),1),
        ]));
        return fetchJson([],'保存成功');
    }
}