<?php
namespace app\shared\logic\platform;
use app\shared\model\TeaSpecialist;
use app\shared\model\TeaSpecialistApply;
use app\shared\model\Bill;
use think\exception\ValidateException;
use app\shared\model\TeaSpecialistOrder;
use app\shared\model\HouseOrder;
use app\shared\model\CouponUser;
use app\shared\model\Coupon;
use app\shared\model\House;
use app\shared\model\User;
use app\shared\model\Area;
use app\BaseController;
class TeaSpecialistForm extends  Base
{
    //获取数据
    public  function index(){
        $keyword=input('keyword');
        $field=input('field');
        $query=TeaSpecialist::where(['acid'=>$this->acid,'is_delete'=>0]);
        if($keyword){
            if($field){
                $fieldArray=['id','nickname','account'];
                $searchField=$field;
                if(!in_array($field,$fieldArray)){
                    $searchField='id|nickname|account';
                }
            }else{
                $searchField='id|nickname|account';
            }
            $query=$query->where($searchField,'like',"%{$keyword}%");
        }
        $count=$query->count();
        $list=$query
        ->page($this->page)
        ->limit($this->limit)
        ->withoutField('password')
        ->order('id DESC')
        ->select()
        ->toArray();
        $rankNameArr=[1=>'初级茶艺师',2=>'中级茶艺师',3=>'高级茶艺师',4=>'特级茶艺师',5=>'专家茶艺师'];
        foreach ($list as $key => &$value) {
            $value['banner_list']=get_file_urls($value['banner']);
            $value['rankName']=isset($rankNameArr[$value['rank']])?$rankNameArr[$value['rank']]:'未定义';
        }
        return fetchJson([
            'list'=>$list,
            'count'=>$count
        ]);
    }
    //编辑用户
    public function edit(){
        $id=input('id');
        $form=TeaSpecialist::where(['id'=>$id])->find();
        try {
            $data=request()->post();
            $rule = [
                'account|账号'   => 'require',
                'nickname|名称'=>'require',
                'avatar_url|头像'=>'require',
                'rank|级别'   => 'require',
                'tag|标签'   => 'require',
                'area_id|城市ID'   => 'require|number',
                'fee|手续费比例'   => 'require',
                'store_fee|商户手续费比例'   => 'require',
                'banner|轮播图'   => 'require',
                'binding|手机号码'   => 'require',
                'score|分数'=>'require',
                'explain|说明'=> 'require',
                'service_price|服务价格'=>'require',
            ];
            $this->validate($data,$rule);
        } catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        if(!$form){
            $form=new TeaSpecialist();
            $form->acid=$this->acid;
            if(TeaSpecialist::where(['acid'=>$this->acid,'account'=>$data['account'],'is_delete'=>0])->count()){
                return fetchJson([],'该账号已存在',1);
            }
        }else{
            if(TeaSpecialist::where(['acid'=>$this->acid,'account'=>$data['account'],'is_delete'=>0])->where('id','<>',$form->id)->count()){
                 return fetchJson([],'该账号已存在',1);
            }
        }
        $form->account=$data['account'];
        if(!empty($data['password'])){
             $form->password=md5($data['password']);
        }
        if($data['fee']>100||$data['fee']<0){
            return fetchJson([],'手续费比例请设置0-100内',1);
        }
        if($data['store_fee']>100||$data['store_fee']<0){
            return fetchJson([],'商户手续费比例请设置0-100内',1);
        }
        if(($data['fee']+$data['store_fee'])>100){
            return fetchJson([],'两个手续费加起来不得大于100%',1);
        }
        $form->score=$data['score'];
        $form->area_id=$data['area_id'];
        $form->fee=$data['fee'];
        $form->store_fee=$data['store_fee'];
        $form->nickname=$data['nickname'];
        $form->avatar_url=$data['avatar_url'];
        $form->banner=$data['banner'];
        $form->explain=$data['explain'];
        $form->service_price=$data['service_price'];
        $form->binding=$data['binding'];
        $form->rank=$data['rank'];
        $form->tag=$data['tag'];
        $form->wx_open_id=input('wx_open_id');

        $form->save();
        return fetchJson([],'保存成功');
    }
    public function delete(){
       $id=input('id');
       TeaSpecialist::where(['acid'=>$this->acid,'id'=>$id])->update(['is_delete'=>1]);
       return fetchJson([],'删除'); 
    }
    public function orderList(){
        $query=TeaSpecialistOrder::alias('ts')
             ->leftJoin([HouseOrder::getTable()=>'ho'],'ts.house_order_id=ho.id')
             ->leftJoin([TeaSpecialist::getTable()=>'t'],'ts.tea_specialist_id=t.id')
             ->leftJoin([House::getTable()=>'h'],'ho.house_id=h.id')
             ->where(['ts.acid'=>$this->acid,'ts.is_delete'=>0,'ts.is_pay'=>1]);
        if($keyword=input('keyword')){
            $query->where('ts.order_no','like',"%{$keyword}%");
        }
        $status=input('status');     
        switch($status){
            case '0':
                $query->where(['ts.status'=>$status]);
                break;
            case '1':
                $query->where(['ts.status'=>$status]);
                break;
            case '2':
                $query->where(['ts.status'=>$status]);
                break;
            case '3':
                $query->where(['ts.status'=>$status]);
                break;
            case '4':
                $query->where(['ts.status'=>$status]);
                break;    
            default:
                break;
        }
        $count=$query->field('ts.*,ho.start_time,ho.end_time,ho.username,ho.tel,h.cover,h.name,t.nickname t_nickname,t.avatar_url t_avatar_url,t.account t_account')->count();     
        $list=$query->page($this->page)->limit($this->limit)->order('ts.id DESC')->select();
        foreach ($list as $key => &$value) {
            $value['start_time']=date('Y-m-d H:i',$value['start_time']);
            $value['end_time']=date('Y-m-d H:i',$value['end_time']);
            $couponUser=CouponUser::alias('a')
            ->leftJoin([Coupon::getTable()=>'b'],'a.coupon_id=b.id')
            ->where(['a.id'=>$value['coupon_user_id'],'a.type'=>Coupon::TYPE_TEASPECIALIST])
            ->field('a.discounts_price,b.name')->find();
            $value['discounts_name']=$couponUser['name'];
            $value['discounts_price']=$couponUser['discounts_price']>0?$couponUser['discounts_price']:0;
        }
        return fetchJson([
            'count'=>$count,
            'list'=>$list
        ]);
    }
    public function applyList(){
        $query=TeaSpecialistApply::alias('a')
        ->leftJoin([User::getTable()=>'b'],'a.user_id=b.id')
        ->leftJoin([Area::getTable()=>'c'],'a.area_id=c.id')
        ->field('a.*,b.nickname,b.avatar_url,b.account,c.name cityName');
        $count=$query->count();
        $list=$query->select();
        return fetchJson([
            'count'=>$count,
            'list'=>$list
        ]);
    }
    public function applyHandle(){
        $form=TeaSpecialistApply::where(['id'=>input('id'),'status'=>0])->find();
        $status=input('status');
        if($form&&$status){
            if($status==1){
                $account=User::where('id',$form->user_id)->value('account');
                $userTea=TeaSpecialist::where(['acid'=>$this->acid,'is_delete'=>0,'account'=>$account])->find();
                if(!$userTea){
                    try {
                        $data=request()->post();
                        $rule = [
                            'password|密码'   => 'require',
                            'nickname|名称'=>'require',
                            'avatar_url|头像'=>'require',
                            'rank|级别'   => 'require',
                            'tag|标签'   => 'require',
                            'area_id|城市ID'   => 'require|number',
                            'fee|手续费比例'   => 'require',
                            'banner|轮播图'   => 'require',
                            'score|分数'=>'require',
                            'explain|说明'=> 'require',
                            'service_price|服务价格'=>'require',
                        ];
                        $this->validate($data,$rule);
                    } catch (ValidateException $e){
                        return fetchJson([],$e->getError(),1);
                    }
                    $userTea=new TeaSpecialist();
                    $userTea->acid=$this->acid;
                    $userTea->account=$account;
                    $userTea->password=md5($data['password']);
                    if($data['fee']>100||$data['fee']<0){
                        return fetchJson([],'手续费比例请设置0-100内',1);
                    }
                    $userTea->score=$data['score'];
                    $userTea->area_id=$data['area_id'];
                    $userTea->fee=$data['fee'];
                    $userTea->nickname=$data['nickname'];
                    $userTea->avatar_url=$data['avatar_url'];
                    $userTea->banner=$data['banner'];
                    $userTea->explain=$data['explain'];
                    $userTea->service_price=$data['service_price'];
                    $userTea->binding=$account;
                    $userTea->rank=$data['rank'];
                    $userTea->tag=$data['tag'];
                    $userTea->wx_open_id=input('wx_open_id');
                    $userTea->save();
                    $form->status=1;
                    $form->save();
                    return fetchJson([],'同意成为茶艺师',0);
                }else{
                    $form->status=2;
                    $form->save();
                    return fetchJson([],'该茶艺师已存在',1);
                }
            }else{
                $form->status=2;
                $form->save();
                return fetchJson([],'拒绝成功',1);
            }
        }else{
            return fetchJson([],'暂无处理'.$status,1);
        }
    }
}