<?php
namespace app\shared\logic\platform;
use app\shared\model\TeaCircle;
use app\shared\model\TeaCircleComment;
use app\shared\model\TeaCircleType;
use app\shared\model\User;
use app\shared\model\Collection;
use think\exception\ValidateException;
use app\BaseController;
//茶圈管理
class TeaCircleForm extends  Base
{
	//列表
    public function index(){
    		$query=TeaCircle::alias('t_c')
    		->leftJoin([User::getTable()=>'u'],'t_c.user_id=u.id')
    		->where(['t_c.acid'=>$this->acid,'t_c.is_delete'=>0]);
    		$status=input('status');
    		if($status!=-1){
    			$query->where('t_c.status',$status);
    		}
    		$count=$query->field('t_c.*,u.avatar_url,u.nickname')->count();
    		$list=$query->limit($this->limit)->page($this->page)->select();
    		foreach ($list as $key => &$value) {
    			$value['cover']=get_file_url($value['cover']);
    		}
  	    return fetchJson([
  	    	'count'=>$count,
  	    	'list'=>$list
  	    ]);
	}
	//编辑
	public function edit(){
		try {
          $data=request()->post();
          $rule = [
               'id|地址ID' => 'require',
               'user_id|用户ID' => 'require',
               'title|标题'=>'require',
               'type_id|类型ID'=>'require',
               'status|状态'=>'require|in:0,1',
               'content|内容'=>'require',
               'images|图片'=>'require',
           ];
          $this->validate($data,$rule);
       }catch (ValidateException $e){
          return fetchJson([],$e->getError(),1);
       }
       $form=TeaCircle::where(['acid'=>$this->acid,'id'=>$data['id']])->find();
       if(!$form){
       	  $form=new TeaCircle();
       	  $form->acid=$this->acid;
       }
       $form->save([
       	 'title'=>$data['title'],
       	 'user_id'=>$data['user_id'],
       	 'status'=>$data['status'],
       	 'content'=>$data['content'],
       	 'images'=>$data['images'],
       	 'type_id'=>$data['type_id'],
       	 'tags'=>input('tags'),
       ]);
       return fetchJson([],'保存成功');
	}
    //删除
    public function delete(){
         TeaCircle::where(['acid'=>$this->acid,'id'=>input('id')])->update(['is_delete'=>1]);
         return fetchJson([],'删除成功');
    }
    //类型列表
    public function typeList(){
        $query=TeaCircleType::where(['acid'=>$this->acid,'is_delete'=>0]);
        $count=$query->count();
        $list=$query->order('sort DESC')->limit($this->limit)->page($this->page)->select();
		return fetchJson([
	    	'count'=>$count,
	    	'list'=>$list
	    ]);
    }
    //类型编辑
    public function typeEdit(){
        try {
          $data=request()->post();
          $rule = [
               'id|地址ID' => 'require',
               'title|标题'=>'require',
               'sort|排序'=>'require',
               'status|状态'=>'require|in:0,1',
           ];
          $this->validate($data,$rule);
       }catch (ValidateException $e){
          return fetchJson([],$e->getError(),1);
       }
       $form=TeaCircleType::where(['acid'=>$this->acid,'id'=>$data['id']])->find();
       if(!$form){
       	  $form=new TeaCircleType();
       	  $form->acid=$this->acid;
       }
       $form->save([
       	 'title'=>$data['title'],
       	 'status'=>$data['status'],
       	 'sort'=>$data['sort'],
       ]);
       return fetchJson([],'保存成功');
    }
    //类型删除
    public function typeDelete(){
        TeaCircleType::where(['acid'=>$this->acid,'id'=>input('id')])->update(['is_delete'=>1]);
        return fetchJson([],'删除成功');
    }
    //评论列表
    public function commentList(){
        $query=TeaCircleComment::alias('t_c')
          ->leftJoin([User::getTable()=>'u'],'t_c.user_id=u.id')
          ->where(['t_c.acid'=>$this->acid,'t_c.is_delete'=>0,'t_c.tea_circle_id'=>input('tea_circle_id')]);
          $status=input('status');
          $count=$query->field('t_c.*,u.avatar_url,u.nickname')->count();
          $list=$query->limit($this->limit)->page($this->page)->order('t_c.id DESC')->select();
          return fetchJson([
            'count'=>$count,
            'list'=>$list
          ]);
    }
     //类型删除
    public function commentDel(){
        TeaCircleComment::where(['acid'=>$this->acid,'id'=>input('id')])->update(['is_delete'=>1]);
        return fetchJson([],'删除成功');
    }

}