<?php
namespace app\shared\logic\platform;
use app\shared\model\Partner;
use app\shared\model\PartnerUser;
use app\shared\model\PartnerWithdraw;
use app\shared\model\PartnerUserBill;
use app\shared\model\User;
use think\exception\ValidateException;
use app\BaseController;
class PartnerForm extends  Base
{
    //获取数据
    public  function index(){
        $query=Partner::where(['acid'=>$this->acid,'is_delete'=>0]);
        $count=$query->count();
        $list=$query
        ->page($this->page)
        ->limit($this->limit)
        ->order('price ASC')
        ->select()
        ->toArray();
        foreach ($list as $key => &$value) {
           $value['cover_url']=get_file_url($value['cover']);
        }
        return fetchJson([
            'list'=>$list,
            'count'=>$count
        ]);
    }
    //编辑
    public function edit(){
        $id=input('id');
        $form=Partner::where(['id'=>$id])->find();
        try {
            $data=request()->post();
            $rule = [
                'title|名称'=>'require',
                'cover|封面'=>'require',
                'type|类型'=>'require|in:1,2',
                'price|成为合伙人条件'=>'require|egt:0|float',
                'tea_price|等级茶叶价格'=>'require|egt:0|float',
                'money|赠送金额'=>'require|egt:0|float',
                'everyday_hour|每天可使用小时'=>'require|number',
                'sum_lngot|总元宝'=>'require|number',
                'everyday_lngot|每天赠送元宝'=>'require|number',
                'first_lngot|首次元宝'=>'require|number',
                'level|等级'=>'require|number',
                'month|月数'=>'require',
                'status|状态'=>'require|in:0,1',
                'dec|详情'=>'require'
            ];
            $this->validate($data,$rule);
        } catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        if(!$form){
            $form=new Partner();
            $form->acid=$this->acid;
        }
        $form->title=$data['title'];
        $form->cover=$data['cover'];
        $form->price=$data['price'];
        $form->level=$data['level'];
        $form->type=$data['type'];
        $form->tea_price=$data['tea_price'];
        $form->money=$data['money'];
        $form->everyday_hour=$data['everyday_hour'];
        $form->sum_lngot=$data['sum_lngot'];
        $form->everyday_lngot=$data['everyday_lngot'];
        $form->first_lngot=$data['first_lngot'];
        $form->status=$data['status'];
        $form->month=$data['month'];
        $form->dec=$data['dec'];
        $form->one_level=input('one_level');
        $form->two_level=input('two_level');
        $form->save();
        return fetchJson([],'保存成功');
    }
    public function userList(){
        $query=PartnerUser::alias('ptu')
        ->leftJoin([Partner::getTable()=>'pt'],'ptu.partner_id=pt.id')
        ->leftJoin([User::getTable()=>'u'],'ptu.user_id=u.id')
        ->where(['ptu.acid'=>$this->acid,'ptu.is_delete'=>0])->field('ptu.*,pt.title,pt.cover,u.nickname,u.avatar_url');
        $count=$query->count();
        $list=$query
        ->page($this->page)
        ->limit($this->limit)
        ->order('ptu.id DESC')
        ->select()
        ->toArray();
        foreach ($list as $key => &$value) {
           $value['cover_url']=get_file_url($value['cover']);
           $value['start_time']=date('Y-m-d H:i:s',$value['start_time']);
           $value['end_time']=$value['end_time']==-1?"永久":date('Y-m-d H:i:s',$value['end_time']);
        }
        return fetchJson([
            'list'=>$list,
            'count'=>$count
        ]);
    }
    //删除
    public function delete(){
         $id=input('id');
         Partner::where(['acid'=>$this->acid,'id'=>$id])->update(['is_delete'=>1]);
         return fetchJson([],'删除成功');
    }
    //提现列表
    public function withdrawList(){
        $query=PartnerWithdraw::where(['acid'=>$this->acid,'is_delete'=>0]);
        if($asset_type=input('asset_type')){
            $query->where('asset_type',$asset_type);
        }
        $count=$query->count();
        $list=$query->page($this->page)->limit($this->limit)->select();
        return fetchJson([
            'count'=>$count,
            'list'=>$list
        ]);
    }
    //提现处理
    public function withdrawHandle(){
        try {
            $data=request()->post();
            $rule = [
                'id|ID'=>'require|number',
                'status|状态'=>'require|in:1,2',
            ];
            $this->validate($data,$rule);
        } catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        $form=PartnerWithdraw::where(['id'=>$data['id'],'status'=>0])->find();
        if($form){
            if($data['status']==1){
                //同意
                $partnerUser=PartnerUser::where(['acid'=>$this->acid,'id'=>$form->user_id])->find();
                if($form->asset_type==1&&$partnerUser->price<$form->money){
                     return fetchJson([],'提现佣金不足',1);
                }
                if($form->asset_type==2&&$partnerUser->sum_lngot<$form->money){
                     return fetchJson([],'提现茶元宝不足',1);
                }
                if($form->asset_type==1){
                    $partnerUser->price-=$form->money;
                }else{
                    $partnerUser->sum_lngot-=$form->money;
                }
                $partnerUser->save();
                $form->status=1;
                $form->save();
                (new PartnerUserBill())->save([
                    'acid'=>$this->acid,
                    'user_id'=>$partnerUser->id,
                    'order_id'=>$form->id,
                    'title'=>$form->asset_type==1?"合伙人佣金提现":"合伙人茶元宝提现",
                    'lngot'=>$form->asset_type==2?$form->money:0,
                    'price'=>$form->asset_type==1?$form->money:0,
                    'status'=>-1,
                    'type'=>3
                ]);
                return fetchJson([],'处理成功');
            }else{
                //拒绝
                $form->status=2;
                $form->remark=input('remark');
                $form->save();
                return fetchJson([],'拒绝提现');
            }
        }else{
            return fetchJson([],'暂无处理',1);
        }
    }
}