<?php
namespace app\shared\logic\platform;
use app\shared\model\App;
use app\shared\model\Option;
use app\shared\model\User;
use app\shared\model\UserUv;
use app\shared\model\Goods;
use app\shared\model\House;
use app\shared\model\Bill;
use app\shared\model\Store;
use app\shared\model\HouseOrder;
use app\shared\model\HouseOrderContinue;
use app\shared\model\SystemLog;
use think\exception\ValidateException;
use app\BaseController;
use think\facade\Cache;
use think\facade\Db;
class IndexForm extends  Base
{
    //数据统计
    public  function statistics(){
        $start_date=input('start_date');
        $end_date=input('end_date');
        $store_id=input('store_id');
        $days=7;
        if($end_date){
           $time=strtotime($end_date);
           $days=strtotime($end_date)-strtotime($start_date);
           $days=$days/86400;
           if($days<7){
            $days=7;
           }
           $end_date=date('Y-m-d',strtotime($end_date)+86400);
        }else{
          $time=time();
        }
        $house_price=0;
        $user_num=User::where(['acid'=>$this->acid])->count();
        $store_num=Store::where(['acid'=>$this->acid,'is_delete'=>0])->count();
        $getServenDay=getServenDay(date('Y-m-d',$time+86400),0,$days);
        $getServenDay = array_column($getServenDay,'time');
        $house_order_arr=[];
        foreach ($getServenDay as $day) {
          if($store_id){
              $house_order_arr[]=HouseOrder::where(['acid'=>$this->acid,'is_pay'=>1,'store_id'=>$store_id])->where('status',3)->whereDay('update_time',$day)->count();
          }else{
              $house_order_arr[]=HouseOrder::where(['acid'=>$this->acid,'is_pay'=>1])->where('status',3)->whereDay('create_time',$day)->count();
          }
        }
        if($start_date&&$end_date){
          if($store_id){
             $house_order_num=HouseOrder::where(['acid'=>$this->acid,'store_id'=>$store_id])
              ->whereBetweenTime('update_time',$start_date,$end_date)->where('status',3)->count();
              $sum_earnings=Bill::where(['acid'=>$this->acid,'account_type'=>Bill::ACCOUNT_TYPE_STORE,'is_delete'=>0,'status'=>1,'form_id'=>$store_id])
              ->whereBetweenTime('create_time',$start_date,$end_date)->sum('price');

              $sum_balance=Bill::where(['acid'=>$this->acid,'account_type'=>Bill::ACCOUNT_TYPE_STORE,'is_delete'=>0,'status'=>1,'form_id'=>$store_id,'price_type'=>2])
              ->whereBetweenTime('create_time',$start_date,$end_date)->sum('price');

              $sum_wechatPay=Bill::where(['acid'=>$this->acid,'account_type'=>Bill::ACCOUNT_TYPE_STORE,'is_delete'=>0,'status'=>1,'form_id'=>$store_id,'price_type'=>1])
              ->whereBetweenTime('create_time',$start_date,$end_date)->sum('price');
          }else{
             $house_order_num=HouseOrder::where(['acid'=>$this->acid])
              ->whereBetweenTime('update_time',$start_date,$end_date)->where('status',3)->count();
              $sum_earnings=Bill::where(['acid'=>$this->acid,'account_type'=>Bill::ACCOUNT_TYPE_STORE,'is_delete'=>0,'status'=>1])
              ->whereBetweenTime('create_time',$start_date,$end_date)->sum('price');

              $sum_balance=Bill::where(['acid'=>$this->acid,'account_type'=>Bill::ACCOUNT_TYPE_STORE,'is_delete'=>0,'status'=>1,'price_type'=>2])
              ->whereBetweenTime('create_time',$start_date,$end_date)->sum('price');

              $sum_wechatPay=Bill::where(['acid'=>$this->acid,'account_type'=>Bill::ACCOUNT_TYPE_STORE,'is_delete'=>0,'status'=>1,'price_type'=>1])
              ->whereBetweenTime('create_time',$start_date,$end_date)->sum('price');
          }
        }else{
          if($store_id){
             $house_order_num=HouseOrder::where(['acid'=>$this->acid,'store_id'=>$store_id])->where('status',3)->count();
             $sum_earnings=Bill::where(['acid'=>$this->acid,'account_type'=>Bill::ACCOUNT_TYPE_STORE,'is_delete'=>0,'status'=>1,'form_id'=>$store_id])->sum('price');
             $sum_balance=Bill::where(['acid'=>$this->acid,'account_type'=>Bill::ACCOUNT_TYPE_STORE,'is_delete'=>0,'status'=>1,'form_id'=>$store_id,'price_type'=>2])->sum('price');
             $sum_wechatPay=Bill::where(['acid'=>$this->acid,'account_type'=>Bill::ACCOUNT_TYPE_STORE,'is_delete'=>0,'status'=>1,'form_id'=>$store_id,'price_type'=>1])->sum('price');
          }else{
             $house_order_num=HouseOrder::where(['acid'=>$this->acid])->where('status',3)->count();
             $sum_earnings=Bill::where(['acid'=>$this->acid,'account_type'=>Bill::ACCOUNT_TYPE_STORE,'is_delete'=>0,'status'=>1])->sum('price');
             $sum_balance=Bill::where(['acid'=>$this->acid,'account_type'=>Bill::ACCOUNT_TYPE_STORE,'is_delete'=>0,'status'=>1,'price_type'=>2])->sum('price');
             $sum_wechatPay=Bill::where(['acid'=>$this->acid,'account_type'=>Bill::ACCOUNT_TYPE_STORE,'is_delete'=>0,'status'=>1,'price_type'=>1])->sum('price');
          }
          
        }
        if($store_id){
           $today_earnings=Bill::where(['acid'=>$this->acid,'account_type'=>Bill::ACCOUNT_TYPE_STORE,'is_delete'=>0,'status'=>1,'form_id'=>$store_id])->whereDay('create_time',date('Y-m-d'))->sum('price');
        }else{
           $today_earnings=Bill::where(['acid'=>$this->acid,'account_type'=>Bill::ACCOUNT_TYPE_STORE,'is_delete'=>0,'status'=>1])->whereDay('create_time',date('Y-m-d'))->sum('price');
        }

        $house_order_sumprice=$sum_earnings;
        return fetchJson([
            'store_num'=>$store_num,
            'sum_earnings'=>$sum_earnings,
            'user_num'=>$user_num,
            'house_order_num'=>$house_order_num,
            'house_order_sumprice'=>$house_order_sumprice,
            'today_earnings'=>$today_earnings,
            'consume_ranking'=>self::consumeRanking(),
            'sum_balance'=>$sum_balance,
            'sum_wechatPay'=>$sum_wechatPay,
            'broken_line'=>[
                'date'=>$getServenDay,
                'legend'=>['茶室订单'],
                'series'=>[
                    [
                        'name'=>'茶室订单',
                        'type'=>'line',
                        'stack'=>'总量',
                        'data'=>$house_order_arr
                    ],
                ]
            ]
        ]);
    }
     //消费排行
    public function consumeRanking(){
        $billTab=Bill::getTable();
        $userTab=User::getTable();
        $sql="
          SELECT a.* FROM (select @rownum := @rownum + 1 AS ranking,t.* FROM
          (SELECT @rowNum := 0) r,
          (SELECT h.id,h.nickname,h.avatar_url,h.acid,r.type,h.create_time,h.account,IFNULL(sum(r.price),0) AS consumption_price
          FROM `{$billTab}` AS r RIGHT JOIN `{$userTab}` AS h
          ON r.form_id = h.id
          AND r.status = -1 
          AND r.acid = {$this->acid} 
          AND r.type  IN(1,2,4,6,7,8)
          GROUP BY h.id
          ORDER BY consumption_price DESC
          ) t) a 
        ";
        $sq2=$sql."WHERE consumption_price>0 ORDER BY consumption_price DESC LIMIT 15";
        $list= Db::query($sq2);
        foreach ($list as $key => &$value) {
          $value['create_time']=date('Y-m-d H:i:s',$value['create_time']);
        }
        return $list;
    }
    //插件列表
    public function plugList(){
        $list=Cache::get('platform_plugin_list');
        return fetchJson($list);
    }
    //系统日志
    public function systemLog(){
        $list=SystemLog::limit($this->limit)->page($this->page)->order('id DESC')->select();
        $platform=Cache::get('platform_plugin_list');
        $end_time=isset($platform['info']['end_time'])?$platform['info']['end_time']:0;
        $start_time=isset($platform['info']['start_time'])?$platform['info']['start_time']:0;
        $new_time=strtotime(date('Y-m-d'));
        return fetchJson([
            'info'=>[
                'start_time'=>date('Y-m-d',$start_time),
                'end_time'=>date('Y-m-d',$end_time),
                'day'=>($end_time-$new_time)>0?($end_time-$new_time)/86400:0,
                'version'=>SystemLog::order('id DESC')->value('version')
            ],
            'list'=>$list,
            'count'=>SystemLog::count(),
        ]);
    }
    public function uvList(){
        $query=UserUv::alias('uv')
                    ->leftJoin([User::getTable()=>'u'],'uv.user_id=u.id')
                    ->leftJoin([Store::getTable()=>'s'],'uv.store_id=s.id')
                    ->field('u.nickname,u.avatar_url,uv.create_time,uv.type,uv.form_id,s.name,s.logo');
        if($store_id=input('store_id')){
           $query->where('uv.store_id',$store_id);
        }             
        $count=$query->count();
        $list=$query->page($this->page)->limit($this->limit)->order('uv.id DESC')->select();
        foreach ($list as &$value){
          if($value['type']==1){
             $store=Store::where('id',$value['form_id'])->field('name,logo')->find();
             $value['title']=$store['name'];
             $value['cover_url']=get_file_url($store['logo']);
          }else if($value['type']==2){
             $house=House::where('id',$value['form_id'])->field('name,cover')->find();
             $value['title']='浏览茶室：'.$house['name'];
             $value['cover_url']=$house['cover'];
          }else if($value['type']==3){
             $goods=House::where('id',$value['form_id'])->field('name,cover')->find();
             $value['title']='浏览商品：'.$goods['name'];
             $value['cover_url']=get_file_url($goods['cover']);
          }else{
             $value['title']='未知';
             $value['cover_url']='未知';
          }
          $value['logo']=get_file_url($value['logo']);
        }
        return fetchJson([
          'count'=>$count,
          'list'=>$list
        ]);
    }
   
}