<?php
namespace app\shared\logic\platform;
use app\shared\model\GoodsOrder;
use app\shared\model\Goods;
use app\shared\model\User;
use app\shared\model\CouponUser;
use app\shared\model\Coupon;
use app\shared\model\StoreCouponUser;
use app\shared\model\StoreCoupon;
use app\shared\model\WeixinUser;
use think\exception\ValidateException;
use app\BaseController;
use think\facade\Db;
class GoodsOrderForm extends  Base
{
     //获取数据
    public  function index(){
        $keyword=input('keyword');
        $status=input('status');
        $query=Db::view(GoodsOrder::getTable().' o','*')
                ->view(User::getTable().' u','nickname,avatar_url','o.user_id=u.id')
                ->where([
                	'o.acid'=>$this->acid,
                	'o.is_delete'=>0,
                	'o.store_id'=>$this->store_id
                ]);
        if($status!=-1){
           $query=$query->where(['o.status'=>$status]);
        }
        if($keyword){
            $query=$query->where('o.order_no|o.id|o.snapshot','like',"%{$keyword}%");
        }
        $list=$query->page($this->page)
                ->limit($this->limit)
                ->order('o.id DESC')
                ->select()
                ->toArray();
        $status_arr=[-1=>'取消',0=>'未支付',1=>'待发货',2=>'已发货',3=>'已完成'];       
        foreach ($list as &$value) {
            $snapshot=json_decode($value['snapshot'],1);
            $value['snapshot']=$snapshot;
            $value['status_title']=$status_arr[$value['status']];
            $value['create_time']=date('Y-m-d H:i:s',$value['create_time']);
            $value['update_time']=date('Y-m-d H:i:s',$value['update_time']);
            $couponUser=CouponUser::alias('a')
            ->leftJoin([Coupon::getTable()=>'b'],'a.coupon_id=b.id')
            ->where(['a.id'=>$value['coupon_user_id'],'a.type'=>Coupon::TYPE_GOODS])
            ->field('a.discounts_price,b.name')->find();
            $value['discounts_name']=$couponUser['name'];
            $value['discounts_price']=$couponUser['discounts_price']>0?$couponUser['discounts_price']:0;
            //商户优惠券
            $storeCouponUser=StoreCouponUser::alias('a')
            ->leftJoin([StoreCoupon::getTable()=>'b'],'a.coupon_id=b.id')
            ->where(['a.id'=>$value['store_coupon_user_id'],'a.type'=>StoreCoupon::TYPE_GOODS])
            ->field('a.discounts_price,b.name')->find();
            $value['store_discounts_name']=$storeCouponUser['name'];
            $value['store_discounts_price']=$storeCouponUser['discounts_price']>0?$storeCouponUser['discounts_price']:0;


        }
        $queryCount=Db::view(GoodsOrder::getTable().' o','*')
                ->view(User::getTable().' u','nickname,avatar_url','o.user_id=u.id')
                ->where([
                	'o.acid'=>$this->acid,
                	'o.is_delete'=>0,
                	'o.store_id'=>$this->store_id
                ]);
        if($status!=-1){
            $queryCount=$queryCount->where(['o.status'=>$status]);
        }
        if($keyword){
            $queryCount=$queryCount->where('o.order_no|o.id|o.snapshot','like',"%{$keyword}%");
        }
        $count=$queryCount->count();
        return fetchJson([
            'list'=>$list,
            'count'=>$count
        ]);
    }
    //订单编辑
    public function order_edit(){
    	try {
            $data=request()->post();
            $rule = [
                 'order_id|订单号'=>'require|number',
                 'status|状态'=>'require|number|in:0,1,2,3',

             ];
            $this->validate($data,$rule);
         }catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
         }
    	if(GoodsOrder::where(['id'=>$data['order_id'],'store_id'=>$this->store_id])->update(['status'=>$data['status']])){
               
    		return fetchJson([],'修改成功');
    	}else{
    		return fetchJson([],'暂无订单',1);
    	}
    }
}