<?php
namespace app\shared\logic\platform;
use app\shared\model\Conversion;
use app\shared\model\Card;
use app\shared\model\Coupon;
use app\shared\model\User;
use think\exception\ValidateException;
use app\BaseController;
use app\shared\model\Option;
use think\facade\Db;
class ConversionForm extends  Base
{

    //获取数据
    public  function index(){
        $status=input('status');
        $query=Conversion::where(['acid'=>$this->acid,'is_delete'=>0]);
        if($status!=-1){
            $query->where('status',$status);
        }
        if($keyword=input('keyword')){
            $query->where('code','like',"%{$keyword}%");
        }
        $count=$query->count();
        $list=$query->page($this->page)
        ->limit($this->limit)
        ->select()
        ->toArray();
        foreach ($list as $key => &$value) {
            if($value['user_id']){
                $user=User::where(['id'=>$value['user_id']])->field('nickname,account,avatar_url')->find();
                $value['account']=$user['account'];
                $value['avatar_url']=$user['avatar_url'];
                $value['nickname']=$user['nickname'];
            }else{
                $value['account']='';
                $value['avatar_url']='';
                $value['nickname']='';
            }
            $value['qrcode_url']='https://api.pwmqr.com/qrcode/create/?url='.$value['code'];
            $value['card_list']=Card::where('id','in',$value['card_ids'])->column('id,title,cover');
            $value['coupon_list']=Coupon::where('id','in',$value['coupon_ids'])->column('id,name,type');
            if($value['status']==1){
                $value['finish_time']=!empty($value['finish_time'])?date('Y-m-d H:i:s',$value['finish_time']):$value['update_time'];
            }else{
                $value['finish_time']='';
            }
        }
        return fetchJson([
            'list'=>$list,
            'count'=>$count
        ]);
    }
    //编辑
    public function create(){
        try {
            $data=request()->post();
            $rule = [
                'card_ids|会员卡ID'=>'require',
                'coupon_ids|兑换优惠券ID'=>'require',
                'money|兑换金额'=>'require',
                'num|数量'=>'require|number'
            ];
            $this->validate($data,$rule);
        } catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        if($data['num']>50){
            return fetchJson([],'一次生成最多只支持50条',1);
        }
        $conversion_arr=[];
        $time=time();
        for ($i=0; $i <$data['num'] ; $i++){ 
            $conversion_arr[]=[
                'acid'=>$this->acid,
                'card_ids'=>$data['card_ids'],
                'coupon_ids'=>$data['coupon_ids'],
                'money'=>$data['money'],
                'code'=>Conversion::createCode(),
                'create_time'=>$time,
                'update_time'=>$time,
            ];
        }
        Db::name(Conversion::TABLE_NAME)
        ->limit(100)
        ->insertAll($conversion_arr);
        return fetchJson([],'创建成功');
    }
    //删除
    public function delete(){
         $ids=input('id');
         $ids=explode(',',$ids);
         Conversion::where(['acid'=>$this->acid,'status'=>0])->where('id','in',$ids)->update(['is_delete'=>1]);
         return fetchJson([],'删除成功');
    }
    public function setting(){
       if(input('is_find')){
            $info=Option::get_data($this->acid,'shared','app_plugin_conversion_dec');
            return fetchJson([
                'dec'=>$info
            ],'设置成功');
       }
       Option::set_data($this->acid,'shared','app_plugin_conversion_dec',input('dec'));
       return fetchJson([],'设置成功');
    }
}
