<?php
namespace app\shared\logic\platform;
use app\shared\model\Category;
use think\exception\ValidateException;
use app\BaseController;
class CategoryForm extends  Base
{
    //获取数据
    public  function index(){
        $list=Category::where(['acid'=>$this->acid,'is_delete'=>0])
        ->page($this->page)
        ->limit($this->limit)
        ->order('sort DESC')
        ->select()
        ->toArray();
        foreach ($list as $key => &$value) {
           $value['cover_url']=get_file_url($value['cover']);
        }
        $count=Category::where(['acid'=>$this->acid,'is_delete'=>0])->count();
        return fetchJson([
            'list'=>$list,
            'count'=>$count
        ]);
    }
    //编辑
    public function edit(){
        $id=input('id');
        $form=Category::where(['id'=>$id])->find();
        try {
            $data=request()->post();
            $rule = [
                'name|名称'=>'require',
                'cover|图片'=>'require',
                'sort|排序'=>'require|number',
                'status|状态'=>'require|in:0,1'
            ];
            $this->validate($data,$rule);
        } catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        if(!$form){
            $form=new Category();
            $form->acid=$this->acid;
        }
        $form->name=$data['name'];
        $form->cover=$data['cover'];
        $form->status=$data['status'];
        $form->sort=$data['sort'];
        $form->save();
        return fetchJson([],'保存成功');
    }
    //删除
    public function delete(){
         $id=input('id');
         Category::where(['acid'=>$this->acid,'id'=>$id])->update(['is_delete'=>1]);
         return fetchJson([],'删除成功');
    }
}