<?php
namespace app\shared\logic\platform;
use app\shared\model\Card;
use app\shared\model\User;
use app\shared\model\CardUser;
use think\exception\ValidateException;
use app\BaseController;
class CardForm extends  Base
{
    //获取数据
    public  function index(){
        $list=Card::where(['acid'=>$this->acid,'is_delete'=>0])
        ->page($this->page)
        ->limit($this->limit)
        ->order('level ASC')
        ->select()
        ->toArray();
        foreach ($list as $key => &$value) {
           $value['cover_url']=get_file_url($value['cover']);
        }
        $count=Card::where(['acid'=>$this->acid])->count();
        return fetchJson([
            'list'=>$list,
            'count'=>$count
        ]);
    }
    //编辑
    public function edit(){
        $id=input('id');
        $form=Card::where(['id'=>$id])->find();
        try {
            $data=request()->post();
            $rule = [
                'title|名称'=>'require',
                'cover|封面'=>'require',
                'price|会员卡价格'=>'require|egt:0|float',
                'level|等级'=>'require',
                'discount|折扣'=>'require|egt:0|float',
                'house_price|房价'=>'require|egt:0|float',
                'hour|小时'=>'require|number',
                'month|月份'=>'require|number',
                'type|类型'=>'require|number|in:1,2',
            ];
            $this->validate($data,$rule);
        } catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        if(!$form){
            $form=new Card();
            $form->acid=$this->acid;
        }
        $form->title=$data['title'];
        $form->cover=$data['cover'];
        $form->price=$data['price'];
        $form->level=$data['level'];
        $form->discount=$data['discount'];
        $form->house_price=$data['house_price'];
        $form->hour=$data['hour'];
        $form->month=$data['month'];
        $form->equity=$data['equity'];
        $form->help=$data['help'];
        $form->type=$data['type'];
        $form->house_ids=input('house_ids')?input('house_ids'):-1;
        $form->is_balance=input('is_balance')==0?0:1;
        $form->save();
        return fetchJson([],'保存成功');
    }
    //删除
    public function delete(){
         $id=input('id');
         Card::where(['acid'=>$this->acid,'id'=>$id])->update(['is_delete'=>1]);
         return fetchJson([],'删除成功');
    }
    //用户会员
    public function userCard(){
        $query=CardUser::alias('c_u')
        ->leftJoin([User::getTable()=>'u'],'c_u.user_id=u.id')
        ->leftJoin([Card::getTable()=>'c'],'c_u.card_id=c.id')->where(['c_u.acid'=>$this->acid,'c.is_delete'=>0]);
        if($card_id=input('card_id')){
            $query->where('c_u.card_id',$card_id);
        }
        if($keyword=input('keyword')){
            $query->where('c.title|u.nickname','like',"%{$keyword}%");
        }
        $query->field('c_u.*,c.title,c.level,c.discount,u.nickname,u.avatar_url')->order('c_u.id DESC');
        $count=$query->count();
        $list=$query->page($this->page)->limit($this->limit)->select();
        foreach($list as $value){
            $value['start_time']=date('Y-m-d',$value['start_time']);
            $value['end_time']=date('Y-m-d',$value['end_time']);
        }
        return fetchJson([
            'count'=>$count,
            'list'=>$list
        ]);
    }
}