<?php
namespace app\shared\logic\platform;
use app\shared\model\Banner;
use think\exception\ValidateException;
use app\BaseController;
class BannerForm extends  Base
{
    //获取数据
    public  function index(){
        $type=input('type');
        $list=Banner::where(['acid'=>$this->acid,'is_delete'=>0,'type'=>$type])
        ->page($this->page)
        ->limit($this->limit)
        ->order('sort DESC')
        ->select()
        ->toArray();
        foreach ($list as $key => &$value) {
           $value['cover_url']=get_file_url($value['cover']);
        }
        $count=Banner::where(['acid'=>$this->acid,'is_delete'=>0,'type'=>$type])->count();
        return fetchJson([
            'list'=>$list,
            'count'=>$count
        ]);
    }
    //编辑
    public function edit(){
        $id=input('id');
        $form=Banner::where(['id'=>$id])->find();
        try {
            $data=request()->post();
            $rule = [
                'cover|图片'=>'require',
                'type|类型'=>'require|number',
                'sort|排序'=>'require|number',
                'status|状态'=>'require|in:0,1'
            ];
            $this->validate($data,$rule);
        } catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        if(!$form){
            $form=new Banner();
            $form->acid=$this->acid;
        }
        $form->type=$data['type'];
        $form->cover=$data['cover'];
        $form->status=$data['status'];
        $form->sort=$data['sort'];
        $form->url=input('url');
        $form->save();
        return fetchJson([],'保存成功');
    }
    //删除
    public function delete(){
         $id=input('id');
         Banner::where(['acid'=>$this->acid,'id'=>$id])->update(['is_delete'=>1]);
         return fetchJson([],'删除成功');
    }
}