<?php
namespace app\shared\logic\platform;
use app\shared\model\Area;
use think\exception\ValidateException;
use app\BaseController;
class AreaForm extends  Base
{
    //获取数据
    public  function index(){
        $query=Area::where(['acid'=>$this->acid,'is_delete'=>0]);
        $count=$query->count();
        $list=$query
        ->page($this->page)
        ->limit($this->limit)
        ->order('id DESC')
        ->select()
        ->toArray();
        foreach ($list as $key => &$value) {
           $value['cover_url']=get_file_url($value['cover']);
        }
        return fetchJson([
            'list'=>$list,
            'count'=>$count
        ]);
    }
    //编辑
    public function edit(){
        $id=input('id');
        $form=Area::where(['id'=>$id])->find();
        try {
            $data=request()->post();
            $rule = [
                'name|名称'=>'require',
                'letter|字母'=>'require',
                'cover|图片'=>'require',
                'status|状态'=>'require|in:0,1',
                'address_location|经纬度'=>'require'
            ];
            $this->validate($data,$rule);
        } catch (ValidateException $e){
            return fetchJson([],$e->getError(),1);
        }
        if(!$form){
            $form=new Area();
            $form->acid=$this->acid;
        }
        $form->name=$data['name'];
        $form->letter=$data['letter'];
        $form->cover=$data['cover'];
        $form->status=$data['status'];
        $form->address_location=$data['address_location'];
        $form->save();
        return fetchJson([],'保存成功');
    }
    //删除
    public function delete(){
         $id=input('id');
         Area::where(['acid'=>$this->acid,'id'=>$id])->update(['is_delete'=>1]);
         return fetchJson([],'删除成功');
    }
}