<?php
namespace app\shared\controller;
use app\shared\logic\pay\CardOrderForm;
use app\shared\logic\pay\HouseOrderForm;
use app\shared\logic\pay\HouseOrderContinueForm;
use app\shared\logic\pay\RechargeOrderForm;
use app\shared\logic\pay\StoreRechargeOrderForm;
use app\shared\logic\pay\GoodsOrderForm;
use app\shared\logic\pay\TeaSpecialistOrderForm;

//订单回调
class Index
{

    public function index(){
        $xml = file_get_contents('php://input');
        if($xml){
            trace('支付日志'.date('Y-m-d H:i:s',time()).$xml);
            $xml_array=fromXml($xml);
            $order_no=$xml_array['out_trade_no'];
        }else{
            $order_no="H202202131128016342";
            $xml_array=[];
        }
        switch (str_replace_match($order_no)) { 
            case 'C':
                //茶室订单
                $form=new CardOrderForm();
                $form->saveOrder($order_no,$xml_array);
                break;
            case 'H':
                //茶室订单
                $form=new HouseOrderForm();
                $form->saveOrder($order_no,$xml_array);
                break;    
            case 'G':
                //商品订单
                $form=new GoodsOrderForm();
                $form->saveOrder($order_no,$xml_array);
                break;    
            case 'XD':
                //茶室订单续单
                $form=new HouseOrderContinueForm();
                $form->saveOrder($order_no,$xml_array);
                break;    
            case 'Re':
                //充值订单
                $form=new RechargeOrderForm();
                $form->saveOrder($order_no,$xml_array);
                break;
            case 'TS':
                //茶艺师预约
                $form=new TeaSpecialistOrderForm();
                $form->saveOrder($order_no,$xml_array);
                break;
            case 'SRe':
                //商户充值订单
                $form=new StoreRechargeOrderForm();
                $form->saveOrder($order_no,$xml_array);
                break;                    
            default:
                break;
        }
   }
}