const _defaultsDeep = require( "lodash/defaultsDeep" );
const path = require( "path" );
const pkg = require( "../../package.json" );
const UnminifiedWebpackPlugin = require( "unminified-webpack-plugin" );
const { flattenVersionForFile } = require( "../version.js" );
const webpack = require( "webpack" );

const externals = {
	yoastseo: "yoast.analysis",
};

const pluginVersionSlug = flattenVersionForFile( pkg.yoast.pluginVersion );

const defaultConfig = {
	mode: "production",
	devtool: "cheap-module-eval-source-map",
	entry: {
		'yoast-video-seo-plugin': path.join(__dirname, "../../", "js/src/yoast-videoseo-plugin.js" ),
	},
	output: {
		path: path.join( __dirname, "../../", "js" ),
		filename: "[name]-" + pluginVersionSlug + ".min.js"
	},
	externals: externals,
	optimization: {
		minimize: true
	},
	plugins: [
		new webpack.DefinePlugin( {
			"process.env": {
				NODE_ENV: JSON.stringify( "production" ),
			}
		} ),
		new UnminifiedWebpackPlugin()
	],
};


const defaults = ( config ) => {
	return _defaultsDeep( config, defaultConfig );
};

module.exports = {
	defaults
};
