!function(e){var t={};function n(o){if(t[o])return t[o].exports;var s=t[o]={i:o,l:!1,exports:{}};return e[o].call(s.exports,s,s.exports,n),s.l=!0,s.exports}n.m=e,n.c=t,n.d=function(e,t,o){n.o(e,t)||Object.defineProperty(e,t,{enumerable:!0,get:o})},n.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},n.t=function(e,t){if(1&t&&(e=n(e)),8&t)return e;if(4&t&&"object"==typeof e&&e&&e.__esModule)return e;var o=Object.create(null);if(n.r(o),Object.defineProperty(o,"default",{enumerable:!0,value:e}),2&t&&"string"!=typeof e)for(var s in e)n.d(o,s,function(t){return e[t]}.bind(null,s));return o},n.n=function(e){var t=e&&e.__esModule?function(){return e.default}:function(){return e};return n.d(t,"a",t),t},n.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},n.p="",n(n.s="./js/src/yoast-videoseo-plugin.js")}({"./js/src/yoast-videoseo-plugin.js":
/*!*****************************************!*\
  !*** ./js/src/yoast-videoseo-plugin.js ***!
  \*****************************************/
/*! no exports provided */function(module,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var yoastseo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! yoastseo */ \"yoastseo\");\n/* harmony import */ var yoastseo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(yoastseo__WEBPACK_IMPORTED_MODULE_0__);\n/* global YoastSEO: true, wpseoVideoL10n, AssessmentResult */\n\n\n/**\n * Adds eventListener on page load to load the videoSEO.\n */\nif ( wpseoVideoL10n.has_video === '1' ) {\n\tif ( typeof YoastSEO !== 'undefined' && typeof YoastSEO.app !== 'undefined' ) {\n\t\tnew YoastVideoSEOplugin( YoastSEO.app );\n\t}\n\telse {\n\t\tjQuery( window ).on(\n\t\t\t'YoastSEO:ready',\n\t\t\tfunction() {\n\t\t\t\tnew YoastVideoSEOplugin( YoastSEO.app );\n\t\t\t}\n\t\t);\n\t}\n}\n\n/**\n * Adds the plugin for videoSEO to the YoastSEO Analyzer.\n */\nfunction YoastVideoSEOplugin( app ) {\n\n\tapp.registerPlugin( 'YoastVideoSEO', { 'status': 'ready' } );\n\n\tapp.registerAssessment( 'videoTitle', { getResult: this.videoTitle.bind( this ) }, 'YoastVideoSEO' );\n\n\tapp.registerAssessment( 'videoBodyLength', { getResult: this.videoBodyLength.bind( this ) }, 'YoastVideoSEO' );\n\n}\n\n/**\n * Tests if the word video appears in the title, returns number of matches\n * @param {object} paper The paper to run this assessment on\n * @param {object} researcher The researcher used for the assessment\n * @param {object} i18n The i18n-object used for parsing translations\n * @returns {object} an assessmentresult with the score and formatted text.\n */\nYoastVideoSEOplugin.prototype.videoTitle = function( paper, researcher, i18n ) {\n\tvar videoRegex = new RegExp( wpseoVideoL10n.video, 'ig' );\n\tvar matches = paper.getTitle().match( videoRegex ) || 0;\n\tvar assessmentResult = new yoastseo__WEBPACK_IMPORTED_MODULE_0__[\"AssessmentResult\"]();\n\tvar result = this.scoreVideoTitle( matches );\n\tassessmentResult.setScore( result.score ) ;\n\tassessmentResult.setText( result.text );\n\treturn assessmentResult;\n};\n\n/**\n * Returns the scoreobject based on the number of matches in the videotitle\n * @param {array} matches The matches in the videotitle.\n * @returns {{score: number, text: *}} The object containing the score and text\n */\nYoastVideoSEOplugin.prototype.scoreVideoTitle = function( matches ) {\n\tif ( matches.length > 0 ){\n\t\treturn {\n\t\t\tscore: 9,\n\t\t\ttext: wpseoVideoL10n.video_title_good\n\t\t};\n\t}\n\treturn{\n\t\tscore: 6,\n\t\ttext:wpseoVideoL10n.video_title_ok\n\t};\n};\n\n/**\n * returns the wordcount for of the text\n * @returns int\n */\nYoastVideoSEOplugin.prototype.videoBodyLength = function( paper, researcher, i18n ) {\n\tvar wordCount = researcher.getResearch( \"wordCountInText\" );\n\tvar assessmentResult = new yoastseo__WEBPACK_IMPORTED_MODULE_0__[\"AssessmentResult\"]();\n\tvar result = this.scoreVideoBodyLength( wordCount, i18n );\n\tassessmentResult.setScore( result.score ) ;\n\tassessmentResult.setText( result.text );\n\n\treturn assessmentResult;\n};\n\n/**\n * Returns the score and text based on the wordcount.\n * @param {number} wordCount The number of words in the text\n * @returns {{score: number, text: *}} The resultobject\n */\nYoastVideoSEOplugin.prototype.scoreVideoBodyLength = function( wordCount, i18n ) {\n\tif ( wordCount <= 150 ){\n\t\treturn {\n\t\t\tscore: 6,\n\t\t\ttext: wpseoVideoL10n.video_body_short\n\t\t}\n\t}\n\tif ( wordCount > 150 && wordCount < 400 ){\n\t\treturn {\n\t\t\tscore: 9,\n\t\t\ttext: wpseoVideoL10n.video_body_good\n\t\t}\n\t}\n\tif ( wordCount >= 400 ) {\n\t\treturn {\n\t\t\tscore: 6,\n\t\t\ttext: i18n.sprintf( wpseoVideoL10n.video_body_long, wpseoVideoL10n.video_body_long_url, '</a>' )\n\t\t}\n\t}\n};\n\n\n//# sourceURL=webpack:///./js/src/yoast-videoseo-plugin.js?")},yoastseo:
/*!*********************************!*\
  !*** external "yoast.analysis" ***!
  \*********************************/
/*! no static exports found */function(module,exports){eval("module.exports = yoast.analysis;\n\n//# sourceURL=webpack:///external_%22yoast.analysis%22?")}});