jQuery(document).ready(function($){

    $("#newsmaker_show_email_field").click(function(){
        var t = $(this);

        if(t.is(':checked')){
            $(".newsmaker_notify_email_wrap").fadeIn(200);
        }else{
            $(".newsmaker_notify_email_wrap").fadeOut(200);
        }
    });

    $(".newsmaker_vote_button").click(function(){
        var answer_id = $(this).attr("data-answer_id");
        var post_id = $(this).attr("data-post_id");

        $.post(document.location.protocol+"//"+document.location.host+globalVars.ajaxURL+"wp-admin/admin-ajax.php", {"answer_id" : answer_id, "post_id" : post_id, "action" : "newsmaker_poll_vote"}, function(data){
            data = jQuery.parseJSON(data);
            if(data.response == "ok"){
                $(".newsmaker_additional_content").html(data.view);
                $('.chart').horizBarChart({
                    selector: '.bar',
                    speed: 2000
                });
            }
        });

    });

    $(".newsmaker_user_settings_form").submit(function(){
        return false;
    });

    $(".newsmaker_settings_email_submit").click(function(){
        var email = $(".newsmaker_user_email").val();
        if(email){
            $.post(document.location.protocol+"//"+document.location.host+globalVars.ajaxURL+"wp-admin/admin-ajax.php", {"action":"newsmaker_change_email", "email":email}, function(data){
                if(data.response == "ok"){
                    window.location.href = globalVars.ajaxURL;
                }
            }, "json");
        }
    });

    $(".newsmaker_settings_password_submit").click(function(){
        var password = $(".newsmaker_current_password").val();
        var new_password = $(".newsmaker_new_password").val();
        var confirm_password = $(".newsmaker_confirm_password").val();

        $.post(document.location.protocol+"//"+document.location.host+globalVars.ajaxURL+"wp-admin/admin-ajax.php",
            {"action":"newsmaker_change_password", "password":password, "new_password":new_password, "confirm_password":confirm_password}, function(data){

                if(data.response == "ok"){
                    window.location.href = globalVars.ajaxURL;
                }else{
                    if(data.errors){
                        $(".newsmaker_errors").html("");
                        $.each(data.errors, function(key, value){
                            $(".newsmaker_errors").append("<label>"+value+"</label><br>");
                        });
                    }
                }
            }, "json");
    });

    $(".newsmaker_register_form").submit(function(){
        return false;
    });

    $(".newsmaker_register_submit").click(function(){
        $.post(document.location.protocol+"//"+document.location.host+globalVars.ajaxURL+"wp-admin/admin-ajax.php", $(".newsmaker_register_form").serialize(), function(data){
            if(data.response == "ok"){
                $(".newsmaker_errors").html("<label>"+trString.successfullyRegistered+"</label>");
            }else{
                $(".newsmaker_errors").html("");
                $.each(data.errors, function(key, value){
                    $(".newsmaker_errors").append("<label>"+value+"</label><br>");
                });
            }
        }, "json");
    });

    $(".newsmaker_show_results").click(function(){
        var post_id = $(this).attr("data-post_id");

        $.post(document.location.protocol+"//"+document.location.host+globalVars.ajaxURL+"wp-admin/admin-ajax.php", {"post_id" : post_id, "action" : "newsmaker_show_poll_results"}, function(data){
            data = jQuery.parseJSON(data);
            if(data.response == "ok"){
                $(".newsmaker_additional_content").html(data.view);
                $('.chart').horizBarChart({
                    selector: '.bar',
                    speed: 2000
                });
            }
        });
    });

    $("#newsmaker_poll_submit").click(function(){
        var options = {
            url: document.location.protocol+"//"+document.location.host+globalVars.ajaxURL+"wp-admin/admin-ajax.php",
            resetForm: true
        };

        $(".newsmaker_poll_form").ajaxForm(options);
    });

    $(document).on("click", ".newsmaker_answer_delete", function(){
        $(this).parent().remove();
    });

    var counter = 0;

    $(".newsmaker_poll_addMore").click(function(){
        if(counter <= 7){
            $(".newsmaker_poll_answers_div").append("<div class='newsmaker_single_answer'>\
                <input type='text' name='newsmaker_answers[]'><label class='newsmaker_answer_delete'>\
                    <i class='fa fa-times-circle'></i>\
                </label>\
            </div>");
        }

        counter = $(".newsmaker_poll_answers_div").find(".newsmaker_single_answer").length;
    });

    $("#newsmaker_link_url").on('paste', function () {
        var element = this;
        $(".newsmaker_pleasewait_message").html(trString.pleaseWait+"...");
        setTimeout(function () {
            var text = $("#newsmaker_link_url").val();
            $.post(document.location.protocol+"//"+document.location.host+globalVars.ajaxURL+"wp-admin/admin-ajax.php", {
                action: "newsmaker_process_link",
                url: text
            }, function(data){
                $(".newsmaker_pleasewait_message").hide();
                $("#newsmaker_link_title").val(data.title);
                tinymce.activeEditor.setContent(tinyMCE.activeEditor.getContent() + data.description);
                $("#newsmaker_link_source").val(text);
                $("#newsmaker_link_image").attr("src", data.image);
                $("#newsmaker_image_holder").val(data.image);

                $(".newsmaker_link_second_part").css("display", "block");
            }, "json");
        }, 100);

    });

    $("#newsmaker_image_url").keyup(function(){
        IsValidImageUrl($("#newsmaker_image_url").val());
    });

    $("#newsmaker_image_url").on("paste", function(){
        var element = this;
        setTimeout(function () {
            IsValidImageUrl($("#newsmaker_image_url").val());
        }, 100);
    });

    function IsValidImageUrl(url) {
        $("<img>", {
            src: url,
            error: function() {
                $("#newsmaker_image_url").css("border", "1px solid red");
            },
            load: function() {
                $("#newsmaker_img_holder").val(url);
                $(".newsmaker_upload_preview").html("<img src='"+url+"'>");
                $(".fileinput-button").hide();
                $("#newsmaker_image_secondpart").fadeIn(200);
            }
        });
    }

    $("#newsmaker_video_url").on("paste", function(){
        var element = this;
        setTimeout(function () {
            checkVideo($("#newsmaker_video_url").val());
        }, 100);
    });

    function checkVideo(link){
        $("#pleaseWait").html(trString.pleaseWait+"...");
        $("#pleaseWait").fadeIn(200);
        $.post(document.location.protocol+"//"+document.location.host+globalVars.ajaxURL+"wp-admin/admin-ajax.php", {"url" : link, "action" : "newsmaker_fetch_video"}, function(data){
            $("#pleaseWait").html(trString.pleaseWait+"...");
            $("#pleaseWait").hide();
            if(data.response != "error"){
                $(".nesmaker_video_first").hide();
                $(".newsmaker_video_preview").html(data.data.video);
                $("#newsmaker_video_title").val(data.data.title);
                $(".newsmaker_video_preview").fadeIn(300);
                $(".newsmaker_video_second").fadeIn(300);
            }else{
                $("#newsmaker_video_url").show();
                $("#newsmaker_video_url").css("border", "1px solid red");
                $("#pleaseWait").html(trString.videoNotFound);
                $("#pleaseWait").fadeIn(300);
            }
        }, "json");
    }

    var I_can_submit = true;

    function newsmaker_post_callback(data){

        data = jQuery.parseJSON(data);

        $(".newsmaker_post_message").html("<label>"+trString.successfullySubmited+"</label>");
        setTimeout(function(){
            window.location.href = data.redirect;
        }, 500);

    }

    function newsmaker_post_beforeSubmit(){
        $("#newsmaker_post_submit").val(trString.pleaseWait+"...");
        
        if(I_can_submit == true){
            I_can_submit = false;
            return true;
        }else{
            return false;
        }
    }

    function newsmaker_link_beforeSubmit(){
        $(".newsmaker_link_submit").val(trString.pleaseWait+"...");
        
        if(I_can_submit == true){
            I_can_submit = false;
            return true;
        }else{
            return false;
        }
    }

    function newsmaker_image_beforeSubmit(){
        $(".newsmaker_image_submit").val(trString.pleaseWait+"...");
        
        if(I_can_submit == true){
            I_can_submit = false;
            return true;
        }else{
            return false;
        }
    }

    function newsmaker_video_beforeSubmit(){
        $(".newsmaker_video_submit").val(trString.pleaseWait+"...");
        
        if(I_can_submit == true){
            I_can_submit = false;
            return true;
        }else{
            return false;
        }
    }

    function newsmaker_poll_beforeSubmit(){
        $("#newsmaker_poll_submit").val(trString.pleaseWait+"...");
        
        if(I_can_submit == true){
            I_can_submit = false;
            return true;
        }else{
            return false;
        }
    }

    $("#newsmaker_post_edit_submit").click(function(){
        var title = $(".newsmaker_post_title").val();
        var body = tinyMCE.activeEditor.getContent();
        var checker = false;

        var errorTitle = false;
        var errorBody = false;;

        if(!title){
            errorTitle = true;
            checker = true;
        }

        if(!body){
            errorBody = true;
            checker = true;
        }

        if(checker){
            if(errorTitle){
                $(".newsmaker_post_title").addClass("newsmaker_error");
            }
            if(errorBody){
                $("#wp-newsmaker_editor-wrap .wp-editor-container").addClass("newsmaker_error");
            }
            $("html, body").animate({ scrollTop: 0 }, 600);
            return false;
        }else{

            var options = {
                url: document.location.protocol+"//"+document.location.host+globalVars.ajaxURL+"wp-admin/admin-ajax.php",
                success: newsmaker_post_callback,
                beforeSubmit: newsmaker_post_beforeSubmit,
                resetForm: true
            };

            $(".newsmaker_post_form").ajaxForm(options);

        }
    });

    $("#newsmaker_post_submit").click(function(){
        
        var title = $(".newsmaker_post_title").val();
        var body = tinyMCE.activeEditor.getContent();
        var checker = false;

        var errorTitle = false;
        var errorBody = false;;

        if(!title){
            errorTitle = true;
            checker = true;
        }

        if(!body){
            errorBody = true;
            checker = true;
        }

        if(checker){
            if(errorTitle){
                $(".newsmaker_post_title").addClass("newsmaker_error");
            }
            if(errorBody){
                $("#wp-newsmaker_editor-wrap .wp-editor-container").addClass("newsmaker_error");
            }
            $("html, body").animate({ scrollTop: 0 }, 600);
            return false;
        }else{

            var options = {
                url: document.location.protocol+"//"+document.location.host+globalVars.ajaxURL+"wp-admin/admin-ajax.php",
                success: newsmaker_post_callback,
                beforeSubmit: newsmaker_post_beforeSubmit,
                resetForm: true
            };

            $(".newsmaker_post_form").ajaxForm(options);

        }
    });

    $(".newsmaker_link_submit").click(function(){
        var title = $("#newsmaker_link_title").val();
        var body = tinyMCE.activeEditor.getContent();
        var checker = false;

        var errorTitle = false;
        var errorBody = false;;

        if(!title){
            errorTitle = true;
            checker = true;
        }

        if(!body){
            errorBody = true;
            checker = true;
        }

        if(checker){
            if(errorTitle){
                $("#newsmaker_link_title").addClass("newsmaker_error");
            }
            if(errorBody){
                $("#wp-newsmaker_editor-wrap .wp-editor-container").addClass("newsmaker_error");
            }
            $("html, body").animate({ scrollTop: 0 }, 600);
            return false;
        }else{

            var options = {
                url: document.location.protocol+"//"+document.location.host+globalVars.ajaxURL+"wp-admin/admin-ajax.php",
                success: newsmaker_post_callback,
                beforeSubmit: newsmaker_link_beforeSubmit,
                resetForm: true
            };

            $(".newsmaker_link_form").ajaxForm(options);

        }
    });

    $(".newsmaker_image_submit").click(function(){
        var title = $(".newsmaker_image_title").val();
        var checker = false;

        var errorTitle = false;
        var errorBody = false;;

        if(!title){
            errorTitle = true;
            checker = true;
        }

        if(checker){
            if(errorTitle){
                $(".newsmaker_image_title").addClass("newsmaker_error");
            }

            $("html, body").animate({ scrollTop: 0 }, 600);
            return false;
        }else{

            var options = {
                url: document.location.protocol+"//"+document.location.host+globalVars.ajaxURL+"wp-admin/admin-ajax.php",
                success: newsmaker_post_callback,
                beforeSubmit: newsmaker_image_beforeSubmit,
                resetForm: true
            };

            $(".newsmaker_image_form").ajaxForm(options);

        }
    });

    $(".newsmaker_video_submit").click(function(){
        var title = $("#newsmaker_video_title").val();
        var checker = false;

        var errorTitle = false;
        var errorBody = false;

        if(!title){
            errorTitle = true;
            checker = true;
        }

        if(checker){
            if(errorTitle){
                $("#newsmaker_video_title").addClass("newsmaker_error");
            }

            $("html, body").animate({ scrollTop: 0 }, 600);
            return false;
        }else{

            var options = {
                url: document.location.protocol+"//"+document.location.host+globalVars.ajaxURL+"wp-admin/admin-ajax.php",
                success: newsmaker_post_callback,
                beforeSubmit: newsmaker_video_beforeSubmit,
                resetForm: true
            };

            $(".newsmaker_video_form").ajaxForm(options);

        }
    });

    $("#newsmaker_poll_submit").click(function(){
        
        var title = $(".newsmaker_poll_title").val();
        var answers = $(".newsmaker_answers").length;

        var checker = false;

        var errorTitle = false;
        var errorAnswers = false;;

        if(!title){
            errorTitle = true;
            checker = true;
        }

        if(answers < 2){
            errorAnswers = true;
            checker = true;
        }

        if(checker){
            if(errorTitle){
                $(".newsmaker_poll_title").addClass("newsmaker_error");
            }
            if(errorAnswers){
                $(".newsmaker_poll_answers_div").addClass("newsmaker_error");
            }
            $("html, body").animate({ scrollTop: 0 }, 600);
            return false;
        }else{

            var options = {
                url: document.location.protocol+"//"+document.location.host+globalVars.ajaxURL+"wp-admin/admin-ajax.php",
                success: newsmaker_post_callback,
                beforeSubmit: newsmaker_poll_beforeSubmit,
                resetForm: true
            };

            $(".newsmaker_poll_form").ajaxForm(options);

        }
    });

    

});
