<?php

$categories = get_terms( 'category', array(
    'orderby'    => 'count',
    'hide_empty' => 0,
) );

?>

<script>
    jQuery(document).ready(function($){
        $(function() {
            $('#myTags').tagit({
                singleField: true,
                placeholderText: "Post tags",
                fieldName: "newsmaker_poll_tags[]"
            });
        });
    });
</script>

<form action="" method="post" enctype="multipart/form-data" class="newsmaker_poll_form">

    <p>
        <label><?php _e( 'Featured image', 'wp-newsmaker' ); ?></label><br>
        <input type="file" name="newsmaker_poll_image" style="width:100%;">
    </p>

    <p>
        <?php echo get_the_post_thumbnail( $edit_post->ID, 'full' ); ?>
    </p>

    <p>
        <label><?php _e( 'Poll question', 'wp-newsmaker' ); ?></label><br>
        <input class="newsmaker_poll_title" type="text" name="newsmaker_poll_title" value="<?php echo $edit_post->post_title; ?>" style="width:100%;">
    </p>

    <label>
        <?php _e( 'Poll answers', 'wp-newsmaker' ); ?>
    </label>

    <?php
    	global $wpdb;

		$query = "select id, answer, position from ".$wpdb->prefix."newsmaker_answers where post_id = $edit_post->ID order by position";
		$answers = $wpdb->get_results($query, OBJECT);
    ?>

    <div class="newsmaker_poll_answers_div">
        <?php foreach($answers as $answer){ ?>
        	<div class="newsmaker_single_answer_a">
	            <label class="newsmaker_answer_drag">
	                <i class="fa fa-arrows"></i>
	            </label><input type="text" name="newsmaker_answers[]" class="newsmaker_answers" value="<?php echo $answer->answer; ?>"><label class="newsmaker_answer_delete">
	                <i class="fa fa-times"></i>
	            </label>
	        </div>
        <?php } ?>
    </div>

    <a class="newsmaker_poll_addMore"><?php _e( 'Add more answers', 'wp-newsmaker' ); ?></a> <br><br>

    <?php if(is_user_logged_in()){ ?>

    <?php
        $selected = wp_get_post_categories( $edit_post->ID );
    ?>

        <p>
            <label><?php _e( 'Categories', 'wp-newsmaker' ); ?></label><br>
            <select name="newsmaker_poll_categories" id="categorySelect">
                <?php foreach ( $categories as $c ) { ?>
                    <option value="<?php echo $c->term_id ?>" <?php if(in_array($c->term_id, $selected)) echo "selected"; ?>><?php echo $c->name; ?></option>
                <?php } ?>
            </select>
        </p>
    <?php } ?>

    <p>
        <label><?php _e("Optional additional text", "wp-newsmaker") ?></label><br>
        <textarea name="newsmaker_poll_body" style="width: 100%;" value="<?php echo $edit_post->post_content ?>"></textarea>
    </p>

    <p>
        <label><?php _e( 'Tags', 'wp-newsmaker' ); ?></label><br>
        <?php $post_tags = wp_get_post_tags( $edit_post->ID ); ?>
        <ul id="myTags">
            <?php foreach(explode(",", $post_tags[0]->name) as $tag) { ?>
            <li><?php echo $tag ?></li>
            <?php } ?>
        </ul>
    </p>

    <p class="newsmaker_post_message"> </p>

    <input type="hidden" name="action" value="newsmaker_process_edit_poll">
    <input type="hidden" name="newsmaker_poll_id" value="<?php echo $edit_post->ID; ?>">

    <p>
        <input type="submit" name="newsmaker_poll_submit" value="<?php _e( 'Publish', 'wp-newsmaker' ); ?>" id="newsmaker_poll_submit">
    </p>

</form>

<script type="text/javascript">
	jQuery(document).ready(function($){
		$('.newsmaker_poll_answers_div').sortable({
	        items: '.newsmaker_single_answer_a',
			placeholder : "newsmaker_category_placeholder"
		});
	});
</script>