<div id="resetPassword">
    <div id="message"></div>
    <?php
        $errors = new WP_Error();
        $user = check_password_reset_key($_GET['key'], $_GET['login']);
 
        if ( is_wp_error( $user ) ) {
            if ( $user->get_error_code() === 'expired_key' )
                $errors->add( 'expiredkey', __( 'Sorry, that key has expired. Please try again.' ) );
            else
                $errors->add( 'invalidkey', __( 'Sorry, that key does not appear to be valid.' ) );
        }
 
        if ( $errors->get_error_code() )
            echo $errors->get_error_message( $errors->get_error_code() );
        ?>
 
        <form id="resetPasswordForm" method="post" autocomplete="off">
            <?php
                if ( function_exists( 'wp_nonce_field' ) ) 
                    wp_nonce_field( 'rs_user_reset_password_action', 'rs_user_reset_password_nonce' );
            ?>
            
            <input type="hidden" name="user_key" id="user_key" value="<?php echo esc_attr( $_GET['key'] ); ?>" autocomplete="off" />
            <input type="hidden" name="user_login" id="user_login" value="<?php echo esc_attr( $_GET['login'] ); ?>" autocomplete="off" />
 
            <p>
                <label for="pass1"><?php _e('New password') ?><br />
                <input type="password" name="pass1" id="pass1" class="input" size="20" value="" autocomplete="off" /></label>
            </p>
            <p>
                <label for="pass2"><?php _e('Confirm new password') ?><br />
                <input type="password" name="pass2" id="pass2" class="input" size="20" value="" autocomplete="off" /></label>
            </p>
 
            <p class="description indicator-hint"><?php _e('Hint: The password should be at least seven characters long. To make it stronger, use upper and lower case letters, numbers, and symbols like ! " ? $ % ^ &amp; ).'); ?></p>
 
            <br class="clear" />
 
            <?php
            do_action( 'resetpass_form', $user );
            ?>
            <p class="submit"><input type="submit" name="wp-submit" id="wp-submit" class="button button-primary button-large" value="<?php esc_attr_e('Reset Password'); ?>" /></p>
        </form>
    </div>

<script type="text/javascript">
jQuery(document).ready(function($) {
    $("form#resetPasswordForm").submit(function(){
        var submit = $("div#resetPassword #submit"),
            message    = $("div#resetPassword #message"),
            contents = {
                action:     'reset_pass',
                nonce:         this.rs_user_reset_password_nonce.value,
                pass1:        this.pass1.value,
                pass2:        this.pass2.value,
                user_key:    this.user_key.value,
                user_login:    this.user_login.value
            };

        submit.attr("disabled", "disabled").addClass('disabled');
        
        $.post( document.location.protocol+"//"+document.location.host+globalVars.ajaxURL+"wp-admin/admin-ajax.php", contents, function( data ){
            submit.removeAttr("disabled").removeClass('disabled');
            message.html( data );
        });
        
        return false;
    });
});
</script>