<?php

$categories = get_terms( 'category', array(
    'orderby'    => 'count',
    'hide_empty' => 0,
) );

?>

<script>
    jQuery(document).ready(function($){
        $(function() {
            $('#myTags').tagit({
                singleField: true,
                placeholderText: "Post tags"
            });
        });
    });
</script>

<form action="" method="post" enctype="multipart/form-data" class="newsmaker_post_form">

    <p>
        <label><?php _e( 'Post title', 'wp-newsmaker' ); ?></label><br>
        <input class="newsmaker_post_title" type="text" name="newsmaker_post_title" style="width:100%;">
    </p>

    <p>
        <label><?php _e( 'Featured image', 'wp-newsmaker' ); ?></label><br>
        <input type="file" name="newsmaker_post_image" style="width:100%;">
    </p>

    <p class="newsmaker_editor_wrap">
        <label><?php _e( 'Post body', 'wp-newsmaker' ); ?></label><br>
    </p>
    <?php wp_editor("", "newsmaker_editor", array(
        "textarea_name" => "newsmaker_post_body",
        "drag_drop_upload" => true,
        "editor_class" => "newsmaker_editor"
    )); ?>

    <?php if(is_user_logged_in()){ ?>
        <p>
            <label><?php _e( 'Categories', 'wp-newsmaker' ); ?></label><br>
            <select name="newsmaker_post_categories" id="categorySelect">
                <?php foreach ( $categories as $c ) { ?>
                    <option value="<?php echo $c->term_id ?>"><?php echo $c->name; ?></option>
                <?php } ?>
            </select>
        </p>
    <?php } ?>

    <br>
    <p>
        <label><?php _e( 'Tags', 'wp-newsmaker' ); ?></label><br>
        <input type="text" name="newsmaker_post_tags" id="myTags">
    </p>

    <?php if(get_option( 'newsmaker_email_user_notification' )){ ?>
        <p>
            <input type="checkbox" id="newsmaker_show_email_field" name="newsmaker_show_email_field" value="1">
            <label><?php _e( 'Get notified via email if your post is approved', 'wp-newsmaker' ); ?>?</label>
        </p>

        <?php if(!is_user_logged_in()) { ?>
            <div class="newsmaker_notify_email_wrap">
                <p>
                    <label><?php _e( 'Full name', 'wp-newsmaker' ); ?></label><br>
                    <input type="text" name="newsmaker_notify_name" style="width:100%;">
                </p>

                <p>
                    <label><?php _e( 'Email', 'wp-newsmaker' ); ?></label><br>
                    <input type="email" name="newsmaker_notify_email" style="width:100%;">
                </p>
            </div>
        <?php } ?>
    <?php } ?>

    <input type="hidden" name="action" value="newsmaker_post_publish"/>

    <p class="newsmaker_post_message">
        
    </p>

    <p>
        <input type="submit" name="newsmaker_post_submit" value="<?php _e( 'Publish', 'wp-newsmaker' ); ?>" id="newsmaker_post_submit">
    </p>

</form>