<?php


$categories = get_terms( 'category', array(
    'orderby'    => 'count',
    'hide_empty' => 0,
) );

?>

<script>
    jQuery(document).ready(function($){
        $(function() {
            $('#myTags').tagit({
                singleField: true,
                placeholderText: "Post tags"
            });
        });
    });
</script>

<form action="" method="post" enctype="multipart/form-data" class="newsmaker_poll_form">

    <p>
        <label><?php _e( 'Featured image', 'wp-newsmaker' ); ?></label><br>
        <input type="file" name="newsmaker_poll_image" style="width:100%;">
    </p>

    <p>
        <label><?php _e( 'Poll question', 'wp-newsmaker' ); ?></label><br>
        <input class="newsmaker_poll_title" type="text" name="newsmaker_poll_title" style="width:100%;">
    </p>

    <label>
        <?php _e( 'Poll answers', 'wp-newsmaker' ); ?>
    </label>

    <div class="newsmaker_poll_answers_div">
        
        <div class="newsmaker_single_answer_a">
            <input type="text" name="newsmaker_answers[]" class="newsmaker_answers">
        </div>

        <div class="newsmaker_single_answer_a">
            <input type="text" name="newsmaker_answers[]" class="newsmaker_answers">
        </div>

    </div>

    <a class="newsmaker_poll_addMore"><?php _e( 'Add more answers', 'wp-newsmaker' ); ?></a> <br><br>

    <?php if(is_user_logged_in()){ ?>
        <p>
            <label><?php _e( 'Categories', 'wp-newsmaker' ); ?></label><br>
            <select name="newsmaker_poll_categories" id="categorySelect">
                <?php foreach ( $categories as $c ) { ?>
                    <option value="<?php echo $c->term_id ?>"><?php echo $c->name; ?></option>
                <?php } ?>
            </select>
        </p>
    <?php } ?>

    <p>
        <label><?php _e("Optional additional text", "wp-newsmaker") ?></label><br>
        <textarea name="newsmaker_poll_body" style="width: 100%;"></textarea>
    </p>

    <p>
        <label><?php _e( 'Tags', 'wp-newsmaker' ); ?></label><br>
        <input type="text" name="newsmaker_poll_tags" id="myTags">
    </p>

    <?php if(get_option( 'newsmaker_email_user_notification' )){ ?>
        <p>
            <input type="checkbox" id="newsmaker_show_email_field" name="newsmaker_show_email_field" value="1">
            <label><?php _e( 'Get notified via email if your post is approved', 'wp-newsmaker' ); ?>?</label>
        </p>

        <?php if(!is_user_logged_in()) { ?>
            <div class="newsmaker_notify_email_wrap">
                <p>
                    <label><?php _e( 'Full name', 'wp-newsmaker' ); ?></label><br>
                    <input type="text" name="newsmaker_notify_name" style="width:100%;">
                </p>

                <p>
                    <label><?php _e( 'Email', 'wp-newsmaker' ); ?></label><br>
                    <input type="email" name="newsmaker_notify_email" style="width:100%;">
                </p>
            </div>
        <?php } ?>
    <?php } ?>

    <p class="newsmaker_post_message"> </p>

    <input type="hidden" name="action" value="newsmaker_process_poll">

    <p>
        <input type="submit" name="newsmaker_poll_submit" value="<?php _e( 'Publish', 'wp-newsmaker' ); ?>" id="newsmaker_poll_submit">
    </p>

</form>