<?php

$categories = get_terms( 'category', array(
    'orderby'    => 'count',
    'hide_empty' => 0,
) );

ob_start();

?>

<script>
    jQuery(document).ready(function($){
        $(function() {
            $('#myTags').tagit({
                singleField: true,
                placeholderText: "<?php _e( 'Post tags', 'wp-newsmaker' ); ?>"
            });
        });
    });
</script>

<form action="" method="post" enctype="multipart/form-data" class="newsmaker_link_form">

    <div class="newsmaker_link_first_part">
        <p>
            <label><?php _e( 'Paste URL', 'wp-newsmaker' ); ?></label><br>
            <input id="newsmaker_link_url" type="text" name="newsmaker_link_url" style="width:100%;">
            <label class="newsmaker_pleasewait_message"></label>
        </p>
    </div>

    <div class="newsmaker_link_second_part">
        <p>
            <label><?php _e( 'Post title', 'wp-newsmaker' ); ?></label><br>
            <input id="newsmaker_link_title" type="text" name="newsmaker_link_title" style="width:100%;">
        </p>

        <p>
            <img id="newsmaker_link_image">
            <input type="hidden" id="newsmaker_image_holder" name="newsmaker_image_holder">
        </p>

        <p>
            <label><?php _e( 'Featured image', 'wp-newsmaker' ); ?></label><br>
            <input id="newsmaker_link_image" type="file" name="newsmaker_link_image" style="width:100%;">
        </p>

        <p class="newsmaker_editor_wrap">
            <label><?php _e( 'Post body', 'wp-newsmaker' ); ?></label><br>
            <?php wp_editor("", "newsmaker_editor", array(
                "textarea_name" => "newsmaker_link_body",
                "drag_drop_upload" => true,
                "editor_class" => "newsmaker_editor"
            )); ?>
        </p>

        <?php if(is_user_logged_in()){ ?>
            <p>
                <label><?php _e( 'Categories', 'wp-newsmaker' ); ?></label><br>
                <select name="newsmaker_link_categories" id="categorySelect">
                    <?php foreach ( $categories as $c ) { ?>
                        <option value="<?php echo $c->term_id ?>"><?php echo $c->name; ?></option>
                    <?php } ?>
                </select>
            </p>
        <?php } ?>

        <p>
            <label><?php _e( 'Tags', 'wp-newsmaker' ); ?></label><br>
            <input type="text" name="newsmaker_link_tags" id="myTags">
        </p>

        <p>
            <label><?php _e( 'Source', 'wp-newsmaker' ); ?></label>
            <input type="text" name="newsmaker_link_source" id="newsmaker_link_source" style="width:100%;">
        </p>

        <?php if(get_option( 'newsmaker_email_user_notification' )){ ?>
        <p>
            <input type="checkbox" id="newsmaker_show_email_field" name="newsmaker_show_email_field">
            <label><?php _e( 'Get notified via email if your post is approved', 'wp-newsmaker' ); ?>?</label>
        </p>

        <?php if(!is_user_logged_in()) { ?>
            <div class="newsmaker_notify_email_wrap">
                <p>
                    <label><?php _e( 'Full name', 'wp-newsmaker' ); ?></label><br>
                    <input type="text" name="newsmaker_notify_name" style="width:100%;">
                </p>

                <p>
                    <label><?php _e( 'Email', 'wp-newsmaker' ); ?></label><br>
                    <input type="email" name="newsmaker_notify_email" style="width:100%;">
                </p>
            </div>
        <?php } ?>
    <?php } ?>

        <input type="hidden" name="action" value="newsmaker_link_publish"/>

        <p class="newsmaker_post_message">
            
        </p>

        <p>
            <input type="submit" name="newsmaker_link_submit" value="<?php _e( 'Publish', 'wp-newsmaker' ); ?>" class="newsmaker_link_submit">
        </p>
    </div>

</form>