<form action="<?php esc_url( $_SERVER['REQUEST_URI'] ) ?>" method="post" enctype="multipart/form-data">

<?php

$categories = get_terms( 'category', array(
    'orderby'    => 'count',
    'hide_empty' => 0,
) );

$interests = null;

if(is_user_logged_in()){

    $user = wp_get_current_user();
    $interests = get_user_meta( $user->ID, "newsmaker_interests", true );

}else{

    session_start();
    
    if(isset($_SESSION["newsmaker_interests"])){
        $interests = $_SESSION["newsmaker_interests"];
    }else{
        if(isset($_COOKIE["newsmaker_interests"])){
            $interests = $_COOKIE["newsmaker_interests"];
        }
    }

}

$tempArray = array();
$counter = 0;

$cat = get_terms( 'category', array(
    'orderby'    => 'count',
    'hide_empty' => 0,
) );

$cIDS = array();
foreach($cat as $value){
    array_push($cIDS, $value->term_id);
}

if(!is_array($interests)){
    $interests = array();
}

if(!is_array($cIDS)){
    $cIDS = array();
}

$interests = array_diff($cIDS, $interests);

?>

<div class="newsmaker_interests_div">
    <?php foreach ( $categories as $c ) { ?>
        
        <div><input <?php if(!in_array($c->term_id, $interests)) echo "checked"; ?> type="checkbox" value="<?php echo $c->term_id; ?>" name="interests[]"> <?php echo $c->name; ?></div>

    <?php } ?>
</div>
<br>
<input type="submit" name="newsmaker_interests_submit" value="<?php _e( 'Save', 'wp-newsmaker' ); ?>">

</form>