<div id="lostPassword">
    <div id="message"></div>
    <form id="lostPasswordForm" method="post">
        <?php
            if ( function_exists( 'wp_nonce_field' ) ) 
                wp_nonce_field( 'rs_user_lost_password_action', 'rs_user_lost_password_nonce' );
        ?>

        <p>
            <label for="user_login"><?php _e('Username or E-mail:') ?> <br />
                <input type="text" name="user_login" id="user_login" class="input" value="<?php echo esc_attr($user_login); ?>" size="20" style="width:100%;"/>
            </label>
        </p>
        <?php do_action( 'lostpassword_form' ); ?>
        <p class="submit">
            <input type="submit" name="wp-submit" id="wp-submit" class="button button-primary button-large" value="<?php esc_attr_e('Get New Password'); ?>" />
        </p>
    </form>
</div>

<script type="text/javascript">
	jQuery(document).ready(function($) {
    
	    // for lost password
	    $("form#lostPasswordForm").submit(function(){
	        var submit = $("div#lostPassword #submit"),
	            message    = $("div#lostPassword #message"),
	            contents = {
	                action:     'lost_pass',
	                nonce:         this.rs_user_lost_password_nonce.value,
	                user_login:    this.user_login.value
	            };
	        
	        // disable button onsubmit to avoid double submision
	        submit.attr("disabled", "disabled").addClass('disabled');
	       
	        
	        $.post( document.location.protocol+"//"+document.location.host+globalVars.ajaxURL+"wp-admin/admin-ajax.php", contents, function( data ){
	            submit.removeAttr("disabled").removeClass('disabled');
	            
	            // display return data
	            message.html( data );
	        });
	        
	        return false;
	    });
	});
</script>