<?php
	$args = array(
		'sort_order' => 'ASC',
		'sort_column' => 'post_title',
		'hierarchical' => 1,
		'exclude' => '',
		'include' => '',
		'meta_key' => '',
		'meta_value' => '',
		'authors' => '',
		'child_of' => 0,
		'parent' => -1,
		'exclude_tree' => '',
		'number' => '',
		'offset' => 0,
		'post_type' => 'page',
		'post_status' => 'publish'
	); 
	$pages = get_pages($args); 

	$categories = get_terms( 'category', array(
		'orderby'    => 'count',
		'hide_empty' => 0,
	) ); 

	$users = get_users( 'orderby=nicename' );
?>

<div class="wrap">
	<h1><?php _e("Pages settings", "wp-newsmaker") ?></h1><br>
	<h3><?php _e( "Select corresponding pages based on names on left side", "wp-newsmaker" ); ?></h3>

	<form method="post" action="options.php"> 

		<?php settings_fields( "newsmaker-settings-page" ); ?>

		<table class="form-table">

			<tr valign="middle">
		        <th scope="row"><?php _e("Login page", "wp-newsmaker") ?></th>
		        <td>
		        	<select name="newsmaker_login_page">
		        		<option value=""><?php _e("== Select page ==", "wp-newsmaker") ?></option>
		        		<?php foreach($pages as $page) { ?>
		        			<option value="<?php echo $page->ID ?>" <?php if($page->ID == get_option( "newsmaker_login_page" )) echo "selected"; ?>><?php echo $page->post_title; ?></option>
		        		<?php } ?>
		        	</select>
		        </td>
	        </tr>
	        <tr valign="middle">
		        <th scope="row"><?php _e("Register page", "wp-newsmaker") ?></th>
		        <td>
		        	<select name="newsmaker_register_page">
		        		<option value=""><?php _e("== Select page ==", "wp-newsmaker") ?></option>
		        		<?php foreach($pages as $page) { ?>
		        			<option value="<?php echo $page->ID ?>" <?php if($page->ID == get_option( "newsmaker_register_page" )) echo "selected"; ?>><?php echo $page->post_title; ?></option>
		        		<?php } ?>
		        	</select>
		        </td>
	        </tr>
	        <tr valign="middle">
		        <th scope="row"><?php _e("My content page", "wp-newsmaker") ?></th>
		        <td>
		        	<select name="newsmaker_mycontent_page">
		        		<option value=""><?php _e("== Select page ==", "wp-newsmaker") ?></option>
		        		<?php foreach($pages as $page) { ?>
		        			<option value="<?php echo $page->ID ?>" <?php if($page->ID == get_option( "newsmaker_mycontent_page" )) echo "selected"; ?>><?php echo $page->post_title; ?></option>
		        		<?php } ?>
		        	</select>
		        </td>
	        </tr>
	        <tr valign="middle">
		        <th scope="row"><?php _e("Edit posts page", "wp-newsmaker") ?></th>
		        <td>
		        	<select name="newsmaker_editpost_page">
		        		<option value=""><?php _e("== Select page ==", "wp-newsmaker") ?></option>
		        		<?php foreach($pages as $page) { ?>
		        			<option value="<?php echo $page->ID ?>" <?php if($page->ID == get_option( "newsmaker_editpost_page" )) echo "selected"; ?>><?php echo $page->post_title; ?></option>
		        		<?php } ?>
		        	</select>
		        </td>
	        </tr>
	        <tr valign="middle">
		        <th scope="row"><?php _e("Settings page", "wp-newsmaker") ?></th>
		        <td>
		        	<select name="newsmaker_settings_page">
		        		<option value=""><?php _e("== Select page ==", "wp-newsmaker") ?></option>
		        		<?php foreach($pages as $page) { ?>
		        			<option value="<?php echo $page->ID ?>" <?php if($page->ID == get_option( "newsmaker_settings_page" )) echo "selected"; ?>><?php echo $page->post_title; ?></option>
		        		<?php } ?>
		        	</select>
		        </td>
	        </tr>
	        <tr valign="middle">
		        <th scope="row"><?php _e("Forgot password page", "wp-newsmaker") ?></th>
		        <td>
		        	<select name="newsmaker_forgotpassword_page">
		        		<option value=""><?php _e("== Select page ==", "wp-newsmaker") ?></option>
		        		<?php foreach($pages as $page) { ?>
		        			<option value="<?php echo $page->ID ?>" <?php if($page->ID == get_option( "newsmaker_forgotpassword_page" )) echo "selected"; ?>><?php echo $page->post_title; ?></option>
		        		<?php } ?>
		        	</select>
		        </td>
	        </tr>


		</table>
	
	<br><hr><br>
		

	<h3 style="margin-bottom: 0;"><?php _e( "Select default category and default user for user-generated content", "wp-newsmaker" ); ?></h3>

	<table class="form-table">

		<tr valign="middle">
	        <th scope="row"></th>
	        <td>
	        	<small><?php _e( "Default category", "wp-newsmaker" ); ?></small>
	        </td>
	        <td>
	        	<small><?php _e( "Default user", "wp-newsmaker" ); ?></small>
	        </td>
        </tr>

        <tr valign="middle">
	        <th scope="row"><?php _e( "Posts", "wp-newsmaker" ); ?></th>
	        <td>
	        	<select name="newsmaker_post_category">
	                <?php foreach ( $categories as $c ) { ?>
	                    <option <?php if($c->term_id == get_option( "newsmaker_post_category" )) echo "selected"; ?> value="<?php echo $c->term_id ?>"><?php echo $c->name; ?></option>
	                <?php } ?>
	            </select>
	        </td>

	        <td>
	        	<select name="newsmaker_post_user">
	                <?php foreach ( $users as $u ) { ?>
	                    <option <?php if($u->ID == get_option( "newsmaker_post_user" )) echo "selected"; ?> value="<?php echo $u->ID ?>"><?php echo $u->user_nicename; ?></option>
	                <?php } ?>
	            </select>
	        </td>
        </tr>

        <tr valign="middle">
	        <th scope="row"><?php _e( "Links", "wp-newsmaker" ); ?></th>
	        <td>
	        	<select name="newsmaker_link_category">
	                <?php foreach ( $categories as $c ) { ?>
	                    <option <?php if($c->term_id == get_option( "newsmaker_link_category" )) echo "selected"; ?> value="<?php echo $c->term_id ?>"><?php echo $c->name; ?></option>
	                <?php } ?>
	            </select>
	        </td>

	        <td>
	        	<select name="newsmaker_link_user">
	                <?php foreach ( $users as $u ) { ?>
	                    <option <?php if($u->ID == get_option( "newsmaker_link_user" )) echo "selected"; ?> value="<?php echo $u->ID ?>"><?php echo $u->user_nicename; ?></option>
	                <?php } ?>
	            </select>
	        </td>

        </tr>

        <tr valign="middle">
	        <th scope="row"><?php _e( "Images", "wp-newsmaker" ); ?></th>
	        <td>
	        	<select name="newsmaker_image_category">
	                <?php foreach ( $categories as $c ) { ?>
	                    <option <?php if($c->term_id == get_option( "newsmaker_image_category" )) echo "selected"; ?> value="<?php echo $c->term_id ?>"><?php echo $c->name; ?></option>
	                <?php } ?>
	            </select>
	        </td>

	        <td>
	        	<select name="newsmaker_image_user">
	                <?php foreach ( $users as $u ) { ?>
	                    <option <?php if($u->ID == get_option( "newsmaker_image_user" )) echo "selected"; ?> value="<?php echo $u->ID ?>"><?php echo $u->user_nicename; ?></option>
	                <?php } ?>
	            </select>
	        </td>
        </tr>

        <tr valign="middle">
	        <th scope="row"><?php _e( "Videos", "wp-newsmaker" ); ?></th>
	        <td>
	        	<select name="newsmaker_video_category">
	                <?php foreach ( $categories as $c ) { ?>
	                    <option <?php if($c->term_id == get_option( "newsmaker_video_category" )) echo "selected"; ?> value="<?php echo $c->term_id ?>"><?php echo $c->name; ?></option>
	                <?php } ?>
	            </select>
	        </td>

	        <td>
	        	<select name="newsmaker_video_user">
	                <?php foreach ( $users as $u ) { ?>
	                    <option <?php if($u->ID == get_option( "newsmaker_video_user" )) echo "selected"; ?> value="<?php echo $u->ID ?>"><?php echo $u->user_nicename; ?></option>
	                <?php } ?>
	            </select>
	        </td>
        </tr>

        <tr valign="middle">
	        <th scope="row"><?php _e( "Polls", "wp-newsmaker" ); ?></th>
	        <td>
	        	<select name="newsmaker_poll_category">
	                <?php foreach ( $categories as $c ) { ?>
	                    <option <?php if($c->term_id == get_option( "newsmaker_poll_category" )) echo "selected"; ?> value="<?php echo $c->term_id ?>"><?php echo $c->name; ?></option>
	                <?php } ?>
	            </select>
	        </td>

	        <td>
	        	<select name="newsmaker_poll_user">
	                <?php foreach ( $users as $u ) { ?>
	                    <option <?php if($u->ID == get_option( "newsmaker_poll_user" )) echo "selected"; ?> value="<?php echo $u->ID ?>"><?php echo $u->user_nicename; ?></option>
	                <?php } ?>
	            </select>
	        </td>
        </tr>

        <tr valign="middle">
        	<th scope="row"><?php _e( "Default post status", "wp-newsmaker" ); ?></th>
        	<td>
        		<select name="newsmaker_post_status">
        			<option value="pending" <?php if(get_option("newsmaker_post_status") == "pending") echo "selected"; ?>><?php _e( "Pending", "wp-newsmaker" ); ?></option>
        			<option value="publish" <?php if(get_option("newsmaker_post_status") == "publish") echo "selected"; ?>><?php _e( "Publish", "wp-newsmaker" ); ?></option>
        			<option value="draft" <?php if(get_option("newsmaker_post_status") == "draft") echo "selected"; ?>><?php _e( "Draft", "wp-newsmaker" ); ?></option>
        		</select>
        	</td>
        </tr>
        
    </table>

		<?php submit_button(); ?>
	</form>
</div>