<?php
	global $wp_roles;
    $roles = $wp_roles->get_names();
?>

<div class="wrap">
	<h1><?php _e( "General options", "wp-newsmaker" ); ?></h1>

	<form method="post" action="options.php"> 

	<?php settings_fields( "newsmaker-settings-general" ); ?>

	<table class="form-table">

		<tr valign="middle">
	        <th scope="row"><?php _e("Default user role", "wp-newsmaker") ?></th>
	        <td>
	        	<select name="newsmaker_default_user_role">
	        		<?php foreach($roles as $role) { ?>
	        			<option value="<?php echo $role ?>" <?php if($role == get_option( "newsmaker_default_user_role", "Author" )) echo "selected"; ?>><?php echo ucfirst($role); ?></option>
	        		<?php } ?>
	        	</select><br>
	        	<small><?php _e("Recommended role is Author", "wp-newsmaker") ?></small>
	        </td>
        </tr>
        <tr valign="middle">
	        <th scope="row"><?php _e("Allow interests?", "wp-newsmaker") ?></th>
	        <td>
	        	<input type="checkbox" value="1" name="newsmaker_allow_interests" <?php checked( '1', get_option( 'newsmaker_allow_interests' ) ); ?>>
	        	<small><?php _e("Check this if you want to allow users to select favourite categories", "wp-newsmaker") ?></small>
	        </td>
        </tr>
        <tr valign="middle">
	        <th scope="row"><?php _e("Enable dynamic menu?", "wp-newsmaker") ?></th>
	        <td>
	        	<input type="checkbox" value="1" name="newsmaker_dynamic_menu" <?php checked( '1', get_option( 'newsmaker_dynamic_menu' ) ); ?>>
	        	<small><?php _e("Displays login/logout pages etc... (You must have custom menu added in order to make it work)", "wp-newsmaker") ?></small>
	        </td>
        </tr>
    </table>

	<?php submit_button(); ?>

	</form>

	

</div>