<style type="text/css">
	th{
		width: 300px !important;
	}
</style>

<div class="wrap">
	<h1><?php _e("Email settings", "wp-newsmaker") ?></h1>

	<form method="post" action="options.php"> 

		<?php settings_fields( "newsmaker-settings-email" ); ?>

		<table class="form-table">

			<tr valign="middle">
		        <th scope="row"><?php _e( "Receive email notification", "wp-newsmaker" ); ?>?</th>
		        <td>
		        	<input name="newsmaker_email_pending_post" type="checkbox" value="1" <?php checked( '1', get_option( 'newsmaker_email_pending_post' ) ); ?> />
		        	<small><?php _e( "Check this if you want to receive email notification when new post is submitted", "wp-newsmaker" ); ?></small>
		        </td>
	        </tr>

	        <tr valign="middle">
		        <th scope="row"><?php _e( "Notification email address", "wp-newsmaker" ); ?>?</th>
		        <td>
		        	<input type="text" name="newsmaker_email_admin_address" value="<?php echo get_option( 'newsmaker_email_admin_address' ) ?>" >
		        	<br><small><?php _e( "Email address(es) which will be used for email notifications", "wp-newsmaker" ); ?>.<br>
		        	<?php _e( "If you need multiple addresses, divide them with comma (example1@example.com, example2@example.com)", "wp-newsmaker" ); ?></small>
		        </td>
	        </tr>

	        <tr valign="middle">
	        	<th scope="row"><?php _e( "Email subject for admin", "wp-newsmaker" ); ?></th>
	        	<td>
	        		<input name="newsmaker_email_admin_subject" type="text" value="<?php echo get_option( 'newsmaker_email_admin_subject' ) ?>" /><br>
	        		<small><?php _e( "Email subject for admin notifications", "wp-newsmaker" ); ?></small>
	        	</td>
	        </tr>

	        <tr valign="middle">
	        	<th scope="row"><?php _e( "Email body for admin", "wp-newsmaker" ); ?></th>
	        	<td>
	        		<textarea name="newsmaker_email_admin_body"><?php echo get_option( 'newsmaker_email_admin_body' ) ?></textarea><br>
	        		<small><?php _e( "Email body for admin notifications", "wp-newsmaker" ); ?></small>
	        	</td>
	        </tr>

	        <tr>
	        	<td colspan="2"><hr></td>
	        </tr>

	        <tr valign="middle">
		        <th scope="row"><?php _e( "Enable email notifications for users", "wp-newsmaker" ); ?>?</th>
		        <td>
		        	<input name="newsmaker_email_user_notification" type="checkbox" value="1" <?php checked( '1', get_option( 'newsmaker_email_user_notification' ) ); ?> />
		        	<small><?php _e( "Check this if you want to allow users to receive email notifications when their posts are accepted", "wp-newsmaker" ); ?></small>
		        </td>
	        </tr>

	        <tr valign="middle">
	        	<th scope="row"><?php _e( "Email subject", "wp-newsmaker" ); ?></th>
	        	<td>
	        		<input name="newsmaker_email_user_subject" type="text" value="<?php echo get_option( 'newsmaker_email_user_subject', 'Your post is approved' ) ?>" /><br>
	        		<small><?php _e( "Email subject for user notifications", "wp-newsmaker" ); ?></small>
	        	</td>
	        </tr>

	        <tr valign="middle">
	        	<th scope="row"><?php _e( "Email body", "wp-newsmaker" ); ?></th>
	        	<td>
	        		<textarea name="newsmaker_email_user_body"><?php echo get_option( 'newsmaker_email_user_body', 'Hello &#13;&#13;Your post is approved.&#13;&#10;[[post]]' ) ?></textarea><br>
	        		<small><?php _e( "Email body for user notifications ( [[post]] will be replaced with post URL )", "wp-newsmaker" ); ?></small>
	        	</td>
	        </tr>

		</table>

		<?php submit_button(); ?>
	</form>
</div>