<?php

/*
Plugin Name: NewsMaker for Wordpress
Description: Newsmaker is a Wordpress plugin for user user-generated content. Now you can cultivate huge ammount of posts, links, images, videos and polls from your users.
Version: 1.1
Author: alenn
Author URI: http://codecanyon.net/user/alenn?ref=alenn
Text Domain: wp-newsmaker
*/

add_action('plugins_loaded', 'wan_load_textdomain');
function wan_load_textdomain() {
load_plugin_textdomain( 'wp-newsmaker', false, dirname( plugin_basename(__FILE__) ) . '/lang/' );
} 


register_activation_hook( __FILE__, "newsmaker_activate_plugin" );
register_deactivation_hook( __FILE__, 'newsmaker_deactivate_plugin' );

// register shortcodes for various forms
add_action("init", "newsmaker_register_shortcodes");

// initialize javascript and css
add_action("wp", "newsmaker_init_scripts");
add_action("admin_enqueue_scripts", "newsmaker_init_admin_scripts");

// check if user wants to be notified when his post is approved
add_action("publish_post", "newsmaker_publish_post_action");

// show if there is any pending posts
add_action('wp_before_admin_bar_render', 'newsmaker_admin_tool_bar', 999);

// fetch news when url is pasted
add_action("wp_ajax_newsmaker_process_link", "newsmaker_process_link");
add_action("wp_ajax_nopriv_newsmaker_process_link", "newsmaker_process_link");

// fetch image when url is pasted
add_action("wp_ajax_newsmaker_upload_image", "newsmaker_upload_image");
add_action("wp_ajax_nopriv_newsmaker_upload_image", "newsmaker_upload_image");

// fetch video when url is pasted
add_action("wp_ajax_newsmaker_fetch_video", "newsmaker_fetch_video");
add_action("wp_ajax_nopriv_newsmaker_fetch_video", "newsmaker_fetch_video");

// hide admin dashboard
add_filter('show_admin_bar', '__return_false');

// publish post
add_action("wp_ajax_newsmaker_post_publish", "newsmaker_post_publish");
add_action("wp_ajax_nopriv_newsmaker_post_publish", "newsmaker_post_publish");

// edit post
add_action("wp_ajax_newsmaker_post_edit", "newsmaker_post_edit");
add_action("wp_ajax_nopriv_newsmaker_post_edit", "newsmaker_post_edit");

// link publish
add_action("wp_ajax_newsmaker_link_publish", "newsmaker_link_publish");
add_action("wp_ajax_nopriv_newsmaker_link_publish", "newsmaker_link_publish");

// image publish
add_action("wp_ajax_newsmaker_process_image", "newsmaker_process_image");
add_action("wp_ajax_nopriv_newsmaker_process_image", "newsmaker_process_image");

// video publish
add_action("wp_ajax_newsmaker_process_video", "newsmaker_process_video");
add_action("wp_ajax_nopriv_newsmaker_process_video", "newsmaker_process_video");

// poll publish
add_action("wp_ajax_newsmaker_process_poll", "newsmaker_process_poll");
add_action("wp_ajax_nopriv_newsmaker_process_poll", "newsmaker_process_poll");

// poll edit
add_action("wp_ajax_newsmaker_process_edit_poll", "newsmaker_process_edit_poll");
add_action("wp_ajax_nopriv_newsmaker_process_edit_poll", "newsmaker_process_edit_poll");

// poll vote
add_action("wp_ajax_newsmaker_poll_vote", "newsmaker_poll_vote");
add_action("wp_ajax_nopriv_newsmaker_poll_vote", "newsmaker_poll_vote");

// show poll results
add_action("wp_ajax_newsmaker_show_poll_results", "newsmaker_show_poll_results");
add_action("wp_ajax_nopriv_newsmaker_show_poll_results", "newsmaker_show_poll_results");

// add source url for published links and answers for polls
add_action('the_content','newsmaker_before_loaded_content');

// register user
add_action("wp_ajax_newsmaker_register_user", "newsmaker_register_user");
add_action("wp_ajax_nopriv_newsmaker_register_user", "newsmaker_register_user");

// add dynamic items to menu
add_filter( 'wp_nav_menu_items', 'newsmaker_dynamic_menu', 10, 2 );

// change Edit URL
add_filter( 'get_edit_post_link', 'newsmaker_change_edit_url' );

// change email
add_action("wp_ajax_newsmaker_change_email", "newsmaker_change_email");
add_action("wp_ajax_nopriv_newsmaker_change_email", "newsmaker_change_email");

// change password
add_action("wp_ajax_newsmaker_change_password", "newsmaker_change_password");
add_action("wp_ajax_nopriv_newsmaker_change_password", "newsmaker_change_password");

// lost password form
add_action( 'wp_ajax_nopriv_lost_pass', 'newsmaker_lost_pass' );
add_action( 'wp_ajax_lost_pass', 'newsmaker_lost_pass' );

// reset password
add_action( 'wp_ajax_nopriv_reset_pass', 'newsmaker_reset_pass' );
add_action( 'wp_ajax_reset_pass', 'newsmaker_reset_pass' );

// filters posts with user interests
add_filter('pre_get_posts','newsmaker_change_interests');

add_filter("wp_list_pages_excludes", "newsmaker_hide_pages");

add_filter( 'wp_default_editor', create_function('', 'return "tinymce";') );

function newsmaker_hide_pages($array) {
    $pages = array(get_option( "newsmaker_editpost_page" ), get_option( "newsmaker_resetpassword_page" ), get_option( "newsmaker_forgotpassword_page" ));
    $array = array_merge($pages, $array);
    return $array;
}

function newsmaker_change_password(){
    $password = null;
    $new_password = null;
    $confirm_password = null;

    if(isset($_POST["password"])){
        $password = $_POST["password"];
    }
    if(isset($_POST["new_password"])){
        $new_password = $_POST["new_password"];
    }
    if(isset($_POST["confirm_password"])){
        $confirm_password = $_POST["confirm_password"];
    }

    $errors = array();
    $checker = false;
    if(!$password){
        array_push($errors, __("Password can't be empty", "wp-newsmaker"));
        $checker = true;
    }
    if(!$new_password){
        array_push($errors, __("New password can't be empty", "wp-newsmaker"));
        $checker = true;
    }

    $user = wp_get_current_user();
    $userdata = get_user_by('login', $user->user_login);

    if($password && !wp_check_password( $password, $user->data->user_pass, $user->ID)){
        array_push($errors, __("Current password is not correct", "wp-newsmaker"));
        $checker = true;
    }

    if(wp_check_password( $password, $userdata->user_pass, $user->ID)){
        if($new_password !== $confirm_password){
            array_push($errors, __("Passwords do not match", "wp-newsmaker"));
            $checker = true;
        }
    }

    if($checker){
        echo json_encode(array("response" => "error", "errors" => $errors));
        exit();
    }else{
        wp_set_password( $new_password, $user->ID );
        echo json_encode(array("response" => "ok"));
        exit();
    }
}

function newsmaker_change_email(){
    $user = wp_get_current_user();
    $email = null;
    if(isset($_POST["email"])){
        $email = $_POST["email"];
    }

    $u = wp_update_user(array("ID" => $user->ID, "user_email" => $email));
    if($u){
        echo json_encode(array("response" => "ok"));
        exit();
    }else{
        echo json_encode(array("response" => "error"));
        exit();
    }
}

function newsmaker_change_edit_url( $url) {
    if(!is_admin()){
        global $post;
        $user = get_current_user();
        $post = get_post( get_the_id() );
        $url = get_permalink( get_option("newsmaker_editpost_page"));
        if(strpos($url, "?")){
            $url = $url."&post_id=" . get_the_id();
        }else{
            $url = $url."?post_id=" . get_the_id();
        }
    }

    return $url;
}

function newsmaker_register_user(){
    $username = null;
    $email = null;
    $password = null;
    $confirm_password = null;

    if(isset($_POST["newsmaker_username"])){
        $username = $_POST["newsmaker_username"];
    }
    if(isset($_POST["newsmaker_email"])){
        $email = $_POST["newsmaker_email"];
    }
    if(isset($_POST["newsmaker_password"])){
        $password = $_POST["newsmaker_password"];
    }
    if(isset($_POST["newsmaker_confirm_password"])){
        $confirm_password = $_POST["newsmaker_confirm_password"];
    }

    $checker = false;
    $errors = array();
    if(!$username){
        array_push($errors, __("Username can't be empty", "wp-newsmaker"));
        $checker = true;
    }
    if(!$email || !filter_var($email, FILTER_VALIDATE_EMAIL)){
        array_push($errors, __("Enter a valid email", "wp-newsmaker"));
        $checker = true;
    }
    if(!$password){
        array_push($errors, __("Password can't be empty", "wp-newsmaker"));
        $checker = true;
    }
    if($password !== $confirm_password){
        array_push($errors, __("Passwords do not match", "wp-newsmaker"));
        $checker = true;    
    }

    if($username){
        if(get_userdatabylogin( $username )){
            array_push($errors, __("Username is taken", "wp-newsmaker"));
            $checker = true;
        }
    }

    if($email){
        if(get_user_by( "email", $email )){
            array_push($errors, __("Email is taken", "wp-newsmaker"));
            $checker = true;
        }
    }

    if($checker){
        echo json_encode(array("response" => "error", "errors" => $errors));
        exit();
    }else{
        $user_id = wp_create_user( $username, $password, $email );
        wp_update_user(
            array(
              'ID'          =>    $user_id,
              'nickname'    =>    $username,
              'role'        =>    strtolower(get_option("newsmaker_default_user_role", "Author"))
            )
          );

        echo json_encode(array("response" => "ok"));
        exit();
    }
}



function newsmaker_dynamic_menu( $items, $args ) {
    if(get_option( 'newsmaker_dynamic_menu' )){if ($args->theme_location == 'primary') {
        if (is_user_logged_in()) {
            $mycontent = null;
            $settings = null;
            $logout = '<li><a href="'. wp_logout_url(home_url()) .'">'.__("Log Out", "wp-newsmaker").'</a></li>';

            if(get_option("newsmaker_mycontent_page")){
                $mycontent = '<li><a href="'. get_permalink( get_option( "newsmaker_mycontent_page" ) ) .'">'.__("My content", "wp-newsmaker").'</a></li>';
            }
            if(get_option("newsmaker_settings_page")){
                $settings = '<li><a href="'. get_permalink( get_option( "newsmaker_settings_page" ) ) .'">'.__("Settings", "wp-newsmaker").'</a></li>';
            }

            $items .= $settings . $mycontent . $logout;
        }
        elseif (!is_user_logged_in()) {
            $login = null;
            $register = null;
            if(get_option( "newsmaker_login_page" )){
                $login = '<li><a href="'. get_permalink( get_option( "newsmaker_login_page" ) ) .'">Log In</a></li>';
            }
            if(get_option( "newsmaker_register_page" )){
                $register = '<li><a href="'. get_permalink( get_option( "newsmaker_register_page" ) ) .'">Register</a></li>';
            }
            $items .= $login . $register;
        }
    }}
    return $items;
}

function newsmaker_deactivate_plugin(){
    wp_delete_post( get_option("newsmaker_forgotpassword_page") );
    wp_delete_post( get_option("newsmaker_resetpassword_page") );
    wp_delete_post( get_option("newsmaker_editpost_page") );
}

function newsmaker_activate_plugin(){
    global $wpdb;
    $tablename1 = $wpdb->prefix."newsmaker_answers";
    $tablename2 = $wpdb->prefix."newsmaker_user_answer";

    if($wpdb->get_var("show tables like '$tablename1'") != $tablename1 && $wpdb->get_var("show tables like '$tablename2'") != $tablename2){
        $query = "CREATE TABLE $tablename1 (
            `id` int(11) NOT NULL AUTO_INCREMENT,
            `post_id` int(11) NOT NULL,
            `answer` varchar(255) NOT NULL,
            `position` int(11) NOT NULL,
            `points` int(11) NOT NULL DEFAULT '0',
            PRIMARY KEY (`id`)
        ) ENGINE=InnoDB DEFAULT CHARSET=latin1;
        CREATE TABLE $tablename2 (
            `id` int(11) NOT NULL AUTO_INCREMENT,
            `user_id` int(11) NOT NULL,
            `answer_id` int(11) NOT NULL,
            `post_id` int(11) NOT NULL,
            PRIMARY KEY (`id`)
        ) ENGINE=InnoDB DEFAULT CHARSET=latin1;";

        require_once(ABSPATH . "wp-admin/includes/upgrade.php");
        dbDelta($query);
    }

    // create 'forgot password' page
    $page['post_type']    = 'page';
    $page['post_parent']  = 0;
    $page['post_status']  = 'publish';
    $page['post_title']   = __("Forgot password", "wp-newsmaker");
    $page["post_content"] = "[newsmaker-user-forgotpassword]";

    $pageid = wp_insert_post ($page);
    update_option( 'newsmaker_forgotpassword_page', $pageid );
    if ($pageid == 0) { /* Add Page Failed */ }

    // create 'reset password' page
    $page['post_type']    = 'page';
    $page['post_parent']  = 0;
    $page['post_status']  = 'publish';
    $page['post_title']   = __("Reset password", "wp-newsmaker");
    $page["post_content"] = "[newsmaker-user-resetpassword]";

    $pageid = wp_insert_post ($page);
    update_option( 'newsmaker_resetpassword_page', $pageid );
    if ($pageid == 0) { /* Add Page Failed */ }

    // create 'edit post' page
    $page['post_type']    = 'page';
    $page['post_parent']  = 0;
    $page['post_status']  = 'publish';
    $page['post_title']   = __("Edit post", "wp-newsmaker");
    $page["post_content"] = "[newsmaker-user-posts-edit]";

    $pageid = wp_insert_post ($page);
    update_option( 'newsmaker_editpost_page', $pageid );
    if ($pageid == 0) { /* Add Page Failed */ }

}

function newsmaker_poll_vote(){
    global $wpdb;
    $id = $_POST["answer_id"];
    $post = $_POST["post_id"];
    if(is_user_logged_in()){
        
        $user = wp_get_current_user();

        $query = "select * from ".$wpdb->prefix."newsmaker_user_answer where user_id = $user->ID and post_id = $post";
        $res = $wpdb->get_results($query, ARRAY_A);

        if(count($res) <= 0){

            $query = array(
                "user_id" => $user->ID,
                "answer_id" => $id,
                "post_id" => $post
            );
            $wpdb->insert($wpdb->prefix."newsmaker_user_answer", $query);
            $query = "select points from ".$wpdb->prefix."newsmaker_answers where id = $id";
            $points = $wpdb->get_results($query, OBJECT);
            $points = (int)$points[0]->points + 1;

            $wpdb->update($wpdb->prefix."newsmaker_answers", array("points" => $points), array("id" => $id));
        }

        $post = get_post( $post );

        $query = "select answer, points from ".$wpdb->prefix."newsmaker_answers where post_id = $post->ID";
        $results = $wpdb->get_results($query, OBJECT);

        ob_start();

        ?>
        <div class="chart-horiz">
            <ul class="chart">
                <li class="title" title="<?php echo $post->post_title ?>"></li>
                <?php foreach($results as $r){ ?>
                    <li><?php echo $r->answer ?></li>
                    <li class="past"><span class="bar" data-number="<?php echo $r->points; ?>"></span><span class="number"><?php echo $r->points; ?></span></li>
                <?php } ?>
            </ul>
        </div>
    <?php 

        echo json_encode(array("response" => "ok", "view" => ob_get_clean()));
        exit();
    }else{

        if(!isset($_COOKIE["newsmaker_voted_on_".$post])){

            setcookie("newsmaker_voted_on_".$post, "voted", time() + (10 * 365 * 24 * 60 * 60), "/");

            $query = "select points from ".$wpdb->prefix."newsmaker_answers where id = $id";
            $points = $wpdb->get_results($query, OBJECT);

            $points = (int)$points[0]->points + 1;

            $wpdb->update($wpdb->prefix."newsmaker_answers", array("points" => $points), array("id" => $id));
        }

        $post = get_post( $post );

        $query = "select answer, points from ".$wpdb->prefix."newsmaker_answers where post_id = $post->ID";
        $results = $wpdb->get_results($query, OBJECT);
        
        ob_start();

        ?>
        <div class="chart-horiz">
            <ul class="chart">
                <li class="title" title="<?php echo $post->post_title ?>"></li>
                <?php foreach($results as $r){ ?>
                    <li><?php echo $r->answer ?></li>
                    <li class="past"><span class="bar" data-number="<?php echo $r->points; ?>"></span><span class="number"><?php echo $r->points; ?></span></li>
                <?php } ?>
            </ul>
        </div>
    <?php 

        echo json_encode(array("response" => "ok", "view" => ob_get_clean()));
        exit();
    }
}

function newsmaker_change_interests($query){

    if(get_option( 'newsmaker_allow_interests' )){
        $interests = null;

        if(is_user_logged_in()){

            $user = wp_get_current_user();
            $interests = get_user_meta( $user->ID, "newsmaker_interests", true );

        }else{

            if(!isset($_SESSION)) {
                session_start();
            }
            
            if(isset($_SESSION["newsmaker_interests"])){
                $interests = $_SESSION["newsmaker_interests"];
            }else{
                if(isset($_COOKIE["newsmaker_interests"])){
                    $interests = unserialize($_COOKIE["newsmaker_interests"]);
                }
            }

        }

        $tempArray = array();
        $counter = 0;

        $cat = get_terms( 'category', array(
            'orderby'    => 'count',
            'hide_empty' => 0,
        ) );

        $cIDS = array();
        foreach($cat as $value){
            array_push($cIDS, $value->term_id);
        }

        if(!$interests){
            $interests = array();
        }

        $interests = array_diff($cIDS, $interests);

        if(count($interests) > 0){

            if ($query->is_home) {
                $counter = 0;
                foreach ($interests as $value) {
                    $tempArray[$counter] = $value; 
                    $counter++;
                }
                $query->set('category__not_in', $tempArray);
            }
            if ($query->is_feed) {
                $counter=0;
                foreach ($interests as $value) {
                    $tempArray[$counter] = $value;
                    $counter++;
                }
                $query->set('category__not_in', $tempArray);
            }
            if ($query->is_search) {
                $counter=0;
                foreach ($interests as $value) {
                    $tempArray[$counter] = $value;
                    $counter++;
                }
                $query->set('category__not_in', $tempArray);
            }
            if (!is_admin() && $query->is_archive) {
                $counter=0;
                foreach ($interests as $value) {
                    $tempArray[$counter] = $value;
                    $counter++;
                }
                $query->set('category__not_in', $tempArray);
            }
        }
    }
}

function newsmaker_register_settings() {
    register_setting( "newsmaker-settings-page", "newsmaker_post_category" );
    register_setting( "newsmaker-settings-page", "newsmaker_link_category" );
    register_setting( "newsmaker-settings-page", "newsmaker_image_category" );
    register_setting( "newsmaker-settings-page", "newsmaker_video_category" );
    register_setting( "newsmaker-settings-page", "newsmaker_poll_category" );
    register_setting( "newsmaker-settings-page", "newsmaker_post_user" );
    register_setting( "newsmaker-settings-page", "newsmaker_link_user" );
    register_setting( "newsmaker-settings-page", "newsmaker_image_user" );
    register_setting( "newsmaker-settings-page", "newsmaker_video_user" );
    register_setting( "newsmaker-settings-page", "newsmaker_poll_user" );
    register_setting( "newsmaker-settings-page", "newsmaker_email_pending_post" );
    register_setting( "newsmaker-settings-email", "newsmaker_email_admin_address" );
    register_setting( "newsmaker-settings-email", "newsmaker_email_user_notification" );
    register_setting( "newsmaker-settings-email", "newsmaker_email_user_subject" );
    register_setting( "newsmaker-settings-email", "newsmaker_email_user_body" );
    register_setting( "newsmaker-settings-email", "newsmaker_email_admin_subject" );
    register_setting( "newsmaker-settings-email", "newsmaker_email_admin_subject" );
    register_setting( "newsmaker-settings-page", "newsmaker_post_status" );
    register_setting( "newsmaker-settings-page", "newsmaker_login_page" );
    register_setting( "newsmaker-settings-page", "newsmaker_register_page" );
    register_setting( "newsmaker-settings-page", "newsmaker_mycontent_page" );
    register_setting( "newsmaker-settings-page", "newsmaker_editpost_page" );
    register_setting( "newsmaker-settings-page", "newsmaker_settings_page" );
    register_setting( "newsmaker-settings-page", "newsmaker_forgotpassword_page" );
    register_setting( "newsmaker-settings-page", "newsmaker_resetpassword_page" );
    register_setting( "newsmaker-settings-general", "newsmaker_default_user_role" );
    register_setting( "newsmaker-settings-general", "newsmaker_allow_interests" );
    register_setting( "newsmaker-settings-general", "newsmaker_dynamic_menu" );
}

function newsmaker_before_loaded_content($content) {

    if(is_single()){
        
        global $post;
        $type = get_post_meta( $post->ID, "newsmaker_post_type", true );
        $source_url = get_post_meta( $post->ID, "newsmaker_url_container", true );

        if($source_url){
            
            if($source_url){
                $readFullArticle = __("Click here to visit this site NOW", "wp-newsmaker");
                $content .= "<a target='_blank' class='newsmaker_full_acticle' href='$source_url'>$readFullArticle</a>";
                
                return $content;
            }
        }else{
            if($type === "poll"){
                $content .= "<div class='newsmaker_additional_content'>";
                $checker = newsmaker_if_user_voted($post->ID);
                $content .= newsmaker_show_poll_answers($post->ID, $content);
                if($checker){
                    $content .= "<label class='newsmaker_show_results' data-post_id='$post->ID'>"._e('Show results', 'wp-newsmaker')."</label><br>";
                }
                $content .= "</div>";
            }
        }

    }

    return $content;

}

function newsmaker_show_poll_results(){
    
    include("includes/pollResults.php");
    
}

function newsmaker_if_user_voted($postID){

    if(is_user_logged_in()){
        global $wpdb;
        $user = wp_get_current_user();
        $userID = $user->ID;
        $query = "select * from ".$wpdb->prefix."newsmaker_user_answer where user_id = $userID and post_id = $postID";
        $result = $wpdb->get_results($query, ARRAY_A);
        if(count($result) > 0){
            return true;
        }else{
            return false;
        }
    }else{

        if(isset($_COOKIE["newsmaker_voted_on_".$postID])){
            return true;
        }else{
            return false;
        }
    }

}

function newsmaker_show_poll_answers($postID, $content){
    $post = get_post( $postID );

    $content .= "<strong>".$post->post_title."</strong><br><br>";

    global $wpdb;

    $query = "select id, answer, position from ".$wpdb->prefix."newsmaker_answers where post_id = $postID order by position";
    $answers = $wpdb->get_results($query, OBJECT);

    foreach($answers as $answer){
        $content .= "<label class='newsmaker_vote_button' data-answer_id='$answer->id' data-post_id='$postID'>$answer->answer</label><br>";
    }

    return $content;

}

function newsmaker_fetch_video(){
    $url = $_POST["url"];

    $data = array();

    $page = file_get_contents($url);
    if (!$page) return null;
    $matches = array();
    if (preg_match('/<title>(.*?)<\/title>/', $page, $matches)) {
        $data["title"] = $matches[1];
    }

    if(isset($url)){
        $data["video"] = wp_oembed_get($url);
    }

    echo json_encode(array("data" => $data, "response" => "ok"));
    exit();
}

function newsmaker_publish_post_action($post_id){
    if(get_post_meta($post_id, "newsmaker_notify_checker", true)){
        if(!is_user_logged_in()) {
            $to = get_post_meta($post_id, "newsmaker_notify_email", true);
            $name = get_post_meta($post_id, "newsmaker_notify_name", true);
        }else{
            $user = wp_get_current_user();
            $to = $user->user_email;
            $name = $user->user_firstname;
        }

        $msgTemp = get_option( 'newsmaker_email_user_body', 'Hello. <br><br>Your post is approved.<br><br>[[post]]' );
        $post = get_post( $post_id );
        $postURL = get_post_permalink( $post_id );
        $msgTemp = str_replace("[[post]]", $postURL, $msgTemp);

        $subject = get_option("newsmaker_email_user_subject", "Your post is approved");
        $message = nl2br($msgTemp);

        wp_mail($to, $subject, $message);


        delete_post_meta($post_id, "newsmaker_notify_checker");
        delete_post_meta($post_id, "newsmaker_notify_email");
        delete_post_meta($post_id, "newsmaker_notify_name");
    }

}

function newsmaker_admin_tool_bar($wp_admin_bar){
    global $wp_admin_bar;
    $post_type = 'post';
    $count = wp_count_posts($post_type);
    $args = array(
        'id' => 'mbe_posts_pending',
        'href' => admin_url('/edit.php?post_status=pending&post_type='.$post_type, 'http'),
        'parent' => 'top-secondary'
    );

    if($count->pending == 1 || $count->draft == 1){
        $title = ' '.__('Post awaiting moderation', 'wp-newsmaker');
    } else if($count->pending > 1 || $count->draft > 1){
        $title = ' '.__('Posts awaiting moderation', 'wp-newsmaker');
    }

    $args['meta']['title'] = $title;
    if($count->pending == 0){
        $display = '';
    } else{
        $display = '<span class="mbe-update-bubble">'.$count->pending.'</span><span class="mbe-ab-text-active">'.$title.'</span>';
    }
    $args['title'] = $display;
    $wp_admin_bar->add_node($args);
}

function newsmaker_process_link(){
    $url = $_POST["url"];

    $data = file_get_contents($url);

    if(!$data){
        echo "error";
    }
    $dom = new DomDocument;
    @$dom->loadHTML(mb_convert_encoding($data, 'HTML-ENTITIES', 'UTF-8'));

    $xpath = new DOMXPath($dom);
    $metas = $xpath->query('//*/meta[starts-with(@property, \'og:\')]');

    $og = array();

    foreach($metas as $meta){
        $property = str_replace('og:', '', $meta->getAttribute('property'));
        $content = $meta->getAttribute('content');
        $og[$property] = $content;
    }

    $otherMeta = get_meta_tags($url);

    if(!array_key_exists("description", $og)){
        if(array_key_exists("description", $otherMeta)){
            $og["description"] = $otherMeta["description"];
        }else{
            $start = strpos($data, '<p>');
            $end = strpos($data, '</p>', $start);
            $og["description"] = strip_tags(substr($data, $start, $end-$start+4));
        }
    }
    if(!array_key_exists("title", $og)){
        $matches = array();
        if (preg_match("/<title.*?>[\n\r\s]*(.*)[\n\r\s]*<\/title>/", $data, $matches)) {
            $og["title"] = $matches[1];
        }
    }
    if(!array_key_exists("image", $og)){
        preg_match_all('/<img[^>]+>/i',$data, $result);
        $og["images"] = $result;
    }

    echo json_encode($og);

    exit();
}

function newsmaker_init_admin_scripts(){
    wp_register_style("fontawesome", "//maxcdn.bootstrapcdn.com/font-awesome/4.3.0/css/font-awesome.min.css");
    wp_register_style("admin-main.css", plugins_url("css/admin-main.css", __FILE__));

    wp_register_script("admin-script-js", plugins_url("js/admin-script.js", __FILE__), array("jquery", "jquery-ui-core"));

    wp_enqueue_style("fontawesome");
    wp_enqueue_style("admin-main.css");

    wp_enqueue_script('jquery');
    wp_enqueue_script('jquery-ui-core');
    wp_enqueue_script("admin-script-js");
}

function newsmaker_init_scripts(){

    wp_register_style("jquery.multiselect.css", plugins_url("css/multiple-select.css", __FILE__));
    wp_register_style("jquery.tagit.css", plugins_url("css/jquery.tagit.css", __FILE__));
    wp_register_style("jquery.ui-zendesk.css", plugins_url("css/jquery.ui-zendesk.css", __FILE__));
    wp_register_style("jquery-ui-css", "http://code.jquery.com/ui/1.10.3/themes/smoothness/jquery-ui.css");
    wp_register_style("main.css", plugins_url("css/main.css", __FILE__));
    wp_register_style("fileupload.css", plugins_url("css/jquery.fileupload.css", __FILE__));
    wp_register_style("fontawesome", "//maxcdn.bootstrapcdn.com/font-awesome/4.3.0/css/font-awesome.min.css");


    wp_register_script("jquery.multiselect.min.js", plugins_url("js/jquery.multiple.select.js", __FILE__), array("jquery"));
    wp_register_script("script-js", plugins_url("js/script.js", __FILE__), array("jquery", "jquery-ui-core"));
    wp_register_script("tag-it-js", plugins_url("js/tag-it.js", __FILE__), array("jquery", "jquery-ui-widget", "jquery-ui-autocomplete", "jquery-ui-position", "jquery-effects-blind", "jquery-effects-highlight"));
    wp_register_script("nanobar-js", plugins_url("js/nanobar.min.js", __FILE__), array("jquery"));
    wp_register_script("fileupload-js", plugins_url("js/jquery.fileupload.js", __FILE__), array("jquery"));
    wp_register_script("ajaxform-js", plugins_url("js/ajaxform.js", __FILE__), array("jquery"));
    wp_register_script("horizBarChart-js", plugins_url("js/horizBarChart.js", __FILE__), array("jquery"));

    wp_enqueue_script('jquery');
    wp_enqueue_script('jquery-ui-core');
    wp_enqueue_script('jquery-effects-core');
    wp_enqueue_script('jquery-ui-sortable');
    
    wp_enqueue_script("jquery.multiselect.min.js");
    wp_enqueue_script("script-js");
    wp_enqueue_script("tag-it-js");
    wp_enqueue_script("fileupload-js");
    wp_enqueue_script("nanobar-js");
    wp_enqueue_script("ajaxform-js");
    wp_enqueue_script("horizBarChart-js");

    wp_enqueue_style("jquery-ui-css");
    wp_enqueue_style("jquery.multiselect.css");
    wp_enqueue_style("jquery.tagit.css");
    wp_enqueue_style("jquery.ui-zendesk.css");
    wp_enqueue_style("main.css");
    wp_enqueue_style("fileupload.css");
    wp_enqueue_style("fontawesome");

    $data = array(
        'ajaxURL' => home_url('/',$scheme='relative')
    );
    wp_localize_script( 'script-js', 'globalVars', $data );

    $trStrings = array(
        "pleaseWait" => __("Please wait", "wp-newsmaker"),
        "videoNotFound" => __("Video not found", "wp-newsmaker"),
        "successfullySubmited" => __("Successfully submited, you will be redirected to home page shortly", "wp-newsmaker"),
        "successfullyRegistered" => __("Successfully registered", "wp-newsmaker")
    );
    wp_localize_script( "script-js", "trString", $trStrings );

}

function newsmaker_register_shortcodes(){
    session_start();
    setcookie("newsmaker_interests", serialize($_SESSION["newsmaker_interests"]), (time() + (10 * 365 * 24 * 60 * 60)), "/");

    add_shortcode("newsmaker-publish-post", "newsmaker_short_post");
    add_shortcode("newsmaker-publish-link", "newsmaker_short_link");
    add_shortcode("newsmaker-publish-image", "newsmaker_short_image");
    add_shortcode("newsmaker-publish-video", "newsmaker_short_video");
    add_shortcode("newsmaker-publish-poll", "newsmaker_short_poll");
    add_shortcode("newsmaker-interests-form", "newsmaker_interests_form");
    add_shortcode("newsmaker-login-form", "newsmaker_login_form");
    add_shortcode("newsmaker-register-form", "newsmaker_register_form");
    add_shortcode("newsmaker-user-posts", "newsmaker_user_posts");
    add_shortcode("newsmaker-user-posts-edit", "newsmaker_user_posts_edit");
    add_shortcode("newsmaker-user-settings", "newsmaker_user_settings");
    add_shortcode("newsmaker-user-forgotpassword", "newsmaker_user_forgotpassword");
    add_shortcode("newsmaker-user-resetpassword", "newsmaker_user_resetpassword");
}

function newsmaker_user_resetpassword(){
    include("includes/reset_password.php");
}

function newsmaker_user_forgotpassword(){
    include("includes/forgot_password.php");
}

function newsmaker_user_settings(){
    include("includes/user_settings.php");
}

function newsmaker_user_posts_edit(){
    $id = null;
    $edit_post = null;
    if(isset($_GET["post_id"])){
        $id = $_GET["post_id"];
    }

    $edit_post = get_post( $id );
    if($edit_post){
        if ( $post->post_type == 'page' ) {
            if ( !current_user_can( 'edit_page', $edit_post->ID ) )
                return;
        } else {
            if ( !current_user_can( 'edit_post', $edit_post->ID ) )
                return;
        }
        $type = get_post_meta( $id, "newsmaker_post_type", true );

        if($type && $type == "poll"){
            include("includes/user_poll_edit.php");    
        }else{
            include("includes/user_posts_edit.php");
        }
    }
}

function newsmaker_user_posts(){
    include("includes/user_posts.php");
}

function newsmaker_register_form(){
    include("includes/register_form.php");
}

function newsmaker_login_form(){
    include("includes/login_form.php");
}

function newsmaker_short_poll(){

    include("includes/poll_form.php");

}

function newsmaker_process_edit_poll(){
    $title = $_POST["newsmaker_poll_title"];
    $id = $_POST["newsmaker_poll_id"];
    $poll_categories = null;
    $tags = null;
    $body = null;
    if(isset($_POST["newsmaker_poll_categories"])){
        $poll_categories = $_POST["newsmaker_poll_categories"];
    }
    if(isset($_POST["newsmaker_poll_tags"])){
        $tags = $_POST["newsmaker_poll_tags"];
    }
    if(isset($_POST["newsmaker_poll_body"])){
        $body = $_POST["newsmaker_poll_body"];
    }

    global $user_ID;

    $page['post_type']    = 'post';
    $page["ID"] = $id;
    $page['post_parent']  = 0;

    $page['post_title']   = $title;
    $page["post_content"] = $body;
    if(isset($post_categories)){
        $page["post_category"] = $poll_categories;
    }else{
        $page["post_category"] = get_option( "newsmaker_poll_category" );
    }


    wp_update_post ($page);

    wp_set_post_categories( $id, $poll_categories, false );
    wp_set_post_tags($id, $tags, false);

    if(isset($_FILES["newsmaker_poll_image"])) {
        if (!function_exists('wp_handle_upload')) require_once(ABSPATH . 'wp-admin/includes/file.php');
        $uploadedfile = $_FILES['newsmaker_poll_image'];
        $upload_overrides = array('test_form' => false);
        $movefile = wp_handle_upload($uploadedfile, $upload_overrides);
        if ($movefile) {
            $wp_filetype = $movefile['type'];
            $filename = $movefile['file'];
            $wp_upload_dir = wp_upload_dir();
            $attachment = array(
                'guid' => $wp_upload_dir['url'] . '/' . basename($filename),
                'post_mime_type' => $wp_filetype,
                'post_title' => preg_replace('/\.[^.]+$/', '', basename($filename)),
                'post_content' => '',
                'post_status' => 'inherit'
            );
            $attach_id = wp_insert_attachment($attachment, $filename);

            set_post_thumbnail($pageid, $attach_id);
            require_once( ABSPATH . 'wp-admin/includes/image.php' );

            $attach_data = wp_generate_attachment_metadata( $attach_id, $filename );
            wp_update_attachment_metadata( $attach_id, $attach_data );

        }
    }

    $answers = $_POST["newsmaker_answers"];

    global $wpdb;

    $answers = $_POST["newsmaker_answers"];

    $ans = implode(",", $answers);
    $query = "select id from ".$wpdb->prefix."newsmaker_answers where answer not in ('$ans') and post_id = '$id'";
    $results = $wpdb->get_results($query, OBJECT);
    
    foreach ($results as $key => $value) {
        $wpdb->delete($wpdb->prefix."newsmaker_answers", array("id" => $value->id));
        $wpdb->delete($wpdb->prefix."newsmaker_user_answer", array("answer_id" => $value->id));
    }

    $position = 1;

    foreach($answers as $answer){
        $query = "select * from ".$wpdb->prefix."newsmaker_answers where answer = '$answer' and post_id = '$id'";
        $r = $wpdb->get_results($query, OBJECT);

        if(count($r[0]) == 0){
            $wpdb->insert($wpdb->prefix."newsmaker_answers", array("answer" => $answer, "post_id" => $id, "position" => $position));
        }

        $position++;
    }

    add_post_meta( $pageid, "newsmaker_post_type", "poll", true );

    echo json_encode(array("response" => "ok", "redirect" => home_url()));
    exit();
}

function newsmaker_process_poll(){
    $title = $_POST["newsmaker_poll_title"];
    $poll_categories = null;
    $tags = null;
    $body = null;
    if(isset($_POST["newsmaker_poll_categories"])){
        $poll_categories = $_POST["newsmaker_poll_categories"];
    }
    if(isset($_POST["newsmaker_poll_tags"])){
        $tags = $_POST["newsmaker_poll_tags"];
    }
    if(isset($_POST["newsmaker_poll_body"])){
        $body = $_POST["newsmaker_poll_body"];
    }

    $post_categories = array($post_categories);

    global $user_ID;

    $page['post_type']    = 'post';
    $page['post_parent']  = 0;
    if(is_user_logged_in()){
        $page['post_author']  = $user_ID;

        if(is_user_admin()){
            $page['post_status']  = 'publish';
        }else if(!is_user_admin()){
            $page['post_status']  = get_option( "newsmaker_post_status", "pending" );
        }
    }else{
        if(get_option( "newsmaker_poll_user" )){
            $page['post_author'] = get_option( "newsmaker_poll_user" );
        }
        $page['post_status']  = get_option( "newsmaker_post_status", "pending" );
    }
    $page['post_title']   = $title;
    $page["post_content"] = $body;
    if(isset($post_categories)){
        $page["post_category"] = $post_categories;
    }else{
        $page["post_category"] = get_option( "newsmaker_poll_category" );
    }


    $pageid = wp_insert_post ($page);
    if ($pageid == 0) { /* Add Page Failed */ }

    $notify = false;
    if(isset($_POST["newsmaker_show_email_field"])){
        $notify = true;
    }

    if($notify){
        $notify_name = $_POST["newsmaker_notify_name"];
        $notify_email = $_POST["newsmaker_notify_email"];

        add_post_meta($pageid, "newsmaker_notify_checker", "true");
        add_post_meta($pageid, "newsmaker_notify_name", $notify_name);
        add_post_meta($pageid, "newsmaker_notify_email", $notify_email);
    }

    wp_set_post_tags($pageid, $tags, false);

    if(isset($_FILES["newsmaker_poll_image"])) {
        if (!function_exists('wp_handle_upload')) require_once(ABSPATH . 'wp-admin/includes/file.php');
        $uploadedfile = $_FILES['newsmaker_poll_image'];
        $upload_overrides = array('test_form' => false);
        $movefile = wp_handle_upload($uploadedfile, $upload_overrides);
        if ($movefile) {
            $wp_filetype = $movefile['type'];
            $filename = $movefile['file'];
            $wp_upload_dir = wp_upload_dir();
            $attachment = array(
                'guid' => $wp_upload_dir['url'] . '/' . basename($filename),
                'post_mime_type' => $wp_filetype,
                'post_title' => preg_replace('/\.[^.]+$/', '', basename($filename)),
                'post_content' => '',
                'post_status' => 'inherit'
            );
            $attach_id = wp_insert_attachment($attachment, $filename);

            set_post_thumbnail($pageid, $attach_id);
            require_once( ABSPATH . 'wp-admin/includes/image.php' );

            $attach_data = wp_generate_attachment_metadata( $attach_id, $filename );
            wp_update_attachment_metadata( $attach_id, $attach_data );

        }
    }

    $answers = $_POST["newsmaker_answers"];

    $position = 1;

    global $wpdb;
    $tablename = $wpdb->prefix."newsmaker_answers";
    foreach($answers as $answer){
        $newanswer = array(
            "answer" => $answer,
            "post_id" => $pageid,
            "position" => $position
        );

        $wpdb->insert($tablename, $newanswer);

        $position++;
    }

    add_post_meta( $pageid, "newsmaker_post_type", "poll", true );

    echo json_encode(array("response" => "ok", "redirect" => home_url()));
    exit();
}

function newsmaker_interests_process(){

    $interests = $_POST["interests"];
    $user = wp_get_current_user();

    if(is_user_logged_in()){

        delete_user_meta( $user->ID, "newsmaker_interests" );
        add_user_meta( $user->ID, "newsmaker_interests", $interests, true );

    }else{

        if(count($interests) > 0){
            session_start();
            $_SESSION["newsmaker_interests"] = $interests;
        }

    }

    include("includes/interests_form.php");

    echo "<br>";
    _e( "Interests are saved", "wp-newsmaker" );

}

function newsmaker_interests_form(){

    if(isset($_POST["newsmaker_interests_submit"])){

        newsmaker_interests_process();
        
    }else{

        include("includes/interests_form.php");

    }

}

function newsmaker_process_video(){

    $url = $_POST["newsmaker_video_url"];
    $title = $_POST["newsmaker_video_title"];
    $description = "";
    if(isset($_POST["newsmaker_video_description"])){
        $description = $_POST["newsmaker_video_description"];
    }

    global $user_ID;

    $page['post_type']    = 'post';
    $page['post_parent']  = 0;
    if(is_user_logged_in()){
        $page['post_author']  = $user_ID;

        if(is_user_admin()){
            $page['post_status']  = 'publish';
        }else if(!is_user_admin()){
            $page['post_status']  = get_option( "newsmaker_post_status", "pending" );
        }
    }else{
        $page['post_status']  = get_option( "newsmaker_post_status", "pending" );
    }
    $page['post_title']   = $title;
    $page["post_content"] = $description;

    $post_categories = array($post_categories);

    if(isset($post_categories)){
        $page["post_category"] = $post_categories;
    }else{
        if(get_option( "newsmaker_video_user" )){
            $page['post_author'] = get_option( "newsmaker_video_user" );
        }
        $page["post_category"] = get_option( "newsmaker_post_category" );
    }


    $pageid = wp_insert_post ($page);
    if ($pageid == 0) { /* Add Page Failed */ }

    $notify = false;
    if(isset($_POST["newsmaker_show_email_field"])){
        $notify = true;
    }

    if($notify){
        $notify_name = $_POST["newsmaker_notify_name"];
        $notify_email = $_POST["newsmaker_notify_email"];

        add_post_meta($pageid, "newsmaker_notify_checker", "true");
        add_post_meta($pageid, "newsmaker_notify_name", $notify_name);
        add_post_meta($pageid, "newsmaker_notify_email", $notify_email);
    }

    //$img_attach = htmlentities(wp_oembed_get($url));
    $newContent = $url . "<br><br>" . $description;

    $my_post = array(
        'ID'           => $pageid,
        'post_content' => $newContent
    );

    wp_update_post( $my_post );

    set_post_format( $pageid , "video");

    if(get_option( 'newsmaker_email_pending_post' )){
        $emails = array();
        if(count(get_option("newsmaker_email_admin_address")) > 1){
            foreach(get_option("newsmaker_email_admin_address") as $e){
                array_push($emails, $e);
            }
        }else{
            $emails = get_option("newsmaker_email_admin_address");
        }

        $subject = get_option( 'newsmaker_email_admin_subject' );
        $body = get_option("newsmaker_email_admin_body");

        if(is_array($emails) && count($emails) > 1){
            foreach($emails as $email){
                wp_mail( $email, $subject, $body );
            }
        }else{
            wp_mail( $emails, $subject, $body );
        }
    }

    echo json_encode(array("response" => "ok", "redirect" => home_url()));
    exit();

}

function newsmaker_short_video(){
    
    include("includes/video_form.php");

}

function newsmaker_post_edit(){
    $title = $_POST["newsmaker_post_title"];
    $body = $_POST["newsmaker_post_body"];
    $id = $_POST["newsmaker_post_id"];

    $post_categories = null;
    $tags = null;
    if(isset($_POST["newsmaker_post_categories"])){
        $post_categories = $_POST["newsmaker_post_categories"];
    }

    if($_POST["newsmaker_post_tags"]){
        $tags = $_POST["newsmaker_post_tags"];
    }
    
    $checker = false;

    if($checker){
        echo json_encode(array("response" => "error", "redirect" => home_url()));
        exit();
    }


    global $user_ID;

    $page["ID"] = $id;
    $page['post_type']    = 'post';
    $page['post_parent']  = 0;
    $page['post_title']   = $title;
    $page["post_content"] = $body;

    $pageid = wp_update_post ($page);

    if ($pageid == 0) { /* Add Page Failed */ }

    wp_set_post_categories( $id, $post_categories, false );
    wp_set_post_tags($id, $tags, false);

    if(isset($_FILES["newsmaker_post_image"])) {
        if (!function_exists('wp_handle_upload')) require_once(ABSPATH . 'wp-admin/includes/file.php');
        $uploadedfile = $_FILES['newsmaker_post_image'];
        $upload_overrides = array('test_form' => false);
        $movefile = wp_handle_upload($uploadedfile, $upload_overrides);
        if ($movefile) {
            $wp_filetype = $movefile['type'];
            $filename = $movefile['file'];
            $wp_upload_dir = wp_upload_dir();
            $attachment = array(
                'guid' => $wp_upload_dir['url'] . '/' . basename($filename),
                'post_mime_type' => $wp_filetype,
                'post_title' => preg_replace('/\.[^.]+$/', '', basename($filename)),
                'post_content' => '',
                'post_status' => 'inherit'
            );
            $attach_id = wp_insert_attachment($attachment, $filename);

            set_post_thumbnail($pageid, $attach_id);
            require_once( ABSPATH . 'wp-admin/includes/image.php' );

            $attach_data = wp_generate_attachment_metadata( $attach_id, $filename );
            wp_update_attachment_metadata( $attach_id, $attach_data );


        }
    }

    if(get_option( 'newsmaker_email_pending_post' )){
        $emails = array();
        if(count(get_option("newsmaker_email_admin_address")) > 1){
            foreach(get_option("newsmaker_email_admin_address") as $e){
                array_push($emails, $e);
            }
        }else{
            $emails = get_option("newsmaker_email_admin_address");
        }

        $subject = get_option( 'newsmaker_email_admin_subject' );
        $body = get_option("newsmaker_email_admin_body");

        if(is_array($emails) && count($emails) > 1){
            foreach($emails as $email){
                wp_mail( $email, $subject, $body );
            }
        }else{
            wp_mail( $emails, $subject, $body );
        }
    }

    echo json_encode(array("response" => "ok", "redirect" => home_url()));
    exit();
}

function newsmaker_post_publish(){
    $title = $_POST["newsmaker_post_title"];
    $body = $_POST["newsmaker_post_body"];
    $post_categories = null;
    $tags = null;
    if(isset($_POST["newsmaker_post_categories"])){
        $post_categories = $_POST["newsmaker_post_categories"];
    }
    if($_POST["newsmaker_post_tags"]){
        $tags = $_POST["newsmaker_post_tags"];
    }

    $post_categories = array($post_categories);
    
    $checker = false;

    if($checker){
        echo json_encode(array("response" => "error", "redirect" => home_url()));
        exit();
    }


    global $user_ID;

    $page['post_type']    = 'post';
    $page['post_parent']  = 0;
    if(is_user_logged_in()){
        $page['post_author']  = $user_ID;

        if(is_user_admin()){
            $page['post_status']  = 'publish';
        }else if(!is_user_admin()){
            $page['post_status']  = get_option( "newsmaker_post_status", "pending" );
        }
    }else{
        if(get_option( "newsmaker_post_user" )){
            $page['post_author'] = get_option( "newsmaker_post_user" );
        }
        $page['post_status']  = get_option( "newsmaker_post_status", "pending" );
    }
    $page['post_title']   = $title;
    $page["post_content"] = $body;
    if(isset($post_categories)){
        $page["post_category"] = $post_categories;
    }else{
        $page["post_category"] = get_option( "newsmaker_post_category" );
    }


    $pageid = wp_insert_post ($page);
    if ($pageid == 0) { /* Add Page Failed */ }

    $notify = false;
    if(isset($_POST["newsmaker_show_email_field"])){
        $notify = true;
    }

    if($notify){
        $notify_name = $_POST["newsmaker_notify_name"];
        $notify_email = $_POST["newsmaker_notify_email"];

        add_post_meta($pageid, "newsmaker_notify_checker", "true");
        add_post_meta($pageid, "newsmaker_notify_name", $notify_name);
        add_post_meta($pageid, "newsmaker_notify_email", $notify_email);
    }

    wp_set_post_tags($pageid, $tags, false);

    if(isset($_FILES["newsmaker_post_image"])) {
        if (!function_exists('wp_handle_upload')) require_once(ABSPATH . 'wp-admin/includes/file.php');
        $uploadedfile = $_FILES['newsmaker_post_image'];
        $upload_overrides = array('test_form' => false);
        $movefile = wp_handle_upload($uploadedfile, $upload_overrides);
        if ($movefile) {
            $wp_filetype = $movefile['type'];
            $filename = $movefile['file'];
            $wp_upload_dir = wp_upload_dir();
            $attachment = array(
                'guid' => $wp_upload_dir['url'] . '/' . basename($filename),
                'post_mime_type' => $wp_filetype,
                'post_title' => preg_replace('/\.[^.]+$/', '', basename($filename)),
                'post_content' => '',
                'post_status' => 'inherit'
            );
            $attach_id = wp_insert_attachment($attachment, $filename);

            set_post_thumbnail($pageid, $attach_id);
            require_once( ABSPATH . 'wp-admin/includes/image.php' );

            $attach_data = wp_generate_attachment_metadata( $attach_id, $filename );
            wp_update_attachment_metadata( $attach_id, $attach_data );


        }
    }

    if(get_option( 'newsmaker_email_pending_post' )){
        $emails = array();
        if(count(get_option("newsmaker_email_admin_address")) > 1){
            foreach(get_option("newsmaker_email_admin_address") as $e){
                array_push($emails, $e);
            }
        }else{
            $emails = get_option("newsmaker_email_admin_address");
        }

        $subject = get_option( 'newsmaker_email_admin_subject' );
        $body = get_option("newsmaker_email_admin_body");

        if(is_array($emails) && count($emails) > 1){
            foreach($emails as $email){
                wp_mail( $email, $subject, $body );
            }
        }else{
            wp_mail( $emails, $subject, $body );
        }
    }

    echo json_encode(array("response" => "ok", "redirect" => home_url()));
    exit();
}

function newsmaker_show_post_form($errs = null){

    include("includes/post_form.php");

}

function newsmaker_short_post($args, $content){

    newsmaker_show_post_form();

    return ob_get_clean();
    
}

function newsmaker_upload_image(){

    if(isset($_FILES["newsmaker_image_image"])) {
        if (!function_exists('wp_handle_upload')) require_once(ABSPATH . 'wp-admin/includes/file.php');
        $uploadedfile = $_FILES['newsmaker_image_image'];
        $upload_overrides = array('test_form' => false);
        $movefile = wp_handle_upload($uploadedfile, $upload_overrides);
        echo json_encode(array("message" => $movefile));
    }

    exit();
}

function newsmaker_process_image(){

    require_once(ABSPATH . 'wp-admin/includes/file.php');

    $title = $_POST["newsmaker_image_title"];
    $body = null;
    if(isset($_POST["newsmaker_image_description"])){
        $body = $_POST["newsmaker_image_description"];
    }
    $filename = $_POST["newsmaker_img_file"];
    $wp_filetype = $_POST["newsmaker_img_type"];

    global $user_ID;

    $page['post_type']    = 'post';
    $page['post_parent']  = 0;
    if(is_user_logged_in()){
        $page['post_author']  = $user_ID;

        if(is_user_admin()){
            $page['post_status']  = 'publish';
        }else if(!is_user_admin()){
            $page['post_status']  = get_option( "newsmaker_post_status", "pending" );
        }
    }else{
        if(get_option( "newsmaker_image_user" )){
            $page['post_author'] = get_option( "newsmaker_image_user" );
        }
        $page['post_status']  = get_option( "newsmaker_post_status", "pending" );
    }
    $page['post_title']   = $title;
    $page["post_content"] = $body;

    $post_categories = array($post_categories);

    if(isset($post_categories)){
        $page["post_category"] = $post_categories;
    }else{
        $page["post_category"] = get_option( "newsmaker_post_category" );
    }


    $pageid = wp_insert_post ($page);
    if ($pageid == 0) { /* Add Page Failed */ }

    $notify = false;
    if(isset($_POST["newsmaker_show_email_field"])){
        $notify = true;
    }

    if($notify){
        $notify_name = $_POST["newsmaker_notify_name"];
        $notify_email = $_POST["newsmaker_notify_email"];

        add_post_meta($pageid, "newsmaker_notify_checker", "true");
        add_post_meta($pageid, "newsmaker_notify_name", $notify_name);
        add_post_meta($pageid, "newsmaker_notify_email", $notify_email);
    }

    $imgHolder = empty($_POST["newsmaker_img_holder"]);
    if(isset($_POST["newsmaker_img_holder"]) && !$imgHolder){

        $imgID = null;

        require_once(ABSPATH . 'wp-admin/includes/media.php');
        require_once(ABSPATH . 'wp-admin/includes/file.php');
        require_once(ABSPATH . 'wp-admin/includes/image.php');

        $filename = $_POST["newsmaker_img_holder"];
        $media = media_sideload_image($filename, $pageid);

        if(!empty($media) && !is_wp_error($media)){
            $args = array(
                'post_type' => 'attachment',
                'posts_per_page' => -1,
                'post_status' => 'any',
                'post_parent' => $pageid
            );

            $attachments = get_posts($args);

            if(isset($attachments) && is_array($attachments)){
                foreach($attachments as $attachment){

                    $imgID = $attachment->ID;
                    break;

                }
            }
        }
        $img_id = wp_get_attachment_url($imgID);

        $img_attach = "<a href='$img_id'>";
        $img_attach .= $media;
        $img_attach .= "</a>";

    }else {

        $wp_upload_dir = wp_upload_dir();
        $attachment = array(
            'guid' => $wp_upload_dir['url'] . '/' . basename($filename),
            'post_mime_type' => $wp_filetype,
            'post_title' => preg_replace('/\.[^.]+$/', '', basename($filename)),
            'post_content' => '',
            'post_status' => 'inherit'
        );

        $attach_id = wp_insert_attachment($attachment, $filename);

        $img_id = wp_get_attachment_url($attach_id);

        $img_attach = "<a href='$img_id'>";
        $img_attach .= wp_get_attachment_image($attach_id, "full");
        $img_attach .= "</a>";

        $attach_data = wp_generate_attachment_metadata( $attach_id, $filename );
        wp_update_attachment_metadata( $attach_id, $attach_data );
    }

    $my_post = array(
        'ID'           => $pageid,
        'post_content' => $img_attach . "<br>" . $body
    );

    wp_update_post( $my_post );

    require_once( ABSPATH . 'wp-admin/includes/image.php' );

    

    set_post_format( $pageid , "image");

    if(get_option( 'newsmaker_email_pending_post' )){
        $emails = array();
        if(count(get_option("newsmaker_email_admin_address")) > 1){
            foreach(get_option("newsmaker_email_admin_address") as $e){
                array_push($emails, $e);
            }
        }else{
            $emails = get_option("newsmaker_email_admin_address");
        }

        $subject = get_option( 'newsmaker_email_admin_subject' );
        $body = get_option("newsmaker_email_admin_body");

        if(is_array($emails) && count($emails) > 1){
            foreach($emails as $email){
                wp_mail( $email, $subject, $body );
            }
        }else{
            wp_mail( $emails, $subject, $body );
        }
    }

    echo json_encode(array("response" => "ok", "redirect" => home_url()));
    exit();
}

function newsmaker_short_image($args, $content){

    require_once("includes/image_form.php");

}

function newsmaker_link_publish(){
    $title = $_POST["newsmaker_link_title"];
    $body = $_POST["newsmaker_link_body"];
    $post_categories = null;
    $tags = null;
    $source = null;
    if(isset($_POST["newsmaker_link_categories"])){
        $post_categories = $_POST["newsmaker_link_categories"];
    }
    if(isset($_POST["newsmaker_link_tags"])){
        $tags = $_POST["newsmaker_link_tags"];
    }
    if(isset($_POST["newsmaker_link_source"])){
        $source = $_POST["newsmaker_link_source"];
    }

    $post_categories = array($post_categories);


    $checker = false;

    if($checker){
        echo json_encode(array("response" => "error", "redirect" => home_url()));
        exit();
    }

    global $user_ID;

    $page['post_type']    = 'post';
    $page['post_parent']  = 0;
    if(is_user_logged_in()){
        $page['post_author']  = $user_ID;

        if(is_user_admin()){
            $page['post_status']  = 'publish';
        }else if(!is_user_admin()){
            $page['post_status']  = get_option( "newsmaker_post_status", "pending" );
        }
    }else{
        if(get_option( "newsmaker_link_user" )){
            $page['post_author'] = get_option( "newsmaker_link_user" );
        }
        $page['post_status']  = get_option( "newsmaker_post_status", "pending" );
    }
    $page['post_title']   = $title;
    $page["post_content"] = $body;
    $page["post_category"]= $post_categories;


    $pageid = wp_insert_post ($page);
    if ($pageid == 0) { /* Add Page Failed */ }

    $notify = false;
    if(isset($_POST["newsmaker_show_email_field"])){
        $notify = true;
    }

    if($notify){
        $notify_name = $_POST["newsmaker_notify_name"];
        $notify_email = $_POST["newsmaker_notify_email"];

        add_post_meta($pageid, "newsmaker_notify_checker", "true");
        add_post_meta($pageid, "newsmaker_notify_name", $notify_name);
        add_post_meta($pageid, "newsmaker_notify_email", $notify_email);
    }

    add_post_meta($pageid, "newsmaker_url_container", $source);

    wp_set_post_tags($pageid, $tags, false);

    if(isset($_FILES["newsmaker_link_image"])) {
        if (!function_exists('wp_handle_upload')) require_once(ABSPATH . 'wp-admin/includes/file.php');
        $uploadedfile = $_FILES['newsmaker_link_image'];
        $upload_overrides = array('test_form' => false);
        $movefile = wp_handle_upload($uploadedfile, $upload_overrides);
        if ($movefile) {
            $wp_filetype = $movefile['type'];
            $filename = $movefile['file'];
            $wp_upload_dir = wp_upload_dir();
            $attachment = array(
                'guid' => $wp_upload_dir['url'] . '/' . basename($filename),
                'post_mime_type' => $wp_filetype,
                'post_title' => preg_replace('/\.[^.]+$/', '', basename($filename)),
                'post_content' => '',
                'post_status' => 'inherit'
            );
            $attach_id = wp_insert_attachment($attachment, $filename);

            set_post_thumbnail($pageid, $attach_id);
            require_once( ABSPATH . 'wp-admin/includes/image.php' );

            $attach_data = wp_generate_attachment_metadata( $attach_id, $filename );
            wp_update_attachment_metadata( $attach_id, $attach_data );
        }
    }else{
        if(isset($_POST["newsmaker_image_holder"])) {
            $image_url  = $_POST["newsmaker_image_holder"];
            require_once(ABSPATH . 'wp-admin/includes/media.php');
            require_once(ABSPATH . 'wp-admin/includes/file.php');
            require_once(ABSPATH . 'wp-admin/includes/image.php');

            $image = $image_url;
            $media = media_sideload_image($image, $pageid);

            if(!empty($media) && !is_wp_error($media)) {
                $args = array(
                    'post_type' => 'attachment',
                    'posts_per_page' => -1,
                    'post_status' => 'any',
                    'post_parent' => $pageid
                );

                $attachments = get_posts($args);

                if (isset($attachments) && is_array($attachments)) {
                    foreach ($attachments as $attachment) {
                        $image = wp_get_attachment_image_src($attachment->ID, 'full');
                        if (strpos($media, $image[0]) !== false) {
                            set_post_thumbnail($pageid, $attachment->ID);
                            break;
                        }
                    }
                }
            }
        }
    }

    if(get_option( 'newsmaker_email_pending_post' )){
        $emails = array();
        if(count(get_option("newsmaker_email_admin_address")) > 1){
            foreach(get_option("newsmaker_email_admin_address") as $e){
                array_push($emails, $e);
            }
        }else{
            $emails = get_option("newsmaker_email_admin_address");
        }

        $subject = get_option( 'newsmaker_email_admin_subject' );
        $body = get_option("newsmaker_email_admin_body");

        if(is_array($emails) && count($emails) > 1){
            foreach($emails as $email){
                wp_mail( $email, $subject, $body );
            }
        }else{
            wp_mail( $emails, $subject, $body );
        }
    }

    echo json_encode(array("response" => "ok", "redirect" => home_url()));
    exit();
}

function newsmaker_show_link_form($errs = null){

    include("includes/link_form.php");

}

function newsmaker_short_link($args, $content){

    newsmaker_show_link_form();
    return ob_get_clean();

}

// *** Admin area *** //
add_action('admin_init', 'newsmaker_register_settings');

// create Newsmaker menu in admin dashboard
add_action("admin_menu", "newsmaker_admin_menu");

add_action("add_meta_boxes", "newsmaker_add_poll_answers_meta");

add_action("save_post", "newsmaker_save_meta_box");

function newsmaker_save_meta_box($post_id){

    if(defined("DOING_AUTOSAVE") && DOING_AUTOSAVE){
        return;
    }

    if(!current_user_can( "edit_posts" )){
        return;
    }

    if(isset($_POST["newsmaker_answers_admin"])){

        global $wpdb;

        $answers = $_POST["newsmaker_answers_admin"];

        $ans = implode(",", $answers);
        $query = "select id from ".$wpdb->prefix."newsmaker_answers where answer not in ('$ans') and post_id = '$post_id'";
        $results = $wpdb->get_results($query, OBJECT);
        
        foreach ($results as $key => $value) {
            $wpdb->delete($wpdb->prefix."newsmaker_answers", array("id" => $value->id));
            $wpdb->delete($wpdb->prefix."newsmaker_user_answer", array("answer_id" => $value->id));
        }

        $position = 1;

        foreach($answers as $answer){
            $query = "select * from ".$wpdb->prefix."newsmaker_answers where answer = '$answer' and post_id = '$post_id'";
            $r = $wpdb->get_results($query, OBJECT);

            if(count($r[0]) == 0){
                $wpdb->insert($wpdb->prefix."newsmaker_answers", array("answer" => $answer, "post_id" => $post_id, "position" => $position));
            }

            $position++;
        }
    }
}

function newsmaker_add_poll_answers_meta(){
    global $post;
    $post_type = get_post_meta( $post->ID, "newsmaker_post_type", true );
    if($post_type && $post_type == "poll"){
        add_meta_box( "newsmaker_answers_meta", __("Poll answers", "wp-newsmaker"), "newsmaker_answers_meta_function", "post" );
    }
}

function newsmaker_answers_meta_function(){
    include("includes/admin/answers_meta.php");
}

function newsmaker_admin_menu(){
    add_menu_page("Newsmaker", "Newsmaker", "manage_options", "newsmaker-main", "newsmaker_menu_page");
    add_submenu_page( "newsmaker-main", __("General settings", "wp-newsmaker"), __("General settings", "wp-newsmaker"), "manage_options", "newsmaker-admin-general", "newsmaker_admin_general" );
    add_submenu_page( "newsmaker-main", __("Email settings", "wp-newsmaker"), __("Email settings", "wp-newsmaker"), "manage_options", "newsmaker-admin-email", "newsmaker_admin_email" );
    add_submenu_page( "newsmaker-main", __("Pages settings", "wp-newsmaker"), __("Pages settings", "wp-newsmaker"), "manage_options", "newsmaker-admin-pages", "newsmaker_admin_pages" );
}

function newsmaker_menu_page(){
    require_once("includes/admin/front.php");
}

function newsmaker_admin_general(){
    require_once("includes/admin/general.php");
}

function newsmaker_admin_email(){
    require_once("includes/admin/email.php");
}

function newsmaker_admin_pages(){
    require_once("includes/admin/pages.php");
}

function newsmaker_lost_pass() {
    
    global $wpdb, $wp_hasher;
    
    $nonce = $_POST['nonce'];
    
    if ( ! wp_verify_nonce( $nonce, 'rs_user_lost_password_action' ) )
        die ( 'Security checked!');
    
    $user_login = $_POST['user_login'];
    
    $errors = new WP_Error();
 
    if ( empty( $user_login ) ) {
        $errors->add('empty_username', __('<strong>ERROR</strong>: Enter a username or e-mail address.'));
    } else if ( strpos( $user_login, '@' ) ) {
        $user_data = get_user_by( 'email', trim( $user_login ) );
        if ( empty( $user_data ) )
            $errors->add('invalid_email', __('<strong>ERROR</strong>: There is no user registered with that email address.'));
    } else {
        $login = trim( $user_login );
        $user_data = get_user_by('login', $login);
    }

    do_action( 'lostpassword_post' );
 
    if ( ! $user_data )
        $errors->add('invalidcombo', __('<strong>ERROR</strong>: Invalid username or e-mail.'));
    $user_login = $user_data->user_login;
    $user_email = $user_data->user_email;
    $allow = apply_filters( 'allow_password_reset', true, $user_data->ID );
 
    if ( ! $allow )
        $errors->add('no_password_reset', __('Password reset is not allowed for this user'));

    $key = wp_generate_password( 20, false );
    do_action( 'retrieve_password_key', $user_login, $key );
 
    if ( empty( $wp_hasher ) ) {
        require_once ABSPATH . 'wp-includes/class-phpass.php';
        $wp_hasher = new PasswordHash( 8, true );
    }
    $hashed = $wp_hasher->HashPassword( $key );
    $wpdb->update( $wpdb->users, array( 'user_activation_key' => $hashed ), array( 'user_login' => $user_login ) );

    $resetPasswordPage = "wp-login.php";
    if(get_option( "newsmaker_resetpassword_page" )){
        $resetPasswordPage = get_permalink(get_option("newsmaker_resetpassword_page"));
    }
 
    $message = __('Someone requested that the password be reset for the following account:') . "\r\n\r\n";
    $message .= network_home_url( '/' ) . "\r\n\r\n";
    $message .= sprintf(__('Username: %s'), $user_login) . "\r\n\r\n";
    $message .= __('If this was a mistake, just ignore this email and nothing will happen.') . "\r\n\r\n";
    $message .= __('To reset your password, visit the following address:') . "\r\n\r\n";
    $message .= $resetPasswordPage."?action=rp&key=$key&login=" . rawurlencode($user_login) . "\r\n";
    $message = nl2br($message);

    if ( is_multisite() )
        $blogname = $GLOBALS['current_site']->site_name;
    else
        $blogname = wp_specialchars_decode(get_option('blogname'), ENT_QUOTES);
 
    $title = sprintf( __('[%s] Password Reset'), $blogname );
    $title = apply_filters( 'retrieve_password_title', $title );
    $message = apply_filters( 'retrieve_password_message', $message, $key );

    if ( wp_mail( $user_email, wp_specialchars_decode( $title ), $message ) )
        $errors->add('confirm', __('Check your e-mail for the confirmation link.'), 'message');
    else
        $errors->add('could_not_sent', __('The e-mail could not be sent.') . "<br />\n" . __('Possible reason: your host may have disabled the mail() function.'), 'message');
    if ( $errors->get_error_code() )
        echo '<p class="error">'. $errors->get_error_message( $errors->get_error_code() ) .'</p>';
    die();
}

function newsmaker_reset_pass() {
    
    $errors = new WP_Error();
    $nonce = $_POST['nonce'];
    
    if ( ! wp_verify_nonce( $nonce, 'rs_user_reset_password_action' ) )
        die ( 'Security checked!');
    
    $pass1     = $_POST['pass1'];
    $pass2     = $_POST['pass2'];
    $key     = $_POST['user_key'];
    $login     = $_POST['user_login'];
    
    $user = check_password_reset_key( $key, $login );
 
    if( empty( $pass1 ) || empty( $pass2 ) )
        $errors->add( 'password_required', __( 'Password is required field' ) );
 
    if ( isset( $pass1 ) && $pass1 != $pass2 )
        $errors->add( 'password_reset_mismatch', __( 'The passwords do not match.' ) );

    do_action( 'validate_password_reset', $errors, $user );
 
    if ( ( ! $errors->get_error_code() ) && isset( $pass1 ) && !empty( $pass1 ) ) {
        reset_password($user, $pass1);
        
        $errors->add( 'password_reset', __( 'Your password has been reset.' ) );
    }

    if ( $errors->get_error_code() )
        echo '<p class="error">'. $errors->get_error_message( $errors->get_error_code() ) .'</p>';
    die();
}