<?php
/**
 * The WordPress Plugin Boilerplate.
 *
 * A foundation off of which to build well-documented WordPress plugins that
 * also follow WordPress Coding Standards and PHP best practices.
 *
 * @package   The7_Disable_Web_Fonts
 * @author    Dream Theme
 * @license   GPL-2.0+
 * @link      http://dream-theme.com
 * @copyright 2014 Dream Theme
 *
 * @wordpress-plugin
 * Plugin Name:       The7 disable web fonts
 * Description:       Removes web fonts from theme
 * Version:           1.0.0
 * Author:            Dream Theme
 * Author URI:        http://dream-theme.com
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * WordPress-Plugin-Boilerplate: v2.6.1
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/*----------------------------------------------------------------------------*
 * Public-Facing Functionality
 *----------------------------------------------------------------------------*/

add_filter( 'optionsframework_get_web_fonts_defaults', 'the7_dwf_remove_web_fonts_from_backend', 20 );

/**
 * Removes web fonts list from theme options
 * @return array Empty array
 */
function the7_dwf_remove_web_fonts_from_backend() {
	return array();
}

if ( ! function_exists( 'presscore_enqueue_web_fonts' ) ) :

	/**
	 * Override helper that enqueue web fonts with empty function
	 */
	function presscore_enqueue_web_fonts() {}

endif;
